/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import jp.sourceforge.jindolf.Jindolf;

public class GUIUtils {
    public static AffineTransform AFFINETX_IDENTITY = new AffineTransform();
    public static Font DEFAULT_FONT = Font.decode("Dialog");
    public static FontRenderContext DEFAULT_FRC = new FontRenderContext(AFFINETX_IDENTITY, true, true);
    private static final String logoSource = "resources/image/logo.png";
    private static final String windowIconSource = "resources/image/winicon.png";
    private static final String wwwSource = "resources/image/www.png";
    private static Image logoImage;
    private static Icon logoIcon;
    private static Image windowIconImage;
    private static Icon wwwIcon;
    private static final RenderingHints qualityHints;
    private static final RenderingHints speedyHints;
    private static final Runnable taskNothing;

    public static RenderingHints getQualityHints() {
        return qualityHints;
    }

    public static Image loadImageFromResource(String string) throws IOException {
        URL uRL = Jindolf.getResource(string);
        BufferedImage bufferedImage = ImageIO.read(uRL);
        return bufferedImage;
    }

    public static Image getLogoImage() {
        Image image;
        if (logoImage != null) {
            return logoImage;
        }
        try {
            image = GUIUtils.loadImageFromResource(logoSource);
        }
        catch (IOException iOException) {
            Jindolf.logger.log(Level.WARNING, "\u30ed\u30b4\u30a4\u30e1\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", iOException);
            image = new BufferedImage(100, 100, 2);
        }
        logoImage = image;
        return logoImage;
    }

    public static Image getWindowIconImage() {
        Image image;
        if (windowIconImage != null) {
            return windowIconImage;
        }
        try {
            image = GUIUtils.loadImageFromResource(windowIconSource);
        }
        catch (IOException iOException) {
            Jindolf.logger.log(Level.WARNING, "\u30a2\u30a4\u30b3\u30f3\u30a4\u30e1\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", iOException);
            image = GUIUtils.getLogoImage();
        }
        windowIconImage = image;
        return windowIconImage;
    }

    public static Icon getLogoIcon() {
        if (logoIcon != null) {
            return logoIcon;
        }
        ImageIcon imageIcon = new ImageIcon(GUIUtils.getLogoImage());
        logoIcon = imageIcon;
        return logoIcon;
    }

    public static Icon getWWWIcon() {
        if (wwwIcon != null) {
            return wwwIcon;
        }
        URL uRL = Jindolf.getResource(wwwSource);
        wwwIcon = new ImageIcon(uRL);
        return wwwIcon;
    }

    public static void dispatchEmptyAWTEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(taskNothing);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getDirection(Rectangle rectangle, Point point) {
        if (point.y < rectangle.y) {
            return 1;
        }
        if (rectangle.y + rectangle.height <= point.y) {
            return 5;
        }
        if (point.x < rectangle.x) {
            return 3;
        }
        if (rectangle.x + rectangle.width <= point.x) {
            return 7;
        }
        return 0;
    }

    public static void modifyWindowAttributes(Window window, boolean bl, boolean bl2, boolean bl3) {
        Toolkit toolkit = window.getToolkit();
        toolkit.setDynamicLayout(bl2);
        window.setLocationByPlatform(bl3);
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            frame.setIconImage(GUIUtils.getWindowIconImage());
            frame.setResizable(bl);
        } else if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            dialog.setResizable(bl);
        }
    }

    public static void forceMonoPitchFont(JComponent jComponent) {
        JTextComponent jTextComponent;
        Font font = jComponent.getFont();
        int n = font.getStyle();
        int n2 = font.getSize();
        Font font2 = new Font("Monospaced", n, n2);
        jComponent.setFont(font2);
        if (jComponent instanceof JTextComponent && !(jTextComponent = (JTextComponent)jComponent).isEditable()) {
            jTextComponent.setCaretPosition(0);
        }
        jComponent.revalidate();
    }

    private GUIUtils() {
        assert (false);
        throw new Error();
    }

    static {
        taskNothing = new Runnable(){

            public void run() {
            }
        };
        qualityHints = new RenderingHints(null);
        speedyHints = new RenderingHints(null);
        qualityHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        speedyHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        speedyHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        qualityHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        speedyHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        qualityHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        speedyHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        qualityHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        speedyHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        qualityHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        speedyHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        qualityHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        speedyHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        qualityHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        speedyHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        qualityHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        speedyHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
    }
}

