/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingConstants;
import jp.sourceforge.jindolf.AbstractTextRow;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.SequenceCharacterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphDraw
extends AbstractTextRow
implements SwingConstants {
    private static final Color COLOR_SELECTION = new Color(12111845);
    private static final Color COLOR_SEARCHHIT = new Color(11711232);
    private static final Color COLOR_HOTTARGET = Color.ORANGE;
    private Color foregroundColor = Color.WHITE;
    private final CharSequence source;
    private float[] dimArray;
    private final List<GlyphVector> lines = new LinkedList<GlyphVector>();
    private Collection<Anchor> anchorSet;
    private final List<MatchInfo> matchList = new LinkedList<MatchInfo>();
    private MatchInfo hotTarget = null;
    private int selectStart = -1;
    private int selectLast = -1;

    public GlyphDraw(CharSequence charSequence) {
        this.source = charSequence;
        SequenceCharacterIterator sequenceCharacterIterator = new SequenceCharacterIterator(this.source);
        GlyphVector glyphVector = this.font.createGlyphVector(this.renderContext, sequenceCharacterIterator);
        int n = glyphVector.getNumGlyphs();
        this.dimArray = glyphVector.getGlyphPositions(0, n + 1, null);
    }

    public Color getColor() {
        return this.foregroundColor;
    }

    public void setColor(Color color) {
        this.foregroundColor = color;
    }

    public void setAnchorSet(Collection<Anchor> collection) {
        this.anchorSet = collection;
    }

    public float getSpan(int n, int n2) {
        float f = this.dimArray[n * 2];
        float f2 = this.dimArray[(n2 + 1) * 2];
        float f3 = f2 - f;
        return f3;
    }

    protected GlyphVector createLine(int n, int n2) {
        SequenceCharacterIterator sequenceCharacterIterator = new SequenceCharacterIterator(this.source, n, n2 + 1);
        GlyphVector glyphVector = this.font.createGlyphVector(this.renderContext, sequenceCharacterIterator);
        this.lines.add(glyphVector);
        return glyphVector;
    }

    @Override
    public Rectangle setWidth(int n) {
        return this.setWidth((float)n);
    }

    public Rectangle setWidth(float f) {
        int n;
        int n2;
        this.lines.clear();
        SequenceCharacterIterator sequenceCharacterIterator = new SequenceCharacterIterator(this.source);
        int n3 = n2 = sequenceCharacterIterator.getIndex();
        while (true) {
            if ((n = sequenceCharacterIterator.current()) == 65535) {
                if (n2 >= n3) break;
                this.createLine(n2, n3 - 1);
                break;
            }
            if (n == 10) {
                this.createLine(n2, n3);
                n2 = ++n3;
                sequenceCharacterIterator.next();
                continue;
            }
            float f2 = this.getSpan(n2, n3);
            if (f2 > f) {
                if (n2 < n3) {
                    this.createLine(n2, n3 - 1);
                    n2 = n3;
                    continue;
                }
                this.createLine(n2, n3);
                n2 = ++n3;
                sequenceCharacterIterator.next();
                continue;
            }
            ++n3;
            sequenceCharacterIterator.next();
        }
        n = 0;
        int n4 = 0;
        for (GlyphVector glyphVector : this.lines) {
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            Rectangle rectangle = rectangle2D.getBounds();
            n = Math.max(n, rectangle.width);
            n4 += rectangle.height;
        }
        this.bounds.width = n;
        this.bounds.height = n4;
        return this.bounds;
    }

    @Override
    public void setFontInfo(Font font, FontRenderContext fontRenderContext) {
        super.setFontInfo(font, fontRenderContext);
        SequenceCharacterIterator sequenceCharacterIterator = new SequenceCharacterIterator(this.source);
        GlyphVector glyphVector = this.font.createGlyphVector(this.renderContext, sequenceCharacterIterator);
        int n = glyphVector.getNumGlyphs();
        this.dimArray = glyphVector.getGlyphPositions(0, n + 1, null);
        int n2 = this.getWidth();
        this.setWidth(n2);
    }

    public int getCharIndex(Point point) {
        if (!this.bounds.contains(point)) {
            return -1;
        }
        int n = 0;
        int n2 = this.bounds.x;
        int n3 = this.bounds.y;
        for (GlyphVector glyphVector : this.lines) {
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            Rectangle rectangle = rectangle2D.getBounds();
            rectangle.x = n2;
            rectangle.y = n3;
            int n4 = glyphVector.getNumGlyphs();
            if (rectangle.contains(point)) {
                for (int i = 0; i < n4; ++i) {
                    float f = this.getSpan(n, n + i);
                    if (!(f + (float)n2 > (float)point.x)) continue;
                    return n + i;
                }
                return -1;
            }
            n3 += rectangle.height;
            n += n4;
        }
        return -1;
    }

    @Override
    public Appendable appendSelected(Appendable appendable) throws IOException {
        if (this.selectStart < 0 || this.selectLast < 0) {
            return appendable;
        }
        CharSequence charSequence = this.source.subSequence(this.selectStart, this.selectLast + 1);
        appendable.append(charSequence);
        return appendable;
    }

    @Override
    public void clearSelect() {
        this.selectStart = -1;
        this.selectLast = -1;
    }

    public void select(int n, int n2) {
        if (n < n2) {
            this.selectStart = n;
            this.selectLast = n2;
        } else {
            this.selectStart = n2;
            this.selectLast = n;
        }
        this.selectLast = Math.min(this.source.length() - 1, this.selectLast);
    }

    @Override
    public void drag(Point point, Point point2) {
        int n;
        int n2;
        if (point.y > point2.y || point.y == point2.y && point.x > point2.x) {
            Point point3 = point;
            point = point2;
            point2 = point3;
        }
        if ((n2 = GUIUtils.getDirection(this.bounds, point)) == (n = GUIUtils.getDirection(this.bounds, point2)) && (n2 == 1 || n2 == 5)) {
            this.clearSelect();
            return;
        }
        int n3 = -1;
        int n4 = -1;
        if (n2 == 1) {
            n3 = 0;
        }
        if (n == 5) {
            n4 = this.source.length() - 1;
        }
        if (n3 < 0) {
            n3 = this.getCharIndex(point);
        }
        if (n4 < 0) {
            n4 = this.getCharIndex(point2);
        }
        if (n3 >= 0 && n4 >= 0) {
            this.select(n3, n4);
            return;
        }
        int n5 = this.bounds.x;
        int n6 = this.bounds.y;
        int n7 = 0;
        for (GlyphVector glyphVector : this.lines) {
            int n8;
            int n9 = n7;
            int n10 = n7 + glyphVector.getNumGlyphs() - 1;
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            Rectangle rectangle = rectangle2D.getBounds();
            rectangle.x += n5;
            rectangle.y = n6;
            if (n3 < 0 && GUIUtils.getDirection(rectangle, point) == 5) {
                n6 += rectangle.height;
                n7 = n10 + 1;
                continue;
            }
            if (n4 < 0 && GUIUtils.getDirection(rectangle, point2) == 1) break;
            if (n3 < 0) {
                n8 = GUIUtils.getDirection(rectangle, point);
                if (n8 == 3) {
                    n3 = n9;
                } else if (n8 == 7) {
                    n3 = n10 + 1;
                }
            }
            if (n4 < 0) {
                n8 = GUIUtils.getDirection(rectangle, point2);
                if (n8 == 3) {
                    n4 = n9 - 1;
                } else if (n8 == 7) {
                    n4 = n10;
                }
            }
            if (n3 >= 0 && n4 >= 0) {
                this.select(n3, n4);
                return;
            }
            n6 += rectangle.height;
            n7 = n10 + 1;
        }
        this.clearSelect();
    }

    private void paintRegexHitted(Graphics2D graphics2D) {
        if (this.matchList.size() <= 0) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getAscent();
        int n2 = this.bounds.x;
        int n3 = this.bounds.y + n;
        int n4 = 0;
        for (GlyphVector glyphVector : this.lines) {
            int n5 = n4;
            int n6 = n4 + glyphVector.getNumGlyphs() - 1;
            for (MatchInfo matchInfo : this.matchList) {
                int n7 = matchInfo.getStartPos();
                int n8 = matchInfo.getEndPos() - 1;
                if (n8 < n5) continue;
                if (n6 < n7) break;
                int n9 = Math.max(n7, n5);
                int n10 = Math.min(n8, n6);
                Shape shape = glyphVector.getGlyphLogicalBounds(n9 - n5);
                Rectangle rectangle = shape.getBounds();
                shape = glyphVector.getGlyphLogicalBounds(n10 - n5);
                rectangle.add(shape.getBounds());
                if (matchInfo == this.hotTarget) {
                    graphics2D.setColor(COLOR_HOTTARGET);
                } else {
                    graphics2D.setColor(COLOR_SEARCHHIT);
                }
                graphics2D.fillRect(n2 + rectangle.x, n3 + rectangle.y, rectangle.width, rectangle.height);
            }
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            Rectangle object2 = rectangle2D.getBounds();
            n3 += object2.height;
            n4 = n6 + 1;
        }
    }

    private void paintSelected(Graphics2D graphics2D) {
        if (this.selectStart < 0 || this.selectLast < 0) {
            return;
        }
        graphics2D.setColor(COLOR_SELECTION);
        int n = this.bounds.x;
        int n2 = this.bounds.y;
        int n3 = 0;
        for (GlyphVector glyphVector : this.lines) {
            int n4 = n3;
            int n5 = n3 + glyphVector.getNumGlyphs() - 1;
            if (this.selectLast < n4) break;
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            Rectangle rectangle = rectangle2D.getBounds();
            if (n5 < this.selectStart) {
                n2 += rectangle.height;
                n3 = n5 + 1;
                continue;
            }
            int n6 = Math.max(this.selectStart, n4);
            int n7 = Math.min(this.selectLast, n5);
            Shape shape = glyphVector.getGlyphLogicalBounds(n6 - n4);
            Rectangle rectangle2 = shape.getBounds();
            shape = glyphVector.getGlyphLogicalBounds(n7 - n4);
            rectangle2.add(shape.getBounds());
            graphics2D.fillRect(n + rectangle2.x, n2, rectangle2.width, rectangle2.height);
            n2 += rectangle.height;
            n3 = n5 + 1;
        }
    }

    private void paintAnchorBack(Graphics2D graphics2D) {
        if (this.anchorSet == null) {
            return;
        }
        if (this.anchorSet.size() <= 0) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getAscent();
        graphics2D.setColor(Color.GRAY);
        int n2 = this.bounds.x;
        int n3 = this.bounds.y + n;
        int n4 = 0;
        for (GlyphVector glyphVector : this.lines) {
            int n5 = n4;
            int n6 = n4 + glyphVector.getNumGlyphs() - 1;
            for (Anchor anchor : this.anchorSet) {
                int n7 = anchor.getStartPos();
                int n8 = anchor.getEndPos() - 1;
                if (n8 < n5) continue;
                if (n6 < n7) break;
                int n9 = Math.max(n7, n5);
                int n10 = Math.min(n8, n6);
                Shape shape = glyphVector.getGlyphLogicalBounds(n9 - n5);
                Rectangle rectangle = shape.getBounds();
                shape = glyphVector.getGlyphLogicalBounds(n10 - n5);
                rectangle.add(shape.getBounds());
                graphics2D.fillRect(n2 + rectangle.x, n3 + rectangle.y, rectangle.width, rectangle.height);
            }
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            Rectangle object2 = rectangle2D.getBounds();
            n3 += object2.height;
            n4 = n6 + 1;
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        graphics2D.setFont(this.font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getAscent();
        int n2 = this.bounds.x;
        int n3 = this.bounds.y + n;
        this.paintAnchorBack(graphics2D);
        this.paintRegexHitted(graphics2D);
        this.paintSelected(graphics2D);
        graphics2D.setColor(this.foregroundColor);
        for (GlyphVector glyphVector : this.lines) {
            graphics2D.drawGlyphVector(glyphVector, n2, n3);
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            Rectangle rectangle = rectangle2D.getBounds();
            n3 += rectangle.height;
        }
    }

    public Anchor getAnchor(Point point) {
        int n = this.getCharIndex(point);
        if (n < 0) {
            return null;
        }
        for (Anchor anchor : this.anchorSet) {
            int n2 = anchor.getStartPos();
            int n3 = anchor.getEndPos();
            if (n2 > n || n > n3 - 1) continue;
            return anchor;
        }
        return null;
    }

    public int getRegexMatchIndex(Point point) {
        int n = this.getCharIndex(point);
        if (n < 0) {
            return -1;
        }
        int n2 = 0;
        for (MatchInfo matchInfo : this.matchList) {
            int n3 = matchInfo.getStartPos();
            int n4 = matchInfo.getEndPos();
            if (n3 <= n && n <= n4 - 1) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int setRegex(Pattern pattern) {
        int n;
        int n2;
        this.clearHotTarget();
        this.matchList.clear();
        if (pattern == null) {
            return 0;
        }
        Matcher matcher = pattern.matcher(this.source);
        while (matcher.find() && (n2 = matcher.start()) < (n = matcher.end())) {
            MatchInfo matchInfo = new MatchInfo(n2, n);
            this.matchList.add(matchInfo);
        }
        return this.getRegexMatches();
    }

    public int getHotTargetIndex() {
        return this.matchList.indexOf(this.hotTarget);
    }

    public void setHotTargetIndex(int n) {
        if (n < 0) {
            this.clearHotTarget();
            return;
        }
        this.hotTarget = this.matchList.get(n);
    }

    public int getRegexMatches() {
        return this.matchList.size();
    }

    public void clearHotTarget() {
        this.hotTarget = null;
    }

    public Rectangle getHotTargetRectangle() {
        Rectangle rectangle = null;
        if (this.hotTarget == null) {
            return rectangle;
        }
        int n = this.bounds.x;
        int n2 = this.bounds.y;
        int n3 = 0;
        int n4 = this.hotTarget.getStartPos();
        int n5 = this.hotTarget.getEndPos() - 1;
        for (GlyphVector glyphVector : this.lines) {
            int n6 = n3;
            int n7 = n3 + glyphVector.getNumGlyphs() - 1;
            if (n5 < n6) break;
            if (n4 <= n7) {
                int n8 = Math.max(n4, n6);
                int n9 = Math.min(n5, n7);
                Shape shape = glyphVector.getGlyphLogicalBounds(n8 - n6);
                Rectangle rectangle2 = shape.getBounds();
                shape = glyphVector.getGlyphLogicalBounds(n9 - n6);
                rectangle2.add(shape.getBounds());
                Rectangle rectangle3 = new Rectangle(n + rectangle2.x, n2, rectangle2.width, rectangle2.height);
                if (rectangle == null) {
                    rectangle = rectangle3;
                } else {
                    rectangle.add(rectangle3);
                }
            }
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            Rectangle rectangle4 = rectangle2D.getBounds();
            n2 += rectangle4.height;
            n3 = n7 + 1;
        }
        return rectangle;
    }

    private static class MatchInfo {
        private final int startPos;
        private final int endPos;

        public MatchInfo(int n, int n2) {
            this.startPos = n;
            this.endPos = n2;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }
    }
}

