/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.Jindolf;

public class HttpUtils {
    private static final String tokenRegex = "([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)";
    private static final String mtypeRegex = "[\\p{Blank}]*([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)/([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)[\\p{Blank}]*";
    private static final String paramRegex = "[\\p{Blank}]*;[\\p{Blank}]*([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)[\\p{Blank}]*=[\\p{Blank}]*(([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)|(\"[^\\p{Cntrl}\\\"]*\"))";
    private static final Pattern mtypePattern = Pattern.compile("[\\p{Blank}]*([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)/([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)[\\p{Blank}]*");
    private static final Pattern attrPattern = Pattern.compile("[\\p{Blank}]*;[\\p{Blank}]*([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)[\\p{Blank}]*=[\\p{Blank}]*(([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)|(\"[^\\p{Cntrl}\\\"]*\"))");
    private static final NumberFormat throughputFormat = NumberFormat.getInstance();
    private static final NumberFormat sizeFormat;

    public static String throughput(long l, long l2) {
        if (l <= 0L || l2 <= 0L) {
            return "";
        }
        double d = (double)l2 / 1.0E9;
        double d2 = (double)l / d;
        String string = "";
        if (d2 >= 1500.0) {
            d2 /= 1000.0;
            string = "K";
        }
        if (d2 >= 1500.0) {
            d2 /= 1000.0;
            string = "M";
        }
        String string2 = sizeFormat.format(l) + "Bytes " + throughputFormat.format(d2) + string + "Bytes/sec";
        return string2;
    }

    public static String formatHttpStat(HttpURLConnection httpURLConnection, long l, long l2) {
        String string;
        String string2;
        String string3 = httpURLConnection.getRequestMethod();
        String string4 = httpURLConnection.getURL().toString();
        try {
            string2 = "" + httpURLConnection.getResponseCode();
        }
        catch (IOException iOException) {
            string2 = "???";
        }
        try {
            string = httpURLConnection.getResponseMessage();
        }
        catch (IOException iOException) {
            string = "???";
        }
        String string5 = HttpUtils.throughput(l, l2);
        String string6 = string3 + " " + string4 + " [" + string2 + " " + string + "]" + " " + string5;
        return string6;
    }

    public static String getUserAgentName() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Jindolf.TITLE).append("/").append("2.17.4");
        StringBuilder stringBuilder2 = new StringBuilder();
        if (AppSetting.getOsName() != null) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("; ");
            }
            stringBuilder2.append(AppSetting.getOsName());
        }
        if (AppSetting.getOsVersion() != null) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("; ");
            }
            stringBuilder2.append(AppSetting.getOsVersion());
        }
        if (AppSetting.getOsArch() != null) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("; ");
            }
            stringBuilder2.append(AppSetting.getOsArch());
        }
        if (AppSetting.getJavaVendor() != null) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("; ");
            }
            stringBuilder2.append(AppSetting.getJavaVendor());
        }
        if (AppSetting.getJavaVersion() != null) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("; ");
            }
            stringBuilder2.append(AppSetting.getJavaVersion());
        }
        if ((string = HttpUtils.escapeHttpComment(stringBuilder2)) != null) {
            stringBuilder.append(" ").append((CharSequence)string);
        }
        return stringBuilder.toString();
    }

    public static String escapeHttpComment(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        if (charSequence.length() <= 0) {
            return null;
        }
        String string = ((Object)charSequence).toString();
        string = string.replaceAll("\\(", "\\\\(");
        string = string.replaceAll("\\)", "\\\\)");
        string = string.replaceAll("[\\u0000-\\u001f]", "?");
        string = string.replaceAll("[\\u007f-\\uffff]", "?");
        string = "(" + string + ")";
        return string;
    }

    public static String getHTMLCharset(URLConnection uRLConnection) {
        String string = uRLConnection.getContentType();
        if (string == null) {
            return null;
        }
        return HttpUtils.getHTMLCharset(string);
    }

    public static String getHTMLCharset(String string) {
        Matcher matcher = mtypePattern.matcher(string);
        boolean bl = matcher.lookingAt();
        if (!bl) {
            return null;
        }
        int n = matcher.end();
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if (!string2.equalsIgnoreCase("text")) {
            return null;
        }
        if (!string3.equalsIgnoreCase("html")) {
            return null;
        }
        matcher.usePattern(attrPattern);
        String string4 = null;
        while (bl = matcher.find(n)) {
            n = matcher.end();
            String string5 = matcher.group(1);
            String string6 = matcher.group(2);
            if (!string5.equalsIgnoreCase("charset")) continue;
            string4 = string6;
        }
        return string4;
    }

    private HttpUtils() {
        assert (false);
        throw new Error();
    }

    static {
        throughputFormat.setMaximumFractionDigits(1);
        throughputFormat.setMinimumFractionDigits(1);
        throughputFormat.setGroupingUsed(true);
        sizeFormat = NumberFormat.getInstance();
        sizeFormat.setGroupingUsed(true);
    }
}

