/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.HtmlSequence;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.NetUtil;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.StringUtils;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Land {
    private static final String Spchar = " \\t\\n\\r";
    private static final String Sp = "[ \\t\\n\\r]";
    private static final String Sp_n = "[ \\t\\n\\r]*";
    private static final String Sp_m = "[ \\t\\n\\r]+";
    private static final Pattern iso8601Regex;
    private static final Pattern anchorRegex;
    public static final Date DATE_UNKNOWN;
    private final String landName;
    private final String landIdentifier;
    private final String landPrefix;
    private final ServerAccess serverAccess;
    private final Date startDate;
    private final Date endDate;
    private final Type type;
    private final Locale locale;
    private final TimeZone timeZone;
    private final String description;
    private final String contactInfo;
    private final List<Village> villageList = new LinkedList<Village>();
    private final SortedSet<Integer> invalidIdSet = new TreeSet<Integer>();

    private static Date parseISO8601(CharSequence charSequence) throws IllegalArgumentException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Matcher matcher = iso8601Regex.matcher(charSequence);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException(((Object)charSequence).toString());
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        String string4 = matcher.group(4);
        String string5 = matcher.group(5);
        String string6 = matcher.group(6);
        String string7 = matcher.group(7);
        try {
            n6 = Integer.parseInt(string);
            n5 = Integer.parseInt(string2);
            n4 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n2 = Integer.parseInt(string5);
            n = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(((Object)charSequence).toString(), numberFormatException);
        }
        String string8 = "GMT";
        string8 = string7.compareToIgnoreCase("Z") == 0 ? string8 + "+00:00" : string8 + string7;
        TimeZone timeZone = TimeZone.getTimeZone(string8);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.set(n6, n5 - 1, n4, n3, n2, n);
        Date date = gregorianCalendar.getTime();
        return date;
    }

    public static String getValueFromCGIQueries(String string, String string2) {
        String string3 = null;
        String[] stringArray = string2.split("\\Q&\\E");
        if (stringArray == null) {
            return null;
        }
        for (String string4 : stringArray) {
            String[] stringArray2;
            if (string4 == null || (stringArray2 = string4.split("\\Q=\\E")) == null || stringArray2.length != 2) continue;
            String string5 = stringArray2[0];
            String string6 = stringArray2[1];
            if (string5 != null && string5.equals(string) && (string3 = string6) != null && string3.length() > 0) break;
        }
        return string3;
    }

    public static String getVillageIDFromHREF(CharSequence charSequence) {
        String string = NetUtil.getQueryFromHREF(charSequence);
        if (string == null) {
            return null;
        }
        String string2 = Land.getValueFromCGIQueries("vid", string);
        if (string2 == null) {
            return null;
        }
        if (string2.length() <= 0) {
            return null;
        }
        return string2;
    }

    public Land(String string, String string2, String string3, URL uRL, Date date, Date date2, Type type, Locale locale, TimeZone timeZone, String string4, String string5) {
        this.landName = string;
        this.landIdentifier = string2;
        this.landPrefix = string3;
        this.serverAccess = new ServerAccess(uRL);
        this.startDate = date;
        this.endDate = date2;
        this.type = type;
        this.locale = locale;
        this.timeZone = timeZone;
        this.description = string4;
        this.contactInfo = string5;
    }

    public Land(String string, Properties properties) throws NullPointerException, IllegalArgumentException {
        URL uRL;
        if (string == null || properties == null) {
            throw new NullPointerException();
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException();
        }
        this.landIdentifier = string;
        String string2 = properties.getProperty(string + ".landname");
        if (string2 == null || string2.length() <= 0) {
            throw new IllegalArgumentException();
        }
        this.landName = string2;
        this.landPrefix = string2 = properties.getProperty(string + ".prefix", "");
        string2 = properties.getProperty(string + ".baseurl");
        if (string2 == null || string2.length() <= 0) {
            throw new IllegalArgumentException();
        }
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(string2, malformedURLException);
        }
        this.serverAccess = new ServerAccess(uRL);
        string2 = properties.getProperty(string + ".startdate");
        Date date = string2 == null || string2.length() <= 0 ? DATE_UNKNOWN : Land.parseISO8601(string2);
        this.startDate = date;
        string2 = properties.getProperty(string + ".enddate");
        date = string2 == null || string2.length() <= 0 ? DATE_UNKNOWN : Land.parseISO8601(string2);
        this.endDate = date;
        this.contactInfo = string2 = properties.getProperty(string + ".contact", "");
        this.description = string2 = properties.getProperty(string + ".description", "");
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string2 = properties.getProperty(string + ".locale");
        if (string2 == null || string2.length() <= 0) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = string2.split("_", 3);
        if (stringArray.length >= 1) {
            string3 = stringArray[0];
        }
        if (stringArray.length >= 2) {
            string4 = stringArray[1];
        }
        if (stringArray.length >= 3) {
            string5 = stringArray[2];
        }
        this.locale = new Locale(string3, string4, string5);
        string2 = properties.getProperty(string + ".timezone");
        if (string2 == null || string2.length() <= 0) {
            throw new IllegalArgumentException();
        }
        this.timeZone = TimeZone.getTimeZone(string2);
        string2 = properties.getProperty(string + ".state");
        if (string2 == null || string2.length() <= 0) {
            throw new IllegalArgumentException();
        }
        if (string2.compareToIgnoreCase("CLOSED") == 0) {
            this.type = Type.CLOSED;
        } else if (string2.compareToIgnoreCase("HISTORICAL") == 0) {
            this.type = Type.HISTORICAL;
        } else if (string2.compareToIgnoreCase("ACTIVE") == 0) {
            this.type = Type.ACTIVE;
        } else {
            throw new IllegalArgumentException(string2);
        }
        string2 = properties.getProperty(string + ".invalidid");
        if (string2 != null) {
            SortedSet<Integer> sortedSet = StringUtils.parseIntList(string2);
            this.invalidIdSet.addAll(sortedSet);
        }
    }

    public String getLandName() {
        return this.landName;
    }

    public String getLandIdentifier() {
        return this.landIdentifier;
    }

    public String getLandPrefix() {
        return this.landPrefix;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Type getType() {
        return this.type;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public ServerAccess getServerAccess() {
        return this.serverAccess;
    }

    public boolean isValidVillageId(int n) {
        return !this.invalidIdSet.contains(n);
    }

    public Village getVillage(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.getVillageCount()) {
            return null;
        }
        Village village = this.villageList.get(n);
        return village;
    }

    public int getVillageCount() {
        int n = this.villageList.size();
        return n;
    }

    public List<Village> getVillageList() {
        return Collections.unmodifiableList(this.villageList);
    }

    public Image downloadImage(String string) {
        Image image;
        ServerAccess serverAccess = this.getServerAccess();
        try {
            image = serverAccess.downloadImage(string);
        }
        catch (IOException iOException) {
            Jindolf.logger.log(Level.WARNING, "\u30a4\u30e1\u30fc\u30b8[" + string + "]" + "\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", iOException);
            return null;
        }
        return image;
    }

    private Collection<Village> parseVillageList(CharSequence charSequence) {
        Vector<Village> vector = new Vector<Village>();
        Matcher matcher = anchorRegex.matcher(charSequence);
        while (matcher.find()) {
            String string;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (string2 == null || string2.length() <= 0) continue;
            if (string3 == null) {
                string3 = "";
            }
            if ((string = Land.getVillageIDFromHREF(string2)) == null || string.length() <= 0) continue;
            String string5 = string3.replaceAll(Sp_m, " ").trim();
            String[] stringArray = string5.split(" ");
            if (stringArray != null && stringArray[0] != null && stringArray[0].equals(string)) {
                string5 = this.landPrefix + string5;
            }
            Village village = new Village(this, string, string5);
            Village.State state = string4 == null || this.getType() == Type.HISTORICAL ? Village.State.GAMEOVER : (string4.equals("\u53c2\u52a0\u8005\u52df\u96c6\u4e2d\u3067\u3059\u3002") ? Village.State.PROLOGUE : (string4.equals("\u958b\u59cb\u5f85\u3061\u3067\u3059\u3002") ? Village.State.PROLOGUE : (string4.equals("\u9032\u884c\u4e2d\u3067\u3059\u3002") ? Village.State.PROGRESS : (string4.equals("\u52dd\u6557\u304c\u6c7a\u5b9a\u3057\u307e\u3057\u305f\u3002") ? Village.State.EPILOGUE : (string4.equals("\u7d42\u4e86\u30fb\u30ed\u30b0\u516c\u958b\u4e2d\u3002") ? Village.State.GAMEOVER : Village.State.UNKNOWN)))));
            village.setState(state);
            vector.add(village);
        }
        return vector;
    }

    public void updateVillageList() throws IOException {
        TreeSet<Village> treeSet = new TreeSet<Village>();
        ServerAccess serverAccess = this.getServerAccess();
        HtmlSequence htmlSequence = serverAccess.getHTMLTopPage();
        Collection<Village> collection = this.parseVillageList(htmlSequence);
        treeSet.addAll(collection);
        htmlSequence = serverAccess.getHTMLLandList();
        collection = this.parseVillageList(htmlSequence);
        treeSet.addAll(collection);
        this.villageList.clear();
        this.villageList.addAll(treeSet);
    }

    public String toString() {
        return this.landName;
    }

    static {
        DATE_UNKNOWN = new Date(-1L);
        String string = "([0-9][0-9][0-9][0-9])";
        String string2 = "([0-1][0-9])";
        String string3 = "([0-3][0-9])";
        String string4 = "([0-2][0-9])";
        String string5 = "([0-5][0-9])";
        String string6 = "([0-6][0-9])";
        String string7 = "([\\+\\-][0-2][0-9](?::?[0-5][0-9])?|Z)";
        String string8 = string + "\\-" + string2 + "\\-" + string3 + "T" + string4 + ":" + string5 + ":" + string6 + string7;
        String string9 = "<a[ \\t\\n\\r]+href=\"([^\"]*)\"[ \\t\\n\\r]*>";
        String string10 = "</a>";
        String string11 = "[ \\t\\n\\r]*<strong>[^<]*</strong>[ \\t\\n\\r]*</td>";
        String string12 = "[ \\t\\n\\r]*<td>([^<]*)</td>";
        String string13 = "(?:" + string11 + string12 + ")?";
        String string14 = string9 + "([^<]*)" + string10 + string13;
        iso8601Regex = Pattern.compile(string8);
        anchorRegex = Pattern.compile(string14, 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CLOSED,
        HISTORICAL,
        ACTIVE;

    }
}

