/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.AbstractTextRow;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.AnchorDraw;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TalkDraw
extends AbstractTextRow {
    public static final Color COLOR_PUBLIC = new Color(0xFFFFFF);
    public static final Color COLOR_WOLFONLY = new Color(0xFF7777);
    public static final Color COLOR_PRIVATE = new Color(0x939393);
    public static final Color COLOR_GRAVE = new Color(10467279);
    private static final int BALOONTIP_WIDTH = 16;
    private static final int BALOONTIP_HEIGHT = 8;
    private static final int UNDER_MARGIN = 15;
    private static final int OFFSET_ANCHOR = 36;
    private static final Color COLOR_TRANS = new Color(0, 0, 0, 0);
    private static final int BALOON_R = 10;
    private static final BufferedImage BALOON_PUBLIC;
    private static final BufferedImage BALOON_WOLFONLY;
    private static final BufferedImage BALOON_GRAVE;
    private static final BufferedImage BALOON_PRIVATE;
    private static float ANCHOR_FONT_RATIO;
    private final Talk talk;
    private Anchor showingAnchor;
    private final GlyphDraw caption;
    private final Image faceImage;
    private final GlyphDraw dialog;
    private final List<AnchorDraw> anchorTalks = new LinkedList<AnchorDraw>();
    private Point imageOrigin;
    private Point dialogOrigin;
    private Point tipOrigin;
    private Font anchorFont;

    private static BufferedImage createWedgeImage(Color color) {
        BufferedImage bufferedImage = new BufferedImage(16, 8, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        RenderingHints renderingHints = GUIUtils.getQualityHints();
        graphics2D.addRenderingHints(renderingHints);
        graphics2D.setColor(COLOR_TRANS);
        graphics2D.fillRect(0, 0, 16, 8);
        graphics2D.setColor(color);
        Polygon polygon = new Polygon();
        polygon.addPoint(8, 8);
        polygon.addPoint(16, 8);
        polygon.addPoint(16, 0);
        graphics2D.fillPolygon(polygon);
        return bufferedImage;
    }

    private static BufferedImage createBubbleImage(Color color) {
        BufferedImage bufferedImage = new BufferedImage(16, 8, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        RenderingHints renderingHints = GUIUtils.getQualityHints();
        graphics2D.addRenderingHints(renderingHints);
        graphics2D.setColor(COLOR_TRANS);
        graphics2D.fillRect(0, 0, 16, 8);
        graphics2D.setColor(color);
        graphics2D.fillOval(2, 4, 4, 4);
        graphics2D.fillOval(8, 2, 6, 6);
        return bufferedImage;
    }

    private static Font getAnchorFont(Font font) {
        float f = font.getSize2D();
        float f2 = f * ANCHOR_FONT_RATIO;
        return font.deriveFont(f2);
    }

    public static Color getTypedColor(Talk.Type type) {
        Color color;
        switch (type) {
            case PUBLIC: {
                color = COLOR_PUBLIC;
                break;
            }
            case WOLFONLY: {
                color = COLOR_WOLFONLY;
                break;
            }
            case GRAVE: {
                color = COLOR_GRAVE;
                break;
            }
            case PRIVATE: {
                color = COLOR_PRIVATE;
                break;
            }
            default: {
                return null;
            }
        }
        return color;
    }

    public TalkDraw(Talk talk) {
        this.talk = talk;
        this.anchorFont = TalkDraw.getAnchorFont(this.font);
        Village village = this.talk.getPeriod().getVillage();
        Avatar avatar = this.talk.getAvatar();
        Image image = talk.getTalkType() == Talk.Type.GRAVE ? village.getGraveImage() : village.getAvatarFaceImage(avatar);
        this.faceImage = image;
        this.caption = new GlyphDraw(this.getCaptionString());
        this.dialog = new GlyphDraw(this.talk.getDialog());
        this.caption.setFontInfo(this.font, this.renderContext);
        this.dialog.setFontInfo(this.font, this.renderContext);
        this.caption.setColor(Color.WHITE);
        this.dialog.setColor(Color.BLACK);
        Period period = this.talk.getPeriod();
        List<Anchor> list = Anchor.getAnchorList(this.talk.getDialog(), period.getDay());
        this.dialog.setAnchorSet(list);
    }

    public Talk getTalk() {
        return this.talk;
    }

    private CharSequence getCaptionString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        Avatar avatar = this.talk.getAvatar();
        stringBuilder.append(avatar.getFullName()).append(' ');
        int n2 = this.talk.getHour();
        if (n2 <= 11) {
            stringBuilder.append("\u5348\u524d ").append(n2);
        } else {
            stringBuilder.append("\u5348\u5f8c ").append(n2 - 12);
        }
        stringBuilder.append("\u6642").append(' ');
        int n3 = this.talk.getMinute();
        stringBuilder.append(n3).append("\u5206").append(' ');
        stringBuilder.append(this.talk.getAnchorNotation()).append('\n');
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        long l = this.talk.getTimeFromID();
        String string = dateFormat.format(l);
        stringBuilder.append(string);
        int n4 = this.talk.getTalkCount();
        if (n4 > 0) {
            Talk.Type type = this.talk.getTalkType();
            stringBuilder.append(" (").append(Talk.encodeColorName(type));
            stringBuilder.append('#').append(n4).append(')');
        }
        if ((n = this.talk.getTotalChars()) > 0) {
            stringBuilder.append(' ').append(n).append('\u5b57');
        }
        return stringBuilder;
    }

    protected Color getTalkColor() {
        Talk.Type type = this.talk.getTalkType();
        Color color = TalkDraw.getTypedColor(type);
        return color;
    }

    @Override
    public Rectangle setWidth(int n) {
        int n2 = this.faceImage.getWidth(null);
        int n3 = this.faceImage.getHeight(null);
        int n4 = BALOON_WOLFONLY.getWidth();
        int n5 = n2 + n4 + 20;
        if (n < n5) {
            n = n5;
        }
        this.caption.setWidth(n);
        int n6 = this.caption.getWidth();
        int n7 = this.caption.getHeight() + 3;
        this.dialog.setWidth(n - n5);
        int n8 = this.dialog.getWidth();
        int n9 = this.dialog.getHeight();
        int n10 = n8 + 20;
        int n11 = n9 + 20;
        int n12 = n2 + n4 + n10;
        int n13 = Math.max(n6, n12);
        int n14 = n7;
        n14 += Math.max(n3, n11);
        int n15 = n7;
        int n16 = n7;
        int n17 = n7;
        if (n3 < n11) {
            n15 += (n11 - n3) / 2;
            n17 += (n11 - BALOON_WOLFONLY.getHeight()) / 2;
            n16 += 10;
        } else {
            n16 += (n3 - n11) / 2 + 10;
            n17 += (n3 - BALOON_WOLFONLY.getHeight()) / 2;
        }
        this.imageOrigin = new Point(0, n15);
        this.caption.setPos(this.bounds.x + 0, this.bounds.y + 0);
        this.dialogOrigin = new Point(n2 + n4 + 10, n16);
        this.dialog.setPos(this.bounds.x + n2 + n4 + 10, this.bounds.y + n16);
        this.tipOrigin = new Point(n2, n17);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setWidth(n - 36);
            n14 += anchorDraw.getHeight();
        }
        this.bounds.width = n13;
        this.bounds.height = n14 + 15;
        return this.bounds;
    }

    @Override
    public void setPos(int n, int n2) {
        super.setPos(n, n2);
        this.caption.setPos(this.bounds.x, this.bounds.y);
        this.dialog.setPos(this.bounds.x + this.dialogOrigin.x, this.bounds.y + this.dialogOrigin.y);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        BufferedImage bufferedImage;
        int n = this.bounds.x;
        int n2 = this.bounds.y;
        this.caption.paint(graphics2D);
        graphics2D.drawImage(this.faceImage, n + this.imageOrigin.x, n2 + this.imageOrigin.y, null);
        switch (this.talk.getTalkType()) {
            case WOLFONLY: {
                bufferedImage = BALOON_WOLFONLY;
                break;
            }
            case PUBLIC: {
                bufferedImage = BALOON_PUBLIC;
                break;
            }
            case GRAVE: {
                bufferedImage = BALOON_GRAVE;
                break;
            }
            case PRIVATE: {
                bufferedImage = BALOON_PRIVATE;
                break;
            }
            default: {
                bufferedImage = null;
                assert (false);
                break;
            }
        }
        graphics2D.drawImage((Image)bufferedImage, n + this.tipOrigin.x, n2 + this.tipOrigin.y, null);
        int n3 = this.dialog.getWidth() + 20;
        int n4 = this.dialog.getHeight() + 20;
        graphics2D.setColor(this.getTalkColor());
        graphics2D.fillRoundRect(n + this.dialogOrigin.x - 10, n2 + this.dialogOrigin.y - 10, n3, n4, 10, 10);
        this.dialog.paint(graphics2D);
        int n5 = n + 36;
        int n6 = n2 + this.dialogOrigin.y + n4;
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setPos(n5, n6);
            anchorDraw.paint(graphics2D);
            n6 += anchorDraw.getHeight();
        }
    }

    @Override
    public void setFontInfo(Font font, FontRenderContext fontRenderContext) {
        super.setFontInfo(font, fontRenderContext);
        this.anchorFont = TalkDraw.getAnchorFont(this.font);
        this.caption.setFontInfo(this.font, this.renderContext);
        this.dialog.setFontInfo(this.font, this.renderContext);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setFontInfo(this.anchorFont, this.renderContext);
        }
        int n = this.getWidth();
        this.setWidth(n);
    }

    @Override
    public void drag(Point point, Point point2) {
        this.caption.drag(point, point2);
        this.dialog.drag(point, point2);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.drag(point, point2);
        }
    }

    @Override
    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.caption.appendSelected(appendable);
        this.dialog.appendSelected(appendable);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.appendSelected(appendable);
        }
        return appendable;
    }

    @Override
    public void clearSelect() {
        this.caption.clearSelect();
        this.dialog.clearSelect();
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.clearSelect();
        }
    }

    public Anchor getAnchor(Point point) {
        Anchor anchor = this.dialog.getAnchor(point);
        return anchor;
    }

    public void showAnchorTalks(Anchor anchor, List<Talk> list) {
        if (anchor == null || this.showingAnchor == anchor) {
            this.showingAnchor = null;
            this.anchorTalks.clear();
            int n = this.getWidth();
            this.setWidth(n);
            return;
        }
        this.showingAnchor = anchor;
        this.anchorTalks.clear();
        for (Talk talk : list) {
            AnchorDraw anchorDraw = new AnchorDraw(talk);
            anchorDraw.setFontInfo(this.anchorFont, this.renderContext);
            this.anchorTalks.add(anchorDraw);
        }
        int n = this.getWidth();
        this.setWidth(n);
    }

    public int getRegexMatchIndex(Point point) {
        int n = this.dialog.getRegexMatchIndex(point);
        return n;
    }

    public int setRegex(Pattern pattern) {
        int n = 0;
        return n += this.dialog.setRegex(pattern);
    }

    public int getHotTargetIndex() {
        return this.dialog.getHotTargetIndex();
    }

    public void setHotTargetIndex(int n) {
        this.dialog.setHotTargetIndex(n);
    }

    public int getRegexMatches() {
        return this.dialog.getRegexMatches();
    }

    public void clearHotTarget() {
        this.dialog.clearHotTarget();
    }

    public Rectangle getHotTargetRectangle() {
        return this.dialog.getHotTargetRectangle();
    }

    static {
        ANCHOR_FONT_RATIO = 0.9f;
        BALOON_PUBLIC = TalkDraw.createWedgeImage(COLOR_PUBLIC);
        BALOON_WOLFONLY = TalkDraw.createBubbleImage(COLOR_WOLFONLY);
        BALOON_PRIVATE = TalkDraw.createBubbleImage(COLOR_PRIVATE);
        BALOON_GRAVE = TalkDraw.createBubbleImage(COLOR_GRAVE);
    }
}

