/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.nio.CharBuffer;
import java.text.AttributedCharacterIterator;
import javax.swing.JTextArea;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import jp.sourceforge.jindolf.CodeX0208;

public class TextEditor
extends JTextArea
implements InputMethodListener {
    private static final int MAX_DOCUMENT = 10000;
    private final DocumentFilter documentFilter = new CustomFilter();
    private boolean onIMEoperation = false;

    public TextEditor() {
        this.setLineWrap(true);
        this.setWrapStyleWord(false);
        PlainDocument plainDocument = new PlainDocument();
        this.setDocument(plainDocument);
        this.addInputMethodListener(this);
    }

    public boolean onIMEoperation() {
        return this.onIMEoperation;
    }

    public void scrollCaretToVisible() {
        Rectangle rectangle;
        int n = this.getCaretPosition();
        try {
            rectangle = this.modelToView(n);
        }
        catch (BadLocationException badLocationException) {
            assert (false);
            return;
        }
        this.scrollRectToVisible(rectangle);
    }

    public void setDocument(Document document) {
        AbstractDocument abstractDocument;
        Document document2 = this.getDocument();
        if (document2 != null && document2 instanceof AbstractDocument) {
            abstractDocument = (AbstractDocument)document2;
            abstractDocument.setDocumentFilter(null);
        }
        super.setDocument(document);
        if (document != null && document instanceof AbstractDocument) {
            abstractDocument = (AbstractDocument)document;
            abstractDocument.setDocumentFilter(this.documentFilter);
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        if (!this.hasFocus()) {
            return;
        }
        super.scrollRectToVisible(rectangle);
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        int n = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        if (attributedCharacterIterator == null) {
            this.onIMEoperation = false;
            return;
        }
        int n2 = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        int n4 = n3 - n2;
        this.onIMEoperation = n < n4;
    }

    private class CustomFilter
    extends DocumentFilter {
        private boolean isValid(char c) {
            if (TextEditor.this.onIMEoperation()) {
                return true;
            }
            if (c == '\n') {
                return true;
            }
            if (c == '\uffff') {
                return false;
            }
            if (Character.isISOControl(c)) {
                return false;
            }
            return CodeX0208.isValid(c);
        }

        private String filter(CharSequence charSequence) {
            if (TextEditor.this.onIMEoperation()) {
                return ((Object)charSequence).toString();
            }
            int n = charSequence.length();
            CharBuffer charBuffer = CharBuffer.allocate(n);
            for (int i = 0; i < n; ++i) {
                char c = charSequence.charAt(i);
                if (c == '\u2211') {
                    c = '\u03a3';
                }
                if (c == '\u00ac') {
                    c = '\uffe2';
                }
                if (!this.isValid(c)) continue;
                charBuffer.append(c);
            }
            charBuffer.flip();
            return charBuffer.toString();
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = this.filter(string);
            if (!TextEditor.this.onIMEoperation()) {
                Document document = filterBypass.getDocument();
                int n2 = document.getLength();
                int n3 = 10000 - n2;
                if (n3 < 0) {
                    return;
                }
                if (n3 < string2.length()) {
                    string2 = string2.substring(0, n3);
                }
            }
            filterBypass.insertString(n, string2, attributeSet);
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = this.filter(string);
            if (!TextEditor.this.onIMEoperation()) {
                Document document = filterBypass.getDocument();
                int n3 = document.getLength();
                int n4 = 10000 - (n3 -= n2);
                if (n4 < 0) {
                    return;
                }
                if (n4 < string2.length()) {
                    string2 = string2.substring(0, n4);
                }
            }
            filterBypass.replace(n, n2, string2, attributeSet);
        }
    }
}

