#!/bin/sh
#
#     Jindolf [ http://sourceforge.jp/projects/jindolf ]
#
# This is Jindolf build script for sh on UNIX.
# This will build jindolf.jar from Java sources.
# You need SunJDK-1.5 compatible or later.
#
# Copyright(c) 2008 olyutorskii
# $Id: build.sh 379 2009-02-07 07:37:50Z olyutorskii $


JAVAC="/usr/bin/javac"
JAR="/usr/bin/jar"


JARFILE=jindolf.jar
MANIFTMPL=manifest.mf

SRCPATH=./src
BLDPATH=./build
DISTPATH=./dist

PKGDIR=jp/sourceforge/jindolf
RESDIR=${PKGDIR}/resources


rm -fR ${BLDPATH}/
mkdir ${BLDPATH}/

rm -fR ${DISTPATH}/
mkdir ${DISTPATH}/


LANGSPEC="-Xlint -deprecation -source 5 -encoding UTF-8"
CODEGEN="-target 5"
PATHASSIGN="-sourcepath ${SRCPATH}/ -d ${BLDPATH}/"
${JAVAC} ${LANGSPEC} ${CODEGEN} ${PATHASSIGN} ${SRCPATH}/${PKGDIR}/*.java


mkdir ${BLDPATH}/${RESDIR}/
cp -R ${SRCPATH}/${RESDIR}/* ${BLDPATH}/${RESDIR}/


${JAR} cmf ${MANIFTMPL} ${DISTPATH}/${JARFILE} -C ${BLDPATH}/ ./


# --- EOF ---
