/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class AccountCookie {
    private static final String datePattern = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final SimpleDateFormat dform;
    private final String loginData;
    private final URI pathURI;
    private final Date expireDate;

    public AccountCookie(String string, String string2, Date date) throws NullPointerException, IllegalArgumentException {
        if (string == null || string2 == null || date == null) {
            throw new NullPointerException();
        }
        this.loginData = string;
        try {
            this.pathURI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(string2, uRISyntaxException);
        }
        this.expireDate = date;
    }

    public boolean hasExpired() {
        long l = System.currentTimeMillis();
        long l2 = this.expireDate.getTime();
        return l2 < l;
    }

    public URI getPathURI() {
        return this.pathURI;
    }

    public String getLoginData() {
        return this.loginData;
    }

    public static AccountCookie createCookie(String string) {
        Date date;
        String[] stringArray = string.split("; ");
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length <= 0) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (String string5 : stringArray) {
            String[] stringArray2 = string5.split("=", 2);
            if (stringArray2 == null || stringArray2.length != 2) continue;
            String string6 = stringArray2[0];
            String string7 = stringArray2[1];
            if (string6.equals("login")) {
                string2 = string7;
                continue;
            }
            if (string6.equals("path")) {
                string3 = string7;
                continue;
            }
            if (!string6.equals("expires")) continue;
            string4 = string7;
        }
        if (string2 == null || string3 == null || string4 == null) {
            return null;
        }
        try {
            date = dform.parse(string4);
        }
        catch (ParseException accountCookie) {
            return null;
        }
        AccountCookie accountCookie = new AccountCookie(string2, string3, date);
        return accountCookie;
    }

    public static AccountCookie createCookie(HttpURLConnection httpURLConnection) {
        String string = httpURLConnection.getHeaderField("Set-Cookie");
        if (string == null) {
            return null;
        }
        AccountCookie accountCookie = AccountCookie.createCookie(string);
        return accountCookie;
    }

    public String toString() {
        return this.loginData;
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        String[] stringArray = dateFormatSymbols.getShortWeekdays();
        stringArray[1] = "Sun";
        stringArray[2] = "Mon";
        stringArray[3] = "Tue";
        stringArray[4] = "Wed";
        stringArray[5] = "Thu";
        stringArray[6] = "Fri";
        stringArray[7] = "Sat";
        dateFormatSymbols.setShortWeekdays(stringArray);
        String[] stringArray2 = dateFormatSymbols.getShortMonths();
        stringArray2[0] = "Jan";
        stringArray2[1] = "Feb";
        stringArray2[2] = "Mar";
        stringArray2[3] = "Apr";
        stringArray2[4] = "May";
        stringArray2[5] = "Jun";
        stringArray2[6] = "Jul";
        stringArray2[7] = "Aug";
        stringArray2[8] = "Sep";
        stringArray2[9] = "Oct";
        stringArray2[10] = "Nov";
        stringArray2[11] = "Dec";
        dateFormatSymbols.setShortMonths(stringArray2);
        dform = new SimpleDateFormat(datePattern);
        dform.setCalendar(gregorianCalendar);
        dform.setTimeZone(timeZone);
        dform.setDateFormatSymbols(dateFormatSymbols);
        dform.setLenient(true);
    }
}

