/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.TextPopup;

public class AccountPanel
extends JDialog
implements ActionListener,
ItemListener {
    private static final String FRAMETITLE = "\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406 - " + Jindolf.TITLE;
    private final LandsModel landsModel;
    private final Map<Land, String> landUserIDMap = new HashMap<Land, String>();
    private final Map<Land, char[]> landPasswordMap = new HashMap<Land, char[]>();
    private final JComboBox landBox = new JComboBox();
    private final JTextField idField = new JTextField(15);
    private final JPasswordField pwField = new JPasswordField(15);
    private final JButton loginButton = new JButton("\u30ed\u30b0\u30a4\u30f3");
    private final JButton logoutButton = new JButton("\u30ed\u30b0\u30a2\u30a6\u30c8");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private final JTextArea status = new JTextArea();

    public AccountPanel(Frame frame, LandsModel landsModel) throws NullPointerException {
        super(frame, FRAMETITLE, true);
        Object object;
        Object object2;
        if (landsModel == null) {
            throw new NullPointerException();
        }
        this.landsModel = landsModel;
        for (Land object32 : this.landsModel.getLandList()) {
            object2 = "";
            object = new char[]{};
            this.landUserIDMap.put(object32, (String)object2);
            this.landPasswordMap.put(object32, (char[])object);
            this.landBox.addItem(object32);
        }
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.landBox.setToolTipText("\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406\u3059\u308b\u56fd\u3092\u9078\u3076");
        this.idField.setToolTipText("ID\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        this.pwField.setToolTipText("\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        GUIUtils.forceMonoPitchFont(this.idField);
        GUIUtils.forceMonoPitchFont(this.pwField);
        this.idField.setMargin(new Insets(1, 4, 1, 4));
        this.pwField.setMargin(new Insets(1, 4, 1, 4));
        this.idField.setComponentPopupMenu(new TextPopup());
        this.landBox.setEditable(false);
        this.landBox.addItemListener(this);
        this.status.setEditable(false);
        this.status.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.status.setRows(2);
        this.status.setLineWrap(true);
        this.loginButton.addActionListener(this);
        this.logoutButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.loginButton);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        object2 = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        ((GridBagConstraints)object2).gridwidth = 0;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).insets = new Insets(5, 5, 5, 5);
        object = this.createCredential();
        JComponent jComponent = this.createButtonPanel();
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).fill = 2;
        container.add((Component)object, object2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u30ed\u30b0\u30a4\u30f3\u30b9\u30c6\u30fc\u30bf\u30b9");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.status, "Center");
        jPanel.setBorder(titledBorder);
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).fill = 1;
        container.add((Component)jPanel, object2);
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).fill = 2;
        container.add((Component)new JSeparator(), object2);
        container.add((Component)jComponent, object2);
        this.preSelectActiveLand();
        this.updateGUI();
    }

    private JComponent createCredential() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel("\u56fd\u540d :"), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.landBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)new JLabel("ID :"), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.idField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)new JLabel("\u30d1\u30b9\u30ef\u30fc\u30c9 :"), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.pwField, gridBagConstraints);
        return jPanel;
    }

    private JComponent createButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.loginButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.logoutButton, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.closeButton, gridBagConstraints);
        return jPanel;
    }

    protected Land getSelectedLand() {
        Land land = (Land)this.landBox.getSelectedItem();
        return land;
    }

    private void preSelectActiveLand() {
        for (int i = 0; i < this.landBox.getItemCount(); ++i) {
            Object e = this.landBox.getItemAt(i);
            Land land = (Land)e;
            Land.Type type = land.getType();
            if (type != Land.Type.ACTIVE) continue;
            this.landBox.setSelectedItem(land);
            return;
        }
    }

    private String getUserID(Land land) {
        return this.landUserIDMap.get(land);
    }

    private char[] getPassword(Land land) {
        return this.landPasswordMap.get(land);
    }

    protected void showNetworkError(IOException iOException) {
        Jindolf.logger.log(Level.WARNING, "\u30a2\u30ab\u30a6\u30f3\u30c8\u51e6\u7406\u4e2d\u306b\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f", iOException);
        Land land = this.getSelectedLand();
        ServerAccess serverAccess = land.getServerAccess();
        String string = land.getLandName() + "\u3092\u904b\u55b6\u3059\u308b\u30b5\u30fc\u30d0\u3068\u306e\u9593\u306e\u901a\u4fe1\u3067" + "\u4f55\u3089\u304b\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n" + "\u76f8\u624b\u30b5\u30fc\u30d0\u306eURL\u306f [ " + serverAccess.getBaseURL() + " ] \u3060\u3088\u3002\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u904a\u3079\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u307f\u3066\u306d\uff01\n";
        JOptionPane jOptionPane = new JOptionPane(string, 2, -1);
        JDialog jDialog = jOptionPane.createDialog(this, "\u901a\u4fe1\u7570\u5e38\u767a\u751f - " + Jindolf.TITLE);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    protected void showIllegalAccountDialog() {
        Land land = this.getSelectedLand();
        String string = land.getLandName() + "\u3078\u306e\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n" + "\u30e6\u30fc\u30b6\u540d\u3068\u30d1\u30b9\u30ef\u30fc\u30c9\u306f\u672c\u5f53\u306b\u6b63\u3057\u3044\u304b\u306a\uff1f\n" + "\u3042\u306a\u305f\u306f\u672c\u5f53\u306b [ " + this.getUserID(land) + " ] \u3055\u3093\u304b\u306a\uff1f\n" + "Web\u30d6\u30e9\u30a6\u30b6\u306b\u3088\u308bID\u767b\u9332\u624b\u7d9a\u304d\u306f\u672c\u5f53\u306b\u5b8c\u4e86\u3057\u3066\u308b\u304b\u306a\uff1f\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u30ed\u30b0\u30a4\u30f3\u3067\u304d\u306a\u3044\u304b\u8a66\u3057\u3066\u307f\u3066\uff01\n" + "\u2026\u30e6\u30fc\u30b6\u540d\u3084\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u3042\u308b\u7a2e\u306e\u7279\u6b8a\u6587\u5b57\u3092\u4f7f\u3063\u3066\u3044\u308b\u4eba\u306f" + "\u554f\u984c\u304c\u3042\u308b\u304b\u3082\u3002";
        JOptionPane jOptionPane = new JOptionPane(string, 2, -1);
        JDialog jDialog = jOptionPane.createDialog(this, "\u30ed\u30b0\u30a4\u30f3\u8a8d\u8a3c\u5931\u6557 - " + Jindolf.TITLE);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    protected boolean login() {
        Land land = this.getSelectedLand();
        ServerAccess serverAccess = land.getServerAccess();
        String string = this.idField.getText();
        char[] cArray = this.pwField.getPassword();
        this.landUserIDMap.put(land, string);
        this.landPasswordMap.put(land, cArray);
        boolean bl = false;
        try {
            bl = serverAccess.login(string, cArray);
        }
        catch (IOException iOException) {
            this.showNetworkError(iOException);
            return false;
        }
        if (!bl) {
            this.showIllegalAccountDialog();
        }
        return bl;
    }

    protected void logout() {
        try {
            this.logoutInternal();
        }
        catch (IOException iOException) {
            this.showNetworkError(iOException);
        }
    }

    protected void logoutInternal() throws IOException {
        Land land = this.getSelectedLand();
        ServerAccess serverAccess = land.getServerAccess();
        serverAccess.logout();
    }

    protected void updateGUI() {
        Land land = this.getSelectedLand();
        Land.Type type = land.getType();
        ServerAccess serverAccess = land.getServerAccess();
        boolean bl = serverAccess.hasLoggedIn();
        if (type != Land.Type.ACTIVE) {
            this.status.setText("\u3053\u306e\u56fd\u306f\u65e2\u306b\u6ec5\u3073\u307e\u3057\u305f\u3002\n\u30ed\u30b0\u30a4\u30f3\u306f\u7121\u610f\u5473\u3067\u3059");
            this.idField.setEnabled(false);
            this.pwField.setEnabled(false);
            this.loginButton.setEnabled(false);
            this.logoutButton.setEnabled(false);
        } else if (bl) {
            this.status.setText("\u30e6\u30fc\u30b6 [ " + this.getUserID(land) + " ] \u3068\u3057\u3066\n" + "\u73fe\u5728\u30ed\u30b0\u30a4\u30f3\u4e2d\u3067\u3059");
            this.idField.setEnabled(false);
            this.pwField.setEnabled(false);
            this.loginButton.setEnabled(false);
            this.logoutButton.setEnabled(true);
        } else {
            this.status.setText("\u73fe\u5728\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093");
            this.idField.setEnabled(true);
            this.pwField.setEnabled(true);
            this.loginButton.setEnabled(true);
            this.logoutButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (object == this.loginButton) {
            this.login();
        } else if (object == this.logoutButton) {
            this.logout();
        }
        this.updateGUI();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object != this.landBox) {
            return;
        }
        Land land = (Land)itemEvent.getItem();
        switch (itemEvent.getStateChange()) {
            case 1: {
                String string = this.getUserID(land);
                char[] cArray = this.getPassword(land);
                this.idField.setText(string);
                this.pwField.setText(new String(cArray));
                this.updateGUI();
                break;
            }
            case 2: {
                String string = this.idField.getText();
                char[] cArray = this.pwField.getPassword();
                this.landUserIDMap.put(land, string);
                this.landPasswordMap.put(land, cArray);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
    }
}

