/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Jindolf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSetting {
    private static final Map<String, String> propertyMap = new TreeMap<String, String>();
    private static final String osName;
    private static final String osVersion;
    private static final String osArch;
    private static final String javaVendor;
    private static final String javaVersion;
    private static final String classpath;
    private static final String[] classpaths;
    private static final Map<String, String> environmentMap;
    private static final String envLANG;
    private static final String envDISPLAY;
    private static final String proxyHost;
    private static final String proxyPort;
    private static final String nonProxyHosts;
    private static boolean needHelp;
    private static boolean needVersion;
    private static boolean needVMInfo;
    private static boolean boldMetal;
    private static boolean noSplash;
    private static boolean consolelog;
    private static int frameWidth;
    private static int frameHeight;
    private static int frameXpos;
    private static int frameYpos;
    private static String initfont;
    private static Boolean antialias;
    private static Boolean fractional;
    private static final List<String> invokeArgs;
    private static final Pattern geomPattern;

    public static String getOsName() {
        return osName;
    }

    public static String getOsArch() {
        return osArch;
    }

    public static String getOsVersion() {
        return osVersion;
    }

    public static String getJavaVendor() {
        return javaVendor;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static String getClasspath() {
        return classpath;
    }

    public static String[] getClasspaths() {
        return classpaths;
    }

    public static String getEnvLANG() {
        return envLANG;
    }

    public static String getEnvDISPLAY() {
        return envDISPLAY;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static String getProxyPort() {
        return proxyPort;
    }

    public static String getNonProxyHosts() {
        return nonProxyHosts;
    }

    public static boolean needHelp() {
        return needHelp;
    }

    public static boolean needVersion() {
        return needVersion;
    }

    public static boolean needVMInfo() {
        return needVMInfo;
    }

    public static boolean useBoldMetal() {
        return boldMetal;
    }

    public static boolean noSplash() {
        return noSplash;
    }

    public static boolean useConsolelog() {
        return consolelog;
    }

    public static int initialFrameWidth() {
        return frameWidth;
    }

    public static int initialFrameHeight() {
        return frameHeight;
    }

    public static int initialFrameXpos() {
        return frameXpos;
    }

    public static int initialFrameYpos() {
        return frameYpos;
    }

    public static String getInitfont() {
        return initfont;
    }

    public static Boolean useAntialias() {
        return antialias;
    }

    public static Boolean useFractional() {
        return fractional;
    }

    private static String getSecureProperty(String string) {
        String string2;
        try {
            string2 = System.getProperty(string);
            if (string2 != null) {
                propertyMap.put(string, string2);
            }
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }

    private static String getSecureEnvironment(String string) {
        String string2;
        try {
            string2 = System.getenv(string);
            if (string2 != null) {
                environmentMap.put(string, string2);
            }
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }

    public static String getVMInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u6700\u5927\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u91cf: " + Jindolf.runtime.maxMemory() + " bytes\n");
        stringBuilder.append("\n");
        stringBuilder.append("\u8d77\u52d5\u6642\u5f15\u6570:\n");
        for (String set2 : invokeArgs) {
            stringBuilder.append("  ").append(set2).append("\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("\u4e3b\u8981\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3:\n");
        Set<String> set3 = propertyMap.keySet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("java.class.path")) continue;
            String string2 = propertyMap.get(string);
            stringBuilder.append("  ");
            stringBuilder.append(string).append("=").append(string2).append("\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("\u4e3b\u8981\u74b0\u5883\u5909\u6570:\n");
        Set<String> set = environmentMap.keySet();
        for (String string2 : set) {
            String string = environmentMap.get(string2);
            stringBuilder.append("  ");
            stringBuilder.append(string2).append("=").append(string).append("\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("\u30af\u30e9\u30b9\u30d1\u30b9:\n");
        for (String string : classpaths) {
            stringBuilder.append("  ");
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    public static void parseOptions(String[] stringArray) {
        invokeArgs.clear();
        for (String object : stringArray) {
            if (object == null || object.length() <= 0) continue;
            invokeArgs.add(object);
        }
        ListIterator<String> listIterator = invokeArgs.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (string.equals("-h") || string.equals("-help") || string.equals("--help") || string.equals("-?")) {
                needHelp = true;
                needVersion = false;
                continue;
            }
            if (string.equals("-version")) {
                needVersion = true;
                needHelp = false;
                continue;
            }
            if (string.equals("-boldMetal")) {
                boldMetal = true;
                continue;
            }
            if (string.equals("-nosplash")) {
                noSplash = true;
                continue;
            }
            if (string.equals("-geometry")) {
                if (!listIterator.hasNext()) {
                    AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + string + "]\u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                    return;
                }
                String string2 = (String)listIterator.next();
                Matcher matcher = geomPattern.matcher(string2);
                if (!matcher.matches()) {
                    AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + string + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + string2 + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                    return;
                }
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                String string5 = matcher.group(3);
                String string6 = matcher.group(4);
                String string7 = matcher.group(5);
                String string8 = matcher.group(6);
                try {
                    frameWidth = Integer.parseInt(string3);
                    frameHeight = Integer.parseInt(string4);
                    if (string6 != null && string6.length() > 0) {
                        frameXpos = Integer.parseInt(string6);
                        if (string5.equals("-")) {
                            frameXpos = -frameXpos;
                        }
                    }
                    if (string8 == null || string8.length() <= 0) continue;
                    frameYpos = Integer.parseInt(string8);
                    if (!string7.equals("-")) continue;
                    frameYpos = -frameYpos;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + string + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + string2 + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                    return;
                }
            }
            if (string.equals("-vminfo")) {
                needVMInfo = true;
                continue;
            }
            if (string.equals("-consolelog")) {
                consolelog = true;
                continue;
            }
            if (string.equals("-initfont")) {
                AppSetting.checkNextArg(string, listIterator);
                initfont = (String)listIterator.next();
                continue;
            }
            if (string.equals("-antialias")) {
                antialias = AppSetting.parseBooleanSwitch(string, listIterator);
                continue;
            }
            if (string.equals("-fractional")) {
                fractional = AppSetting.parseBooleanSwitch(string, listIterator);
                continue;
            }
            AppSetting.optionError("\u672a\u5b9a\u7fa9\u306e\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + string + "]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
            assert (false);
        }
    }

    private static Boolean parseBooleanSwitch(String string, ListIterator<String> listIterator) {
        Boolean bl = null;
        AppSetting.checkNextArg(string, listIterator);
        String string2 = listIterator.next();
        if (string2.compareToIgnoreCase("on") == 0 || string2.compareToIgnoreCase("yes") == 0 || string2.compareToIgnoreCase("true") == 0) {
            bl = Boolean.TRUE;
        } else if (string2.compareToIgnoreCase("off") == 0 || string2.compareToIgnoreCase("no") == 0 || string2.compareToIgnoreCase("false") == 0) {
            bl = Boolean.FALSE;
        } else {
            AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + string + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + string2 + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002" + "on, off, yes, no, true, false" + "\u306e\u3044\u305a\u308c\u304b\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            assert (false);
        }
        return bl;
    }

    private static void checkNextArg(CharSequence charSequence, ListIterator<String> listIterator) {
        if (!listIterator.hasNext()) {
            AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + charSequence + "]\u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            assert (false);
            throw new Error();
        }
    }

    private static void optionError(CharSequence charSequence) {
        System.err.println(charSequence);
        System.err.println("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u4e00\u89a7\u306f\u3001\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u300c-help\u300d\u3092\u6307\u5b9a\u3059\u308b\u3068\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002");
        Jindolf.runtime.exit(1);
        assert (false);
        throw new Error();
    }

    static {
        environmentMap = new TreeMap<String, String>();
        needHelp = false;
        needVersion = false;
        needVMInfo = false;
        boldMetal = false;
        noSplash = false;
        consolelog = false;
        frameWidth = 800;
        frameHeight = 600;
        frameXpos = Integer.MIN_VALUE;
        frameYpos = Integer.MIN_VALUE;
        initfont = null;
        antialias = null;
        fractional = null;
        invokeArgs = new LinkedList<String>();
        geomPattern = Pattern.compile("([1-9][0-9]*)x([1-9][0-9]*)(?:(\\+|\\-)([1-9][0-9]*)(\\+|\\-)([1-9][0-9]*))?");
        osName = AppSetting.getSecureProperty("os.name");
        osVersion = AppSetting.getSecureProperty("os.version");
        osArch = AppSetting.getSecureProperty("os.arch");
        javaVendor = AppSetting.getSecureProperty("java.vendor");
        javaVersion = AppSetting.getSecureProperty("java.version");
        classpath = AppSetting.getSecureProperty("java.class.path");
        proxyHost = AppSetting.getSecureProperty("http.proxyHost");
        proxyPort = AppSetting.getSecureProperty("http.proxyPort");
        nonProxyHosts = AppSetting.getSecureProperty("http.nonProxyHosts");
        envLANG = AppSetting.getSecureEnvironment("LANG");
        envDISPLAY = AppSetting.getSecureEnvironment("DISPLAY");
        classpaths = classpath != null ? classpath.split(File.pathSeparator) : new String[0];
    }
}

