/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import jp.sourceforge.jindolf.Jindolf;

public class CodeX0208 {
    private static final String RESOURCE_INVALIDCHAR = "resources/invalidX0208.txt";
    private static final char[] invalidCharArray = CodeX0208.createInvalidCharArray();

    private static char[] createInvalidCharArray() {
        int n;
        CharSequence charSequence;
        try {
            charSequence = Jindolf.loadResourceText(RESOURCE_INVALIDCHAR);
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
        TreeSet<Character> treeSet = new TreeSet<Character>();
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            n = charSequence.charAt(i);
            if (Character.isWhitespace((char)n)) continue;
            treeSet.add(Character.valueOf((char)n));
        }
        char[] cArray = new char[treeSet.size()];
        n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            cArray[n++] = c;
        }
        Arrays.sort(cArray);
        return cArray;
    }

    public static boolean isValid(char c) {
        int n = Arrays.binarySearch(invalidCharArray, c);
        return n < 0;
    }

    public static boolean isShiftJIS1stByte(byte by) {
        return -127 <= by && by <= -97 || -32 <= by && by <= -4;
    }

    public static boolean isShiftJIS2ndByte(byte by) {
        return 64 <= by && by <= 126 || -128 <= by && by <= -4;
    }

    public static void txSjisToKuten(int[] nArray) {
        int n = nArray[0];
        n = n <= 159 ? (n -= 113) : (n -= 177);
        n <<= 1;
        n |= 1;
        int n2 = nArray[1];
        if (n2 >= 127) {
            --n2;
        }
        if (n2 >= 158) {
            ++n;
            n2 -= 125;
        } else {
            n2 -= 31;
        }
        nArray[0] = n -= 32;
        nArray[1] = n2 -= 32;
    }

    public static boolean isValidSJIS0208_1990(int n, int n2) {
        int n3 = n;
        n3 = n3 <= 159 ? (n3 -= 113) : (n3 -= 177);
        n3 <<= 1;
        n3 |= 1;
        int n4 = n2;
        if (n4 >= 127) {
            --n4;
        }
        if (n4 >= 158) {
            ++n3;
            n4 -= 125;
        } else {
            n4 -= 31;
        }
        int n5 = n3 - 32;
        int n6 = n4 - 32;
        return 1 <= n5 && n5 <= 8 || 16 <= n5 && n5 <= 84;
    }

    private CodeX0208() {
        assert (false);
        throw new Error();
    }
}

