/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import jp.sourceforge.jindolf.TalkEditor;

public class EditArray
extends JPanel
implements Scrollable,
FocusListener {
    private static final int MAX_EDITORS = 50;
    private final List<TalkEditor> editorList = new Vector<TalkEditor>();
    private boolean onAdjusting = false;
    private final NavigationFilter keyNavigator = new CustomNavigation();
    private final DocumentListener documentListener = new DocWatcher();
    private TalkEditor activeEditor;
    private Font textFont;

    public EditArray() {
        this.setOpaque(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        TalkEditor talkEditor = this.incrementTalkEditor();
        this.setActiveEditor(talkEditor);
    }

    private TalkEditor createTalkEditor() {
        TalkEditor talkEditor = new TalkEditor();
        talkEditor.setNavigationFilter(this.keyNavigator);
        talkEditor.addTextFocusListener(this);
        Document document = talkEditor.getDocument();
        document.addDocumentListener(this.documentListener);
        if (this.textFont == null) {
            this.textFont = talkEditor.getTextFont();
        } else {
            talkEditor.setTextFont(this.textFont);
        }
        return talkEditor;
    }

    private TalkEditor incrementTalkEditor() {
        TalkEditor talkEditor = this.createTalkEditor();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        this.add((Component)talkEditor, gridBagConstraints);
        this.editorList.add(talkEditor);
        int n = this.editorList.size();
        talkEditor.setSequenceNumber(n);
        return talkEditor;
    }

    private TalkEditor getTalkEditor(int n) {
        while (this.editorList.size() < n) {
            this.incrementTalkEditor();
        }
        TalkEditor talkEditor = this.editorList.get(n - 1);
        return talkEditor;
    }

    private TalkEditor nextEditor(TalkEditor talkEditor) {
        int n = talkEditor.getSequenceNumber();
        TalkEditor talkEditor2 = this.getTalkEditor(n + 1);
        return talkEditor2;
    }

    private TalkEditor prevEditor(TalkEditor talkEditor) {
        int n = talkEditor.getSequenceNumber();
        if (n <= 1) {
            return null;
        }
        TalkEditor talkEditor2 = this.getTalkEditor(n - 1);
        return talkEditor2;
    }

    private boolean isLastEditor(TalkEditor talkEditor) {
        int n;
        int n2 = talkEditor.getSequenceNumber();
        return n2 >= (n = this.editorList.size());
    }

    private TalkEditor getEditorFromDocument(Document document) {
        for (TalkEditor talkEditor : this.editorList) {
            if (talkEditor.getDocument() != document) continue;
            return talkEditor;
        }
        return null;
    }

    private void removeEditor(TalkEditor talkEditor) {
        if (talkEditor.getParent() != this) {
            return;
        }
        int n = talkEditor.getSequenceNumber();
        if (n <= 1) {
            return;
        }
        TalkEditor talkEditor2 = this.prevEditor(talkEditor);
        if (talkEditor.isActive()) {
            this.setActiveEditor(talkEditor2);
        }
        if (talkEditor.hasEditorFocus()) {
            talkEditor2.requestEditorFocus();
        }
        this.editorList.remove(n - 1);
        talkEditor.setNavigationFilter(null);
        talkEditor.removeTextFocusListener(this);
        Document document = talkEditor.getDocument();
        document.removeDocumentListener(this.documentListener);
        talkEditor.clearText();
        this.remove(talkEditor);
        this.revalidate();
        int n2 = 1;
        for (TalkEditor talkEditor3 : this.editorList) {
            talkEditor3.setSequenceNumber(n2++);
        }
    }

    private void detachAdjustTask(DocumentEvent documentEvent) {
        if (this.onAdjusting) {
            return;
        }
        Document document = documentEvent.getDocument();
        final TalkEditor talkEditor = this.getEditorFromDocument(document);
        if (talkEditor.onIMEoperation()) {
            return;
        }
        this.onAdjusting = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    EditArray.this.adjustTask(talkEditor);
                }
                finally {
                    EditArray.this.onAdjusting = false;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustTask(TalkEditor talkEditor) {
        int n = talkEditor.getCaretPosition();
        TalkEditor talkEditor2 = null;
        int n2 = -1;
        TalkEditor talkEditor3 = talkEditor;
        while (true) {
            TalkEditor talkEditor4;
            block11: {
                String string;
                block12: {
                    if (this.isLastEditor(talkEditor3)) break block12;
                    talkEditor4 = this.nextEditor(talkEditor3);
                    string = talkEditor4.getText();
                    int n3 = string.length();
                    talkEditor3.appendTail(string);
                    String string2 = talkEditor3.chopRest();
                    int n4 = string2 == null ? 0 : string2.length();
                    int n5 = n3 - n4;
                    if (n5 > 0) {
                        talkEditor4.chopHead(n5);
                        break block11;
                    } else if (n5 < 0) {
                        string2 = string2.substring(0, -n5);
                        talkEditor4.appendHead(string2);
                        break block11;
                    } else {
                        if (talkEditor2 != null) break;
                        talkEditor2 = talkEditor3;
                        n2 = n;
                        break;
                    }
                }
                string = talkEditor3.chopRest();
                if (string == null || this.editorList.size() >= 50) {
                    if (talkEditor2 != null) break;
                    talkEditor2 = talkEditor3;
                    if (talkEditor3.getTextLength() >= n) {
                        n2 = n;
                        break;
                    }
                    n2 = talkEditor3.getTextLength();
                    break;
                }
                talkEditor4 = this.nextEditor(talkEditor3);
                talkEditor4.appendHead(string);
            }
            if (talkEditor2 == null) {
                int n6 = talkEditor3.getTextLength();
                if (n >= n6) {
                    n -= n6;
                } else {
                    talkEditor2 = talkEditor3;
                    n2 = n;
                }
            }
            talkEditor3 = talkEditor4;
        }
        if (talkEditor2 != null) {
            talkEditor2.requestEditorFocus();
            talkEditor2.setCaretPosition(n2);
        }
        this.adjustEditorsTail();
    }

    private void adjustEditorsTail() {
        int n;
        int n2 = this.editorList.size();
        if (n2 <= 0) {
            return;
        }
        TalkEditor talkEditor = this.editorList.get(n2 - 1);
        TalkEditor talkEditor2 = null;
        boolean bl = false;
        while (true) {
            n = talkEditor.getTextLength();
            int n3 = talkEditor.getSequenceNumber();
            if (bl) {
                talkEditor2 = talkEditor;
            }
            if (n > 0 || n3 <= 1) break;
            if (talkEditor.hasEditorFocus()) {
                bl = true;
            }
            this.removeEditor(talkEditor);
            talkEditor = this.prevEditor(talkEditor);
        }
        if (talkEditor2 != null) {
            n = talkEditor2.getTextLength();
            talkEditor2.requestEditorFocus();
            talkEditor2.setCaretPosition(n);
        }
    }

    public TalkEditor getFocusedTalkEditor() {
        for (TalkEditor talkEditor : this.editorList) {
            if (!talkEditor.hasEditorFocus()) continue;
            return talkEditor;
        }
        return null;
    }

    public void forwardEditor() {
        TalkEditor talkEditor = this.getFocusedTalkEditor();
        if (this.isLastEditor(talkEditor)) {
            return;
        }
        TalkEditor talkEditor2 = this.nextEditor(talkEditor);
        talkEditor2.setCaretPosition(0);
        talkEditor2.requestEditorFocus();
    }

    public void backwardEditor() {
        TalkEditor talkEditor = this.getFocusedTalkEditor();
        TalkEditor talkEditor2 = this.prevEditor(talkEditor);
        if (talkEditor2 == null) {
            return;
        }
        int n = talkEditor2.getTextLength();
        talkEditor2.setCaretPosition(n);
        talkEditor2.requestEditorFocus();
    }

    private void setActiveEditor(TalkEditor talkEditor) {
        if (this.activeEditor != null) {
            this.activeEditor.setActive(false);
        }
        this.activeEditor = talkEditor;
        if (this.activeEditor != null) {
            this.activeEditor.setActive(true);
        }
        this.fireChangeActive();
    }

    public TalkEditor getActiveEditor() {
        return this.activeEditor;
    }

    public CharSequence getAllText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TalkEditor talkEditor : this.editorList) {
            String string = talkEditor.getText();
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    public void clearAllEditor() {
        int n = this.editorList.size();
        if (n <= 0) {
            return;
        }
        TalkEditor talkEditor = this.editorList.get(n - 1);
        do {
            this.removeEditor(talkEditor);
        } while ((talkEditor = this.prevEditor(talkEditor)) != null);
        TalkEditor talkEditor2 = this.getTalkEditor(1);
        talkEditor2.clearText();
        this.setActiveEditor(talkEditor2);
    }

    public void setTextFont(Font font) {
        this.textFont = font;
        for (TalkEditor talkEditor : this.editorList) {
            talkEditor.setTextFont(this.textFont);
            talkEditor.repaint();
        }
        this.revalidate();
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireChangeActive() {
        ChangeListener[] changeListenerArray;
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListenerArray = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (!(object instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)object;
        Document document = jTextComponent.getDocument();
        TalkEditor talkEditor = this.getEditorFromDocument(document);
        this.setActiveEditor(talkEditor);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        return dimension;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height;
        }
        return 10;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 30;
    }

    private class DocWatcher
    implements DocumentListener {
        private DocWatcher() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            EditArray.this.detachAdjustTask(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            EditArray.this.detachAdjustTask(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            EditArray.this.detachAdjustTask(documentEvent);
        }
    }

    private class CustomNavigation
    extends NavigationFilter {
        public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = super.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
            if (n3 != n) {
                return n3;
            }
            switch (n2) {
                case 1: 
                case 7: {
                    EditArray.this.backwardEditor();
                    break;
                }
                case 3: 
                case 5: {
                    EditArray.this.forwardEditor();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return n3;
        }
    }
}

