/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.TopicFilter;

public class FilterPanel
extends JDialog
implements ActionListener,
TopicFilter {
    private static final String FRAMETITLE = "\u767a\u8a00\u30d5\u30a3\u30eb\u30bf - " + Jindolf.TITLE;
    private final JCheckBox checkPublic = new JCheckBox("\u516c\u958b", true);
    private final JCheckBox checkWolf = new JCheckBox("\u72fc", true);
    private final JCheckBox checkPrivate = new JCheckBox("\u72ec\u308a\u8a00", true);
    private final JCheckBox checkGrave = new JCheckBox("\u5893\u4e0b", true);
    private final JCheckBox checkExtra = new JCheckBox("Extra", true);
    private final JButton selAllButton = new JButton("\u5168\u9078\u629e");
    private final JButton selNoneButton = new JButton("\u5168\u89e3\u9664");
    private final JButton negateButton = new JButton("\u53cd\u8ee2");
    private final JCheckBox checkRealtime = new JCheckBox("\u30ea\u30a2\u30eb\u30bf\u30a4\u30e0\u66f4\u65b0", true);
    private final JButton applyButton = new JButton("\u30d5\u30a3\u30eb\u30bf\u9069\u7528");
    private final Map<Avatar, JCheckBox> cbMap = new HashMap<Avatar, JCheckBox>();
    private final List<JCheckBox> cbList = new LinkedList<JCheckBox>();
    private final EventListenerList listeners = new EventListenerList();

    public FilterPanel(Frame frame) {
        super(frame, FRAMETITLE, false);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        JComponent jComponent = this.createTopicPanel();
        JComponent jComponent2 = this.createAvatarPanel();
        JComponent jComponent3 = this.createButtonPanel();
        JComponent jComponent4 = this.createBottomPanel();
        this.design(jComponent, jComponent2, jComponent3, jComponent4);
        this.checkPublic.addActionListener(this);
        this.checkWolf.addActionListener(this);
        this.checkPrivate.addActionListener(this);
        this.checkGrave.addActionListener(this);
        this.checkExtra.addActionListener(this);
        for (JCheckBox jCheckBox : this.cbList) {
            jCheckBox.addActionListener(this);
        }
        this.selAllButton.addActionListener(this);
        this.selNoneButton.addActionListener(this);
        this.negateButton.addActionListener(this);
        this.checkRealtime.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
    }

    private void design(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4) {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        container.add((Component)new JSeparator(1), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)jComponent3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        container.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)jComponent2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JSeparator(0), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        container.add((Component)jComponent4, gridBagConstraints);
    }

    private JComponent createTopicPanel() {
        this.checkPublic.setToolTipText("\u8ab0\u306b\u3067\u3082\u898b\u3048\u308b\u767a\u8a00");
        this.checkWolf.setToolTipText("\u4eba\u72fc\u540c\u58eb\u306b\u3057\u304b\u898b\u3048\u306a\u3044\u767a\u8a00");
        this.checkPrivate.setToolTipText("\u672c\u4eba\u306b\u3057\u304b\u898b\u3048\u306a\u3044\u767a\u8a00");
        this.checkGrave.setToolTipText("\u6b7b\u8005\u540c\u58eb\u306b\u3057\u304b\u898b\u3048\u306a\u3044\u767a\u8a00");
        this.checkExtra.setToolTipText("\u5360\u3044\u5148\u3084\u8b77\u885b\u5148\u306a\u3069\u306e\u30b7\u30b9\u30c6\u30e0\u30e1\u30c3\u30bb\u30fc\u30b8");
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        jPanel.setBorder(border);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.checkPublic, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.checkWolf, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.checkPrivate, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.checkGrave, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.checkExtra, gridBagConstraints);
        return jPanel;
    }

    private JComponent createAvatarPanel() {
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        jPanel.setBorder(border);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        int n = 0;
        for (Avatar avatar : Avatar.getPredefinedAvatarSet()) {
            JCheckBox jCheckBox = new JCheckBox(avatar.getName(), true);
            jCheckBox.setToolTipText(avatar.getJobTitle());
            this.cbList.add(jCheckBox);
            if (n >= 3) {
                gridBagConstraints.gridwidth = 0;
                n = 0;
            } else {
                gridBagConstraints.gridwidth = 1;
                ++n;
            }
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            this.cbMap.put(avatar, jCheckBox);
        }
        return jPanel;
    }

    private JComponent createButtonPanel() {
        this.selAllButton.setToolTipText("\u5168\u30ad\u30e3\u30e9\u30af\u30bf\u306e\u767a\u8a00\u3092\u8868\u793a\u3059\u308b");
        this.selNoneButton.setToolTipText("\u5168\u30ad\u30e3\u30e9\u30af\u30bf\u306e\u767a\u8a00\u3092\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u3059\u308b");
        this.negateButton.setToolTipText("(\u8868\u793a\u21d4\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0)\u306e\u8a2d\u5b9a\u3092\u53cd\u8ee2\u3055\u305b\u308b");
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 0.3333333333333333;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.selAllButton, gridBagConstraints);
        jPanel.add((Component)this.selNoneButton, gridBagConstraints);
        jPanel.add((Component)this.negateButton, gridBagConstraints);
        return jPanel;
    }

    private JComponent createBottomPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.checkRealtime, gridBagConstraints);
        jPanel.add((Component)this.applyButton, gridBagConstraints);
        return jPanel;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
    }

    protected void fireCheckChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.getChangeListeners()) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void initButtons() {
        this.checkPublic.setSelected(true);
        this.checkWolf.setSelected(true);
        this.checkPrivate.setSelected(true);
        this.checkGrave.setSelected(true);
        this.checkExtra.setSelected(true);
        this.selAllButton.doClick();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl = this.checkRealtime.isSelected();
        if (object == this.selAllButton) {
            boolean bl2 = false;
            for (JCheckBox jCheckBox : this.cbList) {
                if (jCheckBox.isSelected()) continue;
                jCheckBox.setSelected(true);
                bl2 = true;
            }
            if (bl && bl2) {
                this.fireCheckChanged();
            }
        } else if (object == this.selNoneButton) {
            boolean bl3 = false;
            for (JCheckBox jCheckBox : this.cbList) {
                if (!jCheckBox.isSelected()) continue;
                jCheckBox.setSelected(false);
                bl3 = true;
            }
            if (bl && bl3) {
                this.fireCheckChanged();
            }
        } else if (object == this.negateButton) {
            for (JCheckBox jCheckBox : this.cbList) {
                if (jCheckBox.isSelected()) {
                    jCheckBox.setSelected(false);
                    continue;
                }
                jCheckBox.setSelected(true);
            }
            if (bl) {
                this.fireCheckChanged();
            }
        } else if (object == this.checkRealtime) {
            if (bl) {
                this.applyButton.setEnabled(false);
                this.fireCheckChanged();
            } else {
                this.applyButton.setEnabled(true);
            }
        } else if (object == this.applyButton) {
            this.fireCheckChanged();
        } else if (object instanceof JCheckBox && bl) {
            this.fireCheckChanged();
        }
    }

    public boolean isFiltered(Topic topic) {
        JCheckBox jCheckBox;
        if (!(topic instanceof Talk)) {
            if (topic instanceof SysEvent) {
                SysEvent sysEvent = (SysEvent)topic;
                return sysEvent.getEventClass() == SysEvent.EventClass.EXTRA && !this.checkExtra.isSelected();
            }
            return false;
        }
        Talk talk = (Talk)topic;
        Talk.Type type = talk.getTalkType();
        switch (type) {
            case PUBLIC: {
                jCheckBox = this.checkPublic;
                break;
            }
            case WOLFONLY: {
                jCheckBox = this.checkWolf;
                break;
            }
            case PRIVATE: {
                jCheckBox = this.checkPrivate;
                break;
            }
            case GRAVE: {
                jCheckBox = this.checkGrave;
                break;
            }
            default: {
                assert (false);
                return true;
            }
        }
        if (!jCheckBox.isSelected()) {
            return true;
        }
        Avatar avatar = talk.getAvatar();
        jCheckBox = this.cbMap.get(avatar);
        return !jCheckBox.isSelected();
    }

    public TopicFilter.FilterContext getFilterContext() {
        return new FilterPanelContext();
    }

    public boolean isSame(TopicFilter.FilterContext filterContext) {
        if (filterContext == null) {
            return false;
        }
        if (!(filterContext instanceof FilterPanelContext)) {
            return false;
        }
        FilterPanelContext filterPanelContext = (FilterPanelContext)filterContext;
        FilterPanelContext filterPanelContext2 = (FilterPanelContext)this.getFilterContext();
        return filterPanelContext2.context.equals(filterPanelContext.context);
    }

    private class FilterPanelContext
    implements TopicFilter.FilterContext {
        private final BitSet context = new BitSet();

        public FilterPanelContext() {
            int n = 0;
            this.context.set(n++, FilterPanel.this.checkPublic.isSelected());
            this.context.set(n++, FilterPanel.this.checkWolf.isSelected());
            this.context.set(n++, FilterPanel.this.checkPrivate.isSelected());
            this.context.set(n++, FilterPanel.this.checkGrave.isSelected());
            this.context.set(n++, FilterPanel.this.checkExtra.isSelected());
            for (Avatar avatar : Avatar.getPredefinedAvatarSet()) {
                JCheckBox jCheckBox = (JCheckBox)FilterPanel.this.cbMap.get(avatar);
                this.context.set(n++, jCheckBox.isSelected());
            }
        }
    }
}

