/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GameRole {
    HABITANT("\u6751\u4eba", '\u6751'),
    WOLF("\u4eba\u72fc", '\u72fc'),
    SEER("\u5360\u3044\u5e2b", '\u5360'),
    SHAMAN("\u970a\u80fd\u8005", '\u970a'),
    MADMAN("\u72c2\u4eba", '\u72c2'),
    HUNTER("\u72e9\u4eba", '\u72e9'),
    FRATER("\u5171\u6709\u8005", '\u5171'),
    HAMSTER("\u30cf\u30e0\u30b9\u30bf\u30fc\u4eba\u9593", '\u516c');

    private static final Comparator<GameRole> powerBalanceComparator;
    private static final Pattern roleRegex;
    private final String roleName;
    private final char shortName;

    public static GameRole lookingAtRole(Matcher matcher) {
        matcher.usePattern(roleRegex);
        if (!matcher.lookingAt()) {
            return null;
        }
        int n = matcher.groupCount();
        for (int i = 1; i <= n; ++i) {
            if (matcher.start(i) < 0) continue;
            GameRole gameRole = GameRole.values()[i - 1];
            return gameRole;
        }
        return null;
    }

    public static Comparator<GameRole> getPowerBalanceComparator() {
        return powerBalanceComparator;
    }

    private GameRole(String string2, char c) {
        this.roleName = string2;
        this.shortName = c;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public char getShortName() {
        return this.shortName;
    }

    static {
        powerBalanceComparator = new PowerBalanceComparator();
        String string = "";
        for (GameRole gameRole : GameRole.values()) {
            if (string.length() > 0) {
                string = string + "|";
            }
            string = string + "(" + Pattern.quote(gameRole.getRoleName()) + ")";
        }
        roleRegex = Pattern.compile(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PowerBalanceComparator
    implements Comparator<GameRole> {
        private PowerBalanceComparator() {
        }

        @Override
        public int compare(GameRole gameRole, GameRole gameRole2) {
            if (gameRole == gameRole2) {
                return 0;
            }
            if (gameRole == null && gameRole2 == null) {
                return 0;
            }
            if (gameRole != null && gameRole2 == null) {
                return 1;
            }
            if (gameRole == null && gameRole2 != null) {
                return -1;
            }
            int n = PowerBalanceComparator.getPowerValue(gameRole);
            int n2 = PowerBalanceComparator.getPowerValue(gameRole2);
            return n - n2;
        }

        private static int getPowerValue(GameRole gameRole) {
            int n;
            switch (gameRole) {
                case HABITANT: {
                    n = -50;
                    break;
                }
                case FRATER: {
                    n = -40;
                    break;
                }
                case SEER: {
                    n = -30;
                    break;
                }
                case SHAMAN: {
                    n = -20;
                    break;
                }
                case HUNTER: {
                    n = -10;
                    break;
                }
                case HAMSTER: {
                    n = 0;
                    break;
                }
                case MADMAN: {
                    n = 10;
                    break;
                }
                case WOLF: {
                    n = 20;
                    break;
                }
                default: {
                    assert (false);
                    n = Integer.MAX_VALUE;
                }
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Team {
        VILLAGE("\u6751\u9663\u55b6"),
        WOLF("\u72fc\u9663\u55b6"),
        HAMSTER("\u30cf\u30e0\u30b9\u30bf\u30fc\u4eba\u9593");

        private final String teamName;

        private Team(String string2) {
            this.teamName = string2;
        }

        public String getTeamName() {
            return this.teamName;
        }
    }
}

