/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Destiny;
import jp.sourceforge.jindolf.FaceIconSet;
import jp.sourceforge.jindolf.GameRole;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Player;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.WolfBBS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSummary {
    private static Comparator<Player> castingComparator = new CastingComparator();
    private final Map<Avatar, Player> playerMap = new HashMap<Avatar, Player>();
    private final List<Player> playerList = new LinkedList<Player>();
    private final Village village;
    private GameRole.Team winner;
    private int ctScryVillage = 0;
    private int ctScryMadman = 0;
    private int ctScryWolf = 0;
    private int ctGuardVillage = 0;
    private int ctGuardMadman = 0;
    private int ctGuardWolf = 0;
    private int ctGuardVillageGJ = 0;
    private int ctGuardMadmanGJ = 0;
    private int ctGuardFakeGJ = 0;
    private long talk1stTime = -1L;
    private long talkLastTime = -1L;

    public static CharSequence getRoleBalanceSequence(List<Player> list) {
        LinkedList<GameRole> linkedList = new LinkedList<GameRole>();
        for (Player object : list) {
            GameRole gameRole = object.getRole();
            linkedList.add(gameRole);
        }
        Collections.sort(linkedList, GameRole.getPowerBalanceComparator());
        StringBuilder stringBuilder = new StringBuilder();
        for (GameRole gameRole : linkedList) {
            char c = gameRole.getShortName();
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public GameSummary(Village village) {
        if (village == null) {
            throw new NullPointerException();
        }
        Village.State state = village.getState();
        if (state != Village.State.EPILOGUE && state != Village.State.GAMEOVER) {
            throw new IllegalStateException();
        }
        this.village = village;
        for (Period period : village.getPeriodList()) {
            this.summarizePeriod(period);
        }
        this.summarizeScry();
        this.summarizeHunter();
    }

    private void summarizePeriod(Period period) {
        for (Topic topic : period.getTopicList()) {
            Topic topic2;
            if (topic instanceof SysEvent) {
                topic2 = (SysEvent)topic;
                this.summarizeSysEvent(period, (SysEvent)topic2);
                continue;
            }
            if (!(topic instanceof Talk)) continue;
            topic2 = (Talk)topic;
            this.summarizeTalk(period, (Talk)topic2);
        }
    }

    private void summarizeSysEvent(Period period, SysEvent sysEvent) {
        List<Avatar> list = sysEvent.getAvatarList();
        List<GameRole> list2 = sysEvent.getRoleList();
        List<Integer> list3 = sysEvent.getIntegerList();
        List<CharSequence> list4 = sysEvent.getCharSequenceList();
        SysEvent.Type type = sysEvent.getType();
        switch (type) {
            case WINVILLAGE: {
                this.winner = GameRole.Team.VILLAGE;
                break;
            }
            case WINWOLF: {
                this.winner = GameRole.Team.WOLF;
                break;
            }
            case WINHAMSTER: {
                this.winner = GameRole.Team.HAMSTER;
                break;
            }
            case PLLIST: {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Avatar avatar = list.get(i);
                    GameRole gameRole = list2.get(i);
                    CharSequence charSequence = list4.get(i * 2);
                    CharSequence charSequence2 = list4.get(i * 2 + 1);
                    int n2 = list3.get(i);
                    Player player = this.registPlayer(avatar);
                    player.setRole(gameRole);
                    player.setUrlText(((Object)charSequence).toString());
                    player.setIdName(((Object)charSequence2).toString());
                    if (n2 != 0) {
                        player.setObitDay(-1);
                        player.setDestiny(Destiny.ALIVE);
                    }
                    this.playerList.add(player);
                }
                break;
            }
            case SUDDENDEATH: {
                Avatar avatar = list.get(0);
                Player player = this.registPlayer(avatar);
                player.setDestiny(Destiny.SUDDENDEATH);
                player.setObitDay(period.getDay());
                break;
            }
            case COUNTING: {
                int n = list.size();
                if (n % 2 == 0) break;
                Avatar avatar = list.get(n - 1);
                Player player = this.registPlayer(avatar);
                player.setDestiny(Destiny.EXECUTED);
                player.setObitDay(period.getDay());
                break;
            }
            case MURDER: {
                for (Avatar avatar : list) {
                    Player player = this.registPlayer(avatar);
                    player.setDestiny(Destiny.EATEN);
                    player.setObitDay(period.getDay());
                }
                break;
            }
            case ONSTAGE: {
                Avatar avatar = list.get(0);
                Player player = this.registPlayer(avatar);
                player.setEntryNo(list3.get(0));
                break;
            }
        }
    }

    private void summarizeTalk(Period period, Talk talk) {
        long l = talk.getTimeFromID();
        if (this.talk1stTime < 0L) {
            this.talk1stTime = l;
        }
        if (this.talkLastTime < 0L) {
            this.talkLastTime = l;
        }
        if (l < this.talk1stTime) {
            this.talk1stTime = l;
        }
        if (l > this.talkLastTime) {
            this.talkLastTime = l;
        }
    }

    private void summarizeScry() {
        for (Period period : this.village.getPeriodList()) {
            block5: for (Topic topic : period.getTopicList()) {
                SysEvent sysEvent;
                if (!(topic instanceof SysEvent) || (sysEvent = (SysEvent)topic).getType() != SysEvent.Type.SCRY) continue;
                List<Avatar> list = sysEvent.getAvatarList();
                Avatar avatar = list.get(1);
                Player player = this.getPlayer(avatar);
                GameRole gameRole = player.getRole();
                switch (gameRole) {
                    case WOLF: {
                        ++this.ctScryWolf;
                        continue block5;
                    }
                    case MADMAN: {
                        ++this.ctScryMadman;
                        continue block5;
                    }
                }
                ++this.ctScryVillage;
            }
        }
    }

    public CharSequence dumpSeerActivity() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ctScryVillage > 0) {
            stringBuilder.append("\u6751\u9663\u55b6\u3092");
            stringBuilder.append(this.ctScryVillage);
            stringBuilder.append("\u56de");
        }
        if (this.ctScryMadman > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\u3001');
            }
            stringBuilder.append("\u72c2\u4eba\u3092");
            stringBuilder.append(this.ctScryMadman);
            stringBuilder.append("\u56de");
        }
        if (this.ctScryWolf > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\u3001');
            }
            stringBuilder.append("\u4eba\u72fc\u3092");
            stringBuilder.append(this.ctScryWolf);
            stringBuilder.append("\u56de");
        }
        if (stringBuilder.length() <= 0) {
            stringBuilder.append("\u8ab0\u3082\u5360\u308f\u306a\u304b\u3063\u305f\u3002");
        } else {
            stringBuilder.append("\u5360\u3063\u305f\u3002");
        }
        return stringBuilder;
    }

    private void summarizeHunter() {
        for (Period period : this.village.getPeriodList()) {
            if (period.getDay() <= 2) continue;
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            Enum enum_ = null;
            block8: for (Topic topic : period.getTopicList()) {
                List<Avatar> list;
                Topic topic2;
                if (topic instanceof Talk) {
                    topic2 = (Talk)topic;
                    if (((Talk)topic2).getTalkCount() > 0) continue;
                    bl2 = true;
                    continue;
                }
                if (!(topic instanceof SysEvent)) continue;
                topic2 = (SysEvent)topic;
                SysEvent.Type type = ((SysEvent)topic2).getType();
                if (type == SysEvent.Type.COUNTING) {
                    list = ((SysEvent)topic2).getAvatarList();
                    int n2 = list.size();
                    for (int i = 0; i <= n2 - 1; i += 2) {
                        Avatar avatar = list.get(i);
                        Player player = this.getPlayer(avatar);
                        if (player.getRole() == GameRole.HUNTER) {
                            if (i >= n2 - 1) {
                                bl = false;
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        if (player.getRole() != GameRole.WOLF) continue;
                        if (i >= n2 - 1) {
                            --n;
                            continue;
                        }
                        ++n;
                    }
                    continue;
                }
                if (type == SysEvent.Type.GUARD) {
                    list = ((SysEvent)topic2).getAvatarList();
                    Avatar avatar = list.get(1);
                    Player player = this.getPlayer(avatar);
                    enum_ = player.getRole();
                    switch (1.$SwitchMap$jp$sourceforge$jindolf$GameRole[enum_.ordinal()]) {
                        case 1: {
                            ++this.ctGuardWolf;
                            break;
                        }
                        case 2: {
                            ++this.ctGuardMadman;
                            break;
                        }
                        default: {
                            ++this.ctGuardVillage;
                            break;
                        }
                    }
                    continue;
                }
                if (type != SysEvent.Type.NOMURDER || !bl) continue;
                if (bl2) {
                    if (enum_ == null) continue;
                    switch (1.$SwitchMap$jp$sourceforge$jindolf$GameRole[enum_.ordinal()]) {
                        case 2: {
                            ++this.ctGuardMadmanGJ;
                            continue block8;
                        }
                    }
                    ++this.ctGuardVillageGJ;
                    continue;
                }
                if (n <= 0) continue;
                ++this.ctGuardFakeGJ;
            }
        }
    }

    public CharSequence dumpHunterActivity() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.ctGuardFakeGJ > 0 ? "\u5c11\u306a\u304f\u3068\u3082" : "";
        if (this.ctGuardVillage > 0) {
            stringBuilder.append(string);
            stringBuilder.append("\u6751\u9663\u55b6\u3092");
            stringBuilder.append(this.ctGuardVillage);
            stringBuilder.append("\u56de\u8b77\u885b\u3057");
            if (this.ctGuardVillageGJ > 0) {
                stringBuilder.append("GJ\u3092");
                stringBuilder.append(this.ctGuardVillageGJ);
                stringBuilder.append("\u56de\u51fa\u3057\u305f\u3002");
            } else {
                stringBuilder.append("\u305f\u3002");
            }
        }
        if (this.ctGuardMadman > 0) {
            stringBuilder.append(string);
            stringBuilder.append("\u72c2\u4eba\u3092");
            stringBuilder.append(this.ctGuardMadman);
            stringBuilder.append("\u56de\u8b77\u885b\u3057");
            if (this.ctGuardMadmanGJ > 0) {
                stringBuilder.append("GJ\u3092");
                stringBuilder.append(this.ctGuardMadmanGJ);
                stringBuilder.append("\u56de\u51fa\u3057\u305f\u3002");
            } else {
                stringBuilder.append("\u305f\u3002");
            }
        }
        if (this.ctGuardWolf > 0) {
            stringBuilder.append(string);
            stringBuilder.append("\u4eba\u72fc\u3092");
            stringBuilder.append(this.ctGuardWolf);
            stringBuilder.append("\u56de\u8b77\u885b\u3057\u305f\u3002");
        }
        if (this.ctGuardFakeGJ > 0) {
            stringBuilder.append("\u8b77\u885b\u5148\u306f\u4e0d\u660e\u306a\u304c\u3089\u507d\u88c5GJ\u304c");
            stringBuilder.append(this.ctGuardFakeGJ);
            stringBuilder.append("\u56de\u3042\u3063\u305f\u3002");
        }
        if (stringBuilder.length() <= 0) {
            stringBuilder.append("\u8ab0\u3082\u8b77\u885b\u3057\u306a\u304b\u3063\u305f");
        }
        return stringBuilder;
    }

    public CharSequence dumpExecutionInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block4: for (Player player : this.playerList) {
            Destiny destiny = player.getDestiny();
            if (destiny != Destiny.EXECUTED) continue;
            GameRole gameRole = player.getRole();
            switch (gameRole) {
                case WOLF: {
                    ++n;
                    continue block4;
                }
                case MADMAN: {
                    ++n2;
                    continue block4;
                }
            }
            ++n3;
        }
        if (n3 > 0) {
            stringBuilder.append("\u25bc\u6751\u9663\u55b6\u00d7").append(n3).append("\u56de");
        }
        if (n2 > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\u3001");
            }
            stringBuilder.append("\u25bc\u72c2\u00d7").append(n2).append("\u56de");
        }
        if (n > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\u3001");
            }
            stringBuilder.append("\u25bc\u72fc\u00d7").append(n).append("\u56de");
        }
        if (stringBuilder.length() <= 0) {
            stringBuilder.append("\u306a\u3057");
        }
        return stringBuilder;
    }

    public CharSequence dumpAssaultInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        block3: for (Player player : this.playerList) {
            if (player.getAvatar() == Avatar.AVATAR_GERD) {
                stringBuilder.append("\u25b2\u30b2\u30eb\u30c8");
                continue;
            }
            Destiny destiny = player.getDestiny();
            if (destiny != Destiny.EATEN) continue;
            GameRole gameRole = player.getRole();
            switch (gameRole) {
                case MADMAN: {
                    ++n;
                    continue block3;
                }
            }
            ++n2;
        }
        if (n2 > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\u3001");
            }
            stringBuilder.append("\u25b2\u6751\u9663\u55b6\u00d7").append(n2).append("\u56de");
        }
        if (n > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\u3001");
            }
            stringBuilder.append("\u25b2\u72c2\u00d7").append(n).append("\u56de");
        }
        if (stringBuilder.length() <= 0) {
            stringBuilder.append("\u8972\u6483\u306a\u3057");
        }
        return stringBuilder;
    }

    public CharSequence dumpVoteBox() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Player player : this.getCastingPlayerList()) {
            Avatar avatar = player.getAvatar();
            if (avatar == Avatar.AVATAR_GERD) continue;
            GameRole gameRole = player.getRole();
            String string = avatar.getFullName();
            String string2 = gameRole.getRoleName();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("[").append((CharSequence)string2).append("] ").append((CharSequence)string);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(WolfBBS.escapeWikiSyntax(stringBuilder2));
            stringBuilder.append("[0]");
        }
        stringBuilder.insert(0, "#vote(").append(")\n");
        return stringBuilder;
    }

    public CharSequence dumpCastingBoard(FaceIconSet faceIconSet) {
        StringBuilder stringBuilder = new StringBuilder();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        String string = dateFormat.format(new Date());
        String string2 = this.village.getVillageFullName();
        String string3 = Jindolf.TITLE + " Ver." + "2.18.2";
        String string4 = faceIconSet.getAuthor() + "\u6c0f" + " [ " + faceIconSet.getUrlText() + " ]";
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("// \u2193\u30ad\u30e3\u30b9\u30c8\u8868\u958b\u59cb\n");
        stringBuilder.append("//        Village : " + string2 + "\n");
        stringBuilder.append("//        Generator : " + string3 + "\n");
        stringBuilder.append("//        Date : " + string + '\n');
        stringBuilder.append("//        \u30a2\u30a4\u30b3\u30f3\u4f5c\u8005 : " + string4 + '\n');
        stringBuilder.append("// \u203b\u30a2\u30a4\u30b3\u30f3\u753b\u50cf\u306e\u8457\u4f5c\u8ca1\u7523\u6a29\u4fdd\u6301\u8005\u304a\u3088\u3073\u753b\u50cf\u30b5\u30fc\u30d0\u904b\u55b6\u8005\u304b\u3089\n");
        stringBuilder.append("// \u65b0\u3057\u3044\u610f\u5411\u304c\u793a\u3055\u308c\u305f\u5834\u5408\u3001\u305d\u3061\u3089\u3092\u6700\u512a\u5148\u3067\u5c0a\u91cd\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("|\u914d\u5f79").append("|\u53c2\u52a0\u8005").append("|\u5f79\u8077").append("|\u904b\u547d").append("|\u305d\u306e\u6d3b\u8e8d").append("|h").append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        for (Player player : this.getCastingPlayerList()) {
            CharSequence charSequence;
            Object object;
            Object object2;
            Avatar avatar = player.getAvatar();
            GameRole gameRole = player.getRole();
            Destiny destiny = player.getDestiny();
            int n = player.getObitDay();
            String string5 = player.getIdName();
            String string6 = player.getUrlText();
            if (string6 == null) {
                string6 = "";
            }
            string6 = string6.replace("~", "%7e");
            string6 = string6.replace(" ", "%20");
            try {
                object2 = new URL(string6);
                object = ((URL)object2).toURI();
                string6 = ((URI)object).toASCIIString();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            stringBuilder.append("// ========== ");
            stringBuilder.append(string5 + " acts as [" + avatar.getName() + "]");
            stringBuilder.append(" ==========\n");
            object2 = "BGCOLOR(" + WolfBBS.getTeamWikiColor(gameRole) + "):";
            object = faceIconSet.getAvatarIconWiki(avatar);
            stringBuilder.append('|').append((String)object2);
            stringBuilder.append((String)object).append("&br;");
            stringBuilder.append("[[").append(avatar.getName()).append("]]");
            stringBuilder.append('|').append((String)object2);
            stringBuilder.append("[[").append(WolfBBS.escapeWikiSyntax(string5));
            if (string6 != null && string6.length() > 0) {
                stringBuilder.append('>').append(string6);
            }
            stringBuilder.append("]]");
            stringBuilder.append('|').append((String)object2);
            stringBuilder.append(WolfBBS.getRoleIconWiki(gameRole));
            stringBuilder.append("&br;");
            stringBuilder.append("[[");
            stringBuilder.append(gameRole.getRoleName());
            stringBuilder.append("]]");
            String string7 = WolfBBS.getDestinyColorWiki(destiny);
            stringBuilder.append('|');
            stringBuilder.append("BGCOLOR(").append(string7).append("):");
            if (destiny == Destiny.ALIVE) {
                stringBuilder.append("\u6700\u5f8c\u307e\u3067&br;\u751f\u5b58");
            } else {
                stringBuilder.append(n).append("\u65e5\u76ee").append("&br;");
                stringBuilder.append(destiny.getMessage());
            }
            stringBuilder.append('|');
            stringBuilder.append(avatar.getJobTitle()).append('\u3002');
            if (avatar == Avatar.AVATAR_GERD) {
                stringBuilder.append("\u5bdd\u3066\u3070\u304b\u308a\u3044\u305f\u3002");
            } else if (gameRole == GameRole.HUNTER) {
                charSequence = this.dumpHunterActivity();
                stringBuilder.append(charSequence);
            } else if (gameRole == GameRole.SEER) {
                charSequence = this.dumpSeerActivity();
                stringBuilder.append(charSequence);
            }
            stringBuilder.append("|\n");
        }
        stringBuilder.append("|>|>|>|>|");
        stringBuilder.append("RIGHT:");
        stringBuilder.append("\u9854\u30a2\u30a4\u30b3\u30f3\u63d0\u4f9b : [[");
        stringBuilder.append(WolfBBS.escapeWikiSyntax(faceIconSet.getAuthor()));
        stringBuilder.append(">" + faceIconSet.getUrlText());
        stringBuilder.append("]]\u6c0f");
        stringBuilder.append("|\n");
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("// \u2191\u30ad\u30e3\u30b9\u30c8\u8868\u3053\u3053\u307e\u3067\n");
        stringBuilder.append(WolfBBS.COMMENTLINE);
        return stringBuilder;
    }

    public CharSequence dumpVillageWiki() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        String string = dateFormat.format(new Date());
        String string2 = this.village.getVillageFullName();
        String string3 = Jindolf.TITLE + " Ver." + "2.18.2";
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("// \u2193\u6751\u8a73\u7d30\u958b\u59cb\n");
        stringBuilder.append("//        Village : " + string2 + "\n");
        stringBuilder.append("//        Generator : " + string3 + "\n");
        stringBuilder.append("//        Date : " + string + '\n');
        stringBuilder.append("* \u6751\u306e\u8a73\u7d30\n");
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u52dd\u8005\n");
        GameRole.Team team = this.getWinnerTeam();
        String string4 = team.getTeamName();
        stringBuilder.append(string4).append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u30a8\u30f3\u30c8\u30ea\u30fc\u958b\u59cb\u6642\u523b\n");
        Date date = this.get1stTalkDate();
        String string5 = dateFormat.format(date);
        stringBuilder.append(string5).append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u53c2\u52a0\u4eba\u6570\n");
        int n = this.countAvatarNum();
        String string6 = "\u30b2\u30eb\u30c8 + " + (n - 1) + "\u540d = " + n + "\u540d";
        stringBuilder.append(string6).append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u5f79\u8077\u5185\u8a33\n");
        String string7 = "";
        for (Object object2 : GameRole.values()) {
            object = this.getRoledPlayerList((GameRole)((Object)object2));
            String string8 = object2.getRoleName();
            if (object.size() <= 0) continue;
            if (string7.length() > 0) {
                string7 = string7 + "\u3001";
            }
            string7 = string7 + string8 + " \u00d7 " + object.size() + "\u540d";
        }
        stringBuilder.append(string7).append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u51e6\u5211\u5185\u8a33\n");
        stringBuilder.append(this.dumpExecutionInfo()).append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u8972\u6483\u5185\u8a33\n");
        stringBuilder.append(this.dumpAssaultInfo()).append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u7a81\u7136\u6b7b\n");
        stringBuilder.append(this.countSuddenDeath()).append("\u540d").append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u4eba\u53e3\u63a8\u79fb\n");
        for (int i = 1; i < this.village.getPeriodSize(); ++i) {
            Object object2;
            List<Player> list = this.getSurvivorList(i);
            CharSequence charSequence = GameSummary.getRoleBalanceSequence(list);
            object = this.village.getPeriod(i);
            object2 = ((Period)object).getCaption();
            stringBuilder.append('|').append((String)object2).append('|').append(charSequence).append("|\n");
        }
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u5360\u3044\u5e2b\u306e\u6210\u7e3e\n");
        stringBuilder.append(this.dumpSeerActivity()).append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("- \u72e9\u4eba\u306e\u6210\u7e3e\n");
        stringBuilder.append(this.dumpHunterActivity()).append('\n');
        stringBuilder.append(WolfBBS.COMMENTLINE);
        stringBuilder.append("// \u2191\u6751\u8a73\u7d30\u3053\u3053\u307e\u3067\n");
        stringBuilder.append(WolfBBS.COMMENTLINE);
        return stringBuilder;
    }

    public Date get1stTalkDate() {
        return new Date(this.talk1stTime);
    }

    public Date getLastTalkDate() {
        return new Date(this.talkLastTime);
    }

    public List<Player> getSurvivorList(int n) {
        if (n < 0 || this.village.getPeriodSize() <= n) {
            throw new IndexOutOfBoundsException();
        }
        LinkedList<Player> linkedList = new LinkedList<Player>();
        Period period = this.village.getPeriod(n);
        if (period.isPrologue() || period.isProgress() && n == 1) {
            linkedList.addAll(this.playerList);
            return linkedList;
        }
        if (period.isEpilogue()) {
            for (Player player : this.playerList) {
                if (player.getDestiny() != Destiny.ALIVE) continue;
                linkedList.add(player);
            }
            return linkedList;
        }
        for (Topic topic : period.getTopicList()) {
            SysEvent sysEvent;
            if (!(topic instanceof SysEvent) || (sysEvent = (SysEvent)topic).getType() != SysEvent.Type.SURVIVOR) continue;
            List<Avatar> list = sysEvent.getAvatarList();
            for (Avatar avatar : list) {
                Player player = this.getPlayer(avatar);
                linkedList.add(player);
            }
        }
        return linkedList;
    }

    public List<Player> getPlayerList() {
        List<Player> list = Collections.unmodifiableList(this.playerList);
        return list;
    }

    public List<Player> getCastingPlayerList() {
        LinkedList<Player> linkedList = new LinkedList<Player>();
        linkedList.addAll(this.playerList);
        Collections.sort(linkedList, castingComparator);
        return linkedList;
    }

    public List<Player> getRoledPlayerList(GameRole gameRole) {
        LinkedList<Player> linkedList = new LinkedList<Player>();
        for (Player player : this.playerList) {
            if (player.getRole() != gameRole) continue;
            linkedList.add(player);
        }
        return linkedList;
    }

    public GameRole.Team getWinnerTeam() {
        return this.winner;
    }

    public int countSuddenDeath() {
        int n = 0;
        for (Player player : this.playerList) {
            if (player.getDestiny() != Destiny.SUDDENDEATH) continue;
            ++n;
        }
        return n;
    }

    public int countAvatarNum() {
        int n = this.playerList.size();
        return n;
    }

    public Player getPlayer(Avatar avatar) {
        Player player = this.playerMap.get(avatar);
        return player;
    }

    private Player registPlayer(Avatar avatar) {
        Player player = this.getPlayer(avatar);
        if (player == null) {
            player = new Player();
            player.setAvatar(avatar);
            this.playerMap.put(avatar, player);
        }
        return player;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastingComparator
    implements Comparator<Player> {
        private CastingComparator() {
        }

        @Override
        public int compare(Player player, Player player2) {
            Avatar avatar;
            if (player == player2) {
                return 0;
            }
            if (player == null && player2 == null) {
                return 0;
            }
            if (player != null && player2 == null) {
                return 1;
            }
            if (player == null && player2 != null) {
                return -1;
            }
            Avatar avatar2 = player.getAvatar();
            int n = avatar2.compareTo(avatar = player2.getAvatar());
            if (n == 0) {
                return 0;
            }
            if (avatar2 == Avatar.AVATAR_GERD) {
                return -1;
            }
            if (avatar == Avatar.AVATAR_GERD) {
                return 1;
            }
            if (player.getDestiny() != Destiny.ALIVE && player2.getDestiny() == Destiny.ALIVE) {
                return -1;
            }
            if (player.getDestiny() == Destiny.ALIVE && player2.getDestiny() != Destiny.ALIVE) {
                return 1;
            }
            if (player.getObitDay() > player2.getObitDay()) {
                return 1;
            }
            if (player.getObitDay() < player2.getObitDay()) {
                return -1;
            }
            int n2 = player.getDestiny().compareTo(player2.getDestiny());
            if (n2 != 0) {
                return n2;
            }
            int n3 = player.getEntryNo() - player2.getEntryNo();
            return n3;
        }
    }
}

