/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.ActionManager;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.Controller;
import jp.sourceforge.jindolf.Discussion;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.PileHandler;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.TopView;

public class Jindolf {
    public static final long loadedNanoCount;
    public static final long loadedTime;
    private static long entryNanoCount;
    private static long entryTime;
    public static final String VERSION = "2.18.2";
    public static final String TITLE;
    public static final String AUTHOR;
    public static final String COPYRIGHT;
    public static final String LICENSE = "The MIT License";
    public static final String CONTACT = "http://jindolf.sourceforge.jp/";
    public static final String ID;
    public static final Class<?> selfClass;
    public static final Package selfPackage;
    public static final Package jrePackage;
    public static final Runtime runtime;
    public static final SecurityManager secManager;
    public static final Logger logger;
    public static final ClassLoader loader;
    private static final Charset CHARSET_UTF8;
    private static final AtomicBoolean invokeFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        boolean bl;
        boolean bl2 = bl = !invokeFlag.compareAndSet(false, true);
        if (bl) {
            System.err.println("\u4e8c\u5ea6\u76ee\u4ee5\u964d\u306e\u8d77\u52d5\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
            return;
        }
        entryNanoCount = System.nanoTime();
        entryTime = System.currentTimeMillis();
        Jindolf.checkCompileError();
        Jindolf.checkEnvironment();
        Jindolf.checkPackageDefinition();
        AppSetting.parseOptions(stringArray);
        if (AppSetting.needHelp()) {
            Jindolf.showHelpMessage();
            runtime.exit(0);
        }
        if (AppSetting.needVersion()) {
            System.out.println(ID);
            runtime.exit(0);
        }
        if (AppSetting.needVMInfo()) {
            System.out.println(AppSetting.getVMInfo());
        }
        if (Jindolf.hasRuntime6() && AppSetting.noSplash()) {
            System.out.println("JRE1.6\u4ee5\u964d\u3067\u306f\u3001Java\u5b9f\u884c\u7cfb\u306e\u65b9\u3067\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u753b\u9762\u306e\u975e\u8868\u793a\u3092\u6307\u793a\u3057\u3066\u304f\u3060\u3055\u3044(\u304a\u305d\u3089\u304f\u7a7a\u306e-splash:\u30aa\u30d7\u30b7\u30e7\u30f3)");
        }
        if (AppSetting.useBoldMetal()) {
            UIManager.put("swing.boldMetal", Boolean.TRUE);
        } else {
            UIManager.put("swing.boldMetal", Boolean.FALSE);
        }
        Jindolf.initLogging();
        logger.info(ID + " \u306f " + new Date(entryTime) + " \u306b\u5b9f\u884c\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002 ");
        logger.info("Initial Nano-Count:" + entryNanoCount);
        logger.info("Max-heap:" + runtime.maxMemory() / 1024L / 1024L + "MByte" + " Total-heap:" + runtime.totalMemory() / 1024L / 1024L + "MByte");
        logger.info("\n" + AppSetting.getVMInfo());
        if (loader == null) {
            logger.log(Level.WARNING, "\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u8a2d\u5b9a\u306b\u3088\u308a\u3001\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        runtime.addShutdownHook(new Thread(){

            public void run() {
                logger.info("\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u51e6\u7406\u306b\u5165\u308a\u307e\u3059\u2026");
                System.out.flush();
                System.err.flush();
                runtime.runFinalization();
                Thread.yield();
            }
        });
        Jindolf.replaceEventQueue();
        Window window = null;
        if (!Jindolf.hasRuntime6() && !AppSetting.noSplash()) {
            window = Jindolf.createSplashWindow();
            window.setVisible(true);
            GUIUtils.dispatchEmptyAWTEvent();
        }
        Jindolf.preInitClass();
        boolean bl3 = false;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Jindolf.startGUI();
                }
            });
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", throwable);
            bl3 = true;
        }
        finally {
            if (window != null) {
                window.setVisible(false);
                window.dispose();
                window = null;
                GUIUtils.dispatchEmptyAWTEvent();
            }
        }
        if (bl3) {
            Jindolf.exit(1);
        }
    }

    private static void startGUI() {
        LandsModel landsModel = new LandsModel();
        try {
            landsModel.loadLandList();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "\u56fd\u5b9a\u7fa9\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", iOException);
            Jindolf.exit(1);
        }
        JFrame jFrame = Jindolf.buildMVC(landsModel);
        GUIUtils.modifyWindowAttributes(jFrame, true, false, true);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        Dimension dimension = new Dimension(AppSetting.initialFrameWidth(), AppSetting.initialFrameHeight());
        jFrame.setSize(dimension);
        if (AppSetting.initialFrameXpos() <= Integer.MIN_VALUE || AppSetting.initialFrameYpos() <= Integer.MIN_VALUE) {
            jFrame.setLocationByPlatform(true);
        } else {
            jFrame.setLocation(AppSetting.initialFrameXpos(), AppSetting.initialFrameYpos());
        }
        jFrame.setVisible(true);
    }

    private static void preInitClass() throws LinkageError, ExceptionInInitializerError {
        Object[] objectArray;
        for (Object object : objectArray = new Object[]{"java.lang.Object", TabBrowser.class, Discussion.class, GlyphDraw.class, HttpURLConnection.class, SimpleDateFormat.class, Void.class}) {
            String string;
            if (object instanceof Class) {
                string = ((Class)object).getName();
            } else {
                if (!(object instanceof String)) continue;
                string = object.toString();
            }
            try {
                if (loader != null) {
                    Class.forName(string, true, loader);
                    continue;
                }
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.WARNING, "\u30af\u30e9\u30b9\u306e\u660e\u793a\u7684\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", classNotFoundException);
            }
        }
    }

    private static void replaceEventQueue() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        EventQueue eventQueue2 = new EventQueue(){

            protected void dispatchEvent(AWTEvent aWTEvent) {
                try {
                    super.dispatchEvent(aWTEvent);
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.SEVERE, "\u30a4\u30d9\u30f3\u30c8\u30c7\u30a3\u30b9\u30d1\u30c3\u30c1\u4e2d\u306b\u7570\u5e38\u304c\u8d77\u304d\u307e\u3057\u305f\u3002", runtimeException);
                    throw runtimeException;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "\u30a4\u30d9\u30f3\u30c8\u30c7\u30a3\u30b9\u30d1\u30c3\u30c1\u4e2d\u306b\u7570\u5e38\u304c\u8d77\u304d\u307e\u3057\u305f\u3002", exception);
                }
                catch (Error error) {
                    logger.log(Level.SEVERE, "\u30a4\u30d9\u30f3\u30c8\u30c7\u30a3\u30b9\u30d1\u30c3\u30c1\u4e2d\u306b\u7570\u5e38\u304c\u8d77\u304d\u307e\u3057\u305f\u3002", error);
                    throw error;
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "\u30a4\u30d9\u30f3\u30c8\u30c7\u30a3\u30b9\u30d1\u30c3\u30c1\u4e2d\u306b\u7570\u5e38\u304c\u8d77\u304d\u307e\u3057\u305f\u3002", throwable);
                }
            }
        };
        eventQueue.push(eventQueue2);
    }

    public static boolean hasRuntime5() {
        boolean bl;
        try {
            bl = jrePackage.isCompatibleWith("1.5");
        }
        catch (NumberFormatException numberFormatException) {
            assert (false);
            return false;
        }
        return bl;
    }

    public static boolean hasRuntime6() {
        boolean bl;
        try {
            bl = jrePackage.isCompatibleWith("1.6");
        }
        catch (NumberFormatException numberFormatException) {
            assert (false);
            return false;
        }
        return bl;
    }

    public static void exit(int n) throws SecurityException {
        logger.info("\u7d42\u4e86\u30b3\u30fc\u30c9[" + n + "]\u3067VM\u3054\u3068\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
        runtime.runFinalization();
        System.out.flush();
        System.err.flush();
        try {
            runtime.exit(n);
        }
        catch (SecurityException securityException) {
            logger.log(Level.WARNING, "\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u8a2d\u5b9a\u306b\u3088\u308a\u3001VM\u3092\u7d42\u4e86\u3055\u305b\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002", securityException);
            throw securityException;
        }
    }

    private static void checkCompileError() {
    }

    private static void checkEnvironment() {
        if (!Jindolf.hasRuntime5()) {
            System.err.println(TITLE + " \u306f JRE1.5 \u4ee5\u964d\u306e\u5b9f\u884c\u74b0\u5883\u3092\u691c\u51fa\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
            runtime.exit(1);
        }
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println(TITLE + " \u306fGUI\u74b0\u5883\u3068\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
            runtime.exit(1);
        }
    }

    private static void checkPackageDefinition() {
        String string = selfPackage.getImplementationVersion();
        if (string != null && !string.equals(VERSION)) {
            System.err.println("\u30d3\u30eb\u30c9\u30a8\u30e9\u30fc\uff1a\u30d1\u30c3\u30b1\u30fc\u30b8\u5b9a\u7fa9\u3068\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002[" + string + "]\u2260[" + VERSION + "]");
            runtime.exit(1);
        }
    }

    public static boolean hasLoggingPermission() {
        if (secManager == null) {
            return true;
        }
        LoggingPermission loggingPermission = new LoggingPermission("control", null);
        try {
            secManager.checkPermission(loggingPermission);
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private static void initLogging() {
        Handler handler;
        boolean bl = Jindolf.hasLoggingPermission();
        if (!bl) {
            System.out.println("\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u8a2d\u5b9a\u306b\u3088\u308a\u3001\u30ed\u30b0\u8a2d\u5b9a\u3092\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        if (bl) {
            logger.setUseParentHandlers(false);
            handler = new PileHandler();
            logger.addHandler(handler);
        }
        if (bl && AppSetting.useConsolelog()) {
            handler = new ConsoleHandler();
            logger.addHandler(handler);
        }
    }

    private static Window createSplashWindow() {
        JWindow jWindow = new JWindow();
        JLabel jLabel = new JLabel(GUIUtils.getLogoIcon());
        jWindow.add(jLabel);
        jWindow.pack();
        jWindow.setLocationRelativeTo(null);
        return jWindow;
    }

    private static JFrame buildMVC(LandsModel landsModel) {
        ActionManager actionManager = new ActionManager();
        TopView topView = new TopView();
        Controller controller = new Controller(actionManager, topView, landsModel);
        JFrame jFrame = controller.createTopFrame();
        return jFrame;
    }

    private static void showHelpMessage() {
        CharSequence charSequence;
        System.out.flush();
        System.err.flush();
        try {
            charSequence = Jindolf.loadResourceText("resources/help.txt");
        }
        catch (IOException iOException) {
            return;
        }
        System.out.print(charSequence);
        System.out.flush();
        System.err.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence loadResourceText(String string) throws IOException {
        InputStream inputStream = Jindolf.getResourceAsStream(string);
        inputStream = new BufferedInputStream(inputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, CHARSET_UTF8);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2;
            while ((string2 = lineNumberReader.readLine()) != null) {
                if (string2.startsWith("#")) continue;
                stringBuilder.append(string2).append('\n');
            }
        }
        finally {
            lineNumberReader.close();
        }
        return stringBuilder;
    }

    public static InputStream getResourceAsStream(String string) {
        return selfClass.getResourceAsStream(string);
    }

    public static URL getResource(String string) {
        return selfClass.getResource(string);
    }

    private Jindolf() {
        assert (false);
        throw new Error();
    }

    static {
        ClassLoader classLoader;
        loadedNanoCount = System.nanoTime();
        loadedTime = System.currentTimeMillis();
        CHARSET_UTF8 = Charset.forName("UTF-8");
        invokeFlag = new AtomicBoolean(false);
        selfClass = Jindolf.class;
        selfPackage = selfClass.getPackage();
        jrePackage = Object.class.getPackage();
        runtime = Runtime.getRuntime();
        secManager = System.getSecurityManager();
        logger = Logger.getLogger(selfPackage.getName());
        try {
            classLoader = selfClass.getClassLoader();
        }
        catch (SecurityException securityException) {
            classLoader = null;
        }
        loader = classLoader;
        String string = selfPackage.getImplementationTitle();
        TITLE = string != null ? string : "Jindolf";
        String string2 = selfPackage.getImplementationVendor();
        AUTHOR = string2 != null ? string2 : "olyutorskii";
        COPYRIGHT = "Copyright(c) 2008 " + AUTHOR;
        ID = TITLE + " Ver." + VERSION + " " + COPYRIGHT + " (" + LICENSE + ")";
    }
}

