/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.TextPopup;

public class LogFrame
extends JDialog
implements WindowListener,
ActionListener {
    private static final String FRAMETITLE = "\u30ed\u30b0\u8868\u793a - " + Jindolf.TITLE;
    private static final int DOCLIMIT = 100000;
    private static final float CHOPRATIO = 0.9f;
    private static final int CHOPPEDLEN = 90000;
    private static final Document dummyDoc = new PlainDocument();
    private final JTextArea textarea;
    private final Document document = new PlainDocument();
    private final JScrollPane scrollPane;
    private final JScrollBar vertical;
    private final Handler handler;
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");

    public LogFrame(Frame frame) {
        super(frame, FRAMETITLE, false);
        this.handler = Jindolf.hasLoggingPermission() ? new SwingLogger() : null;
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.textarea = new JTextArea();
        this.textarea.setEditable(false);
        this.textarea.setLineWrap(true);
        this.textarea.setDocument(dummyDoc);
        Border border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.textarea.setBorder(border);
        GUIUtils.forceMonoPitchFont(this.textarea);
        TextPopup textPopup = new TextPopup();
        this.textarea.setComponentPopupMenu(textPopup);
        this.scrollPane = new JScrollPane(this.textarea);
        this.vertical = this.scrollPane.getVerticalScrollBar();
        this.design();
        this.clearButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    private void design() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        container.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        container.add((Component)this.clearButton, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        container.add((Component)this.closeButton, gridBagConstraints);
    }

    public Handler getHandler() {
        return this.handler;
    }

    private void showLastPos() {
        if (!this.isVisible()) {
            return;
        }
        if (this.textarea.getDocument() != this.document) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogFrame.this.vertical.setValue(Integer.MAX_VALUE);
            }
        });
    }

    private void close() {
        this.setVisible(false);
    }

    private void clear() {
        block2: {
            try {
                this.document.remove(0, this.document.getLength());
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.textarea.setDocument(this.document);
            this.showLastPos();
        } else {
            this.textarea.setDocument(dummyDoc);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.textarea.setDocument(dummyDoc);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.textarea.setDocument(this.document);
        this.showLastPos();
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.textarea.setDocument(this.document);
        this.showLastPos();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clearButton) {
            this.clear();
        } else if (object == this.closeButton) {
            this.close();
        }
    }

    private class SwingLogger
    extends Handler {
        private SwingLogger() {
            SimpleFormatter simpleFormatter = new SimpleFormatter();
            this.setFormatter(simpleFormatter);
        }

        public void publish(LogRecord logRecord) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            Formatter formatter = this.getFormatter();
            String string = formatter.format(logRecord);
            try {
                LogFrame.this.document.insertString(LogFrame.this.document.getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            int n = LogFrame.this.document.getLength();
            if (n > 100000) {
                int n2 = n - 90000;
                try {
                    LogFrame.this.document.remove(0, n2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            LogFrame.this.showLastPos();
        }

        public void flush() {
        }

        public void close() {
            this.setLevel(Level.OFF);
            this.flush();
        }
    }
}

