/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.HtmlSequence;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.StringUtils;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period {
    private static final Pattern villageInfoRegex;
    private static final Pattern startMessageRegex;
    private static final Pattern switchTagRegex;
    private static final Pattern talkRegex;
    private static final Pattern eventBodyRegex;
    private static final Pattern anchorRegex;
    private static final Pattern loginRegex;
    private static final String[][] enRefTable;
    private static final Pattern enRefRegex;
    private final Village homeVillage;
    private final Type periodType;
    private final int day;
    private int limitHour;
    private int limitMinute;
    private String loginName;
    private boolean isFullOpen = false;
    private final List<Topic> topicList = new LinkedList<Topic>();
    private final List<Topic> unmodList = Collections.unmodifiableList(this.topicList);
    private final Map<Avatar, int[]> countMap = new HashMap<Avatar, int[]>();
    private boolean isHot;

    public static CharSequence resolveRef(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        int n = 0;
        Matcher matcher = enRefRegex.matcher(charSequence);
        while (matcher.find()) {
            for (int i = 0; i < enRefTable.length; ++i) {
                int n2 = matcher.start(i + 1);
                int n3 = matcher.end(i + 1);
                if (n2 < 0) continue;
                stringBuilder.append(charSequence, n, n2);
                stringBuilder.append(enRefTable[i][1]);
                n = n3;
            }
        }
        stringBuilder.append(charSequence, n, charSequence.length());
        return stringBuilder;
    }

    public Period(Village village, Type type, int n) throws NullPointerException {
        this(village, type, n, false);
    }

    private Period(Village village, Type type, int n, boolean bl) throws NullPointerException {
        if (village == null || type == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IllegalArgumentException("Period day is too small !");
        }
        switch (type) {
            case PROLOGUE: {
                assert (n == 0);
                break;
            }
            case PROGRESS: 
            case EPILOGUE: {
                assert (n > 0);
                break;
            }
        }
        this.homeVillage = village;
        this.periodType = type;
        this.day = n;
        this.unload();
        this.isHot = bl;
    }

    public Village getVillage() {
        return this.homeVillage;
    }

    public Type getType() {
        return this.periodType;
    }

    public int getDay() {
        return this.day;
    }

    public String getLimit() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.limitHour < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.limitHour).append(':');
        if (this.limitMinute < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.limitMinute);
        return stringBuilder.toString();
    }

    public boolean isHot() {
        return this.isHot;
    }

    public void setHot(boolean bl) {
        this.isHot = bl;
    }

    public boolean isPrologue() {
        return this.getType() == Type.PROLOGUE;
    }

    public boolean isEpilogue() {
        return this.getType() == Type.EPILOGUE;
    }

    public boolean isProgress() {
        return this.getType() == Type.PROGRESS;
    }

    public String getCGIQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        Village village = this.getVillage();
        stringBuilder.append(village.getCGIQuery());
        if (this.isHot()) {
            stringBuilder.append("&mes=all");
            return stringBuilder.toString();
        }
        stringBuilder.append("&meslog=").append(village.getVillageID());
        switch (this.getType()) {
            case PROLOGUE: {
                stringBuilder.append("_ready_0");
                break;
            }
            case PROGRESS: {
                stringBuilder.append("_progress_").append(this.getDay() - 1);
                break;
            }
            case EPILOGUE: {
                stringBuilder.append("_party_").append(this.getDay() - 1);
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        stringBuilder.append("&mes=all");
        return stringBuilder.toString();
    }

    public List<Topic> getTopicList() {
        return this.unmodList;
    }

    public int getTopics() {
        return this.topicList.size();
    }

    protected void addTopic(Topic topic) throws NullPointerException {
        if (topic == null) {
            throw new NullPointerException();
        }
        this.topicList.add(topic);
    }

    public String getCaption() {
        String string;
        switch (this.getType()) {
            case PROLOGUE: {
                string = "\u30d7\u30ed\u30ed\u30fc\u30b0";
                break;
            }
            case PROGRESS: {
                string = "" + this.getDay() + "\u65e5\u76ee";
                break;
            }
            case EPILOGUE: {
                string = "\u30a8\u30d4\u30ed\u30fc\u30b0";
                break;
            }
            default: {
                assert (false);
                string = null;
            }
        }
        return string;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public boolean isFullOpen() {
        return this.isFullOpen;
    }

    public boolean hasLoaded() {
        return this.getTopics() > 0;
    }

    public void reloadPeriod() throws IOException {
        this.loadPeriod(true);
    }

    public void updatePeriod() throws IOException {
        this.loadPeriod(false);
    }

    public void loadPeriod(boolean bl) throws IOException {
        if (!bl && this.hasLoaded()) {
            return;
        }
        Village village = this.getVillage();
        Land land = village.getParentLand();
        ServerAccess serverAccess = land.getServerAccess();
        this.isFullOpen = village.getState() != Village.State.PROGRESS ? true : this.getType() != Type.PROGRESS;
        HtmlSequence htmlSequence = serverAccess.getHTMLPeriod(this);
        this.topicList.clear();
        this.countMap.clear();
        int n = 0;
        int n2 = htmlSequence.length();
        n = this.parseLoginForm(htmlSequence, n, n2);
        n = this.parseDeadLine(htmlSequence, n, n2);
        boolean bl2 = this.isHot();
        n = this.parseDayLink(htmlSequence, n, n2);
        if (bl2 && !this.isHot()) {
            this.reloadPeriod();
            return;
        }
        n = this.parseTopics(htmlSequence, n, n2);
    }

    private int parseLoginForm(CharSequence charSequence, int n, int n2) {
        int n3 = n;
        this.loginName = null;
        Matcher matcher = loginRegex.matcher(charSequence);
        matcher.region(n, n2);
        if (!matcher.find()) {
            return n3;
        }
        n3 = matcher.end();
        String string = matcher.group(1);
        if (string != null && string.length() > 0) {
            this.loginName = string;
        }
        return n3;
    }

    private int parseDeadLine(CharSequence charSequence, int n, int n2) {
        int n3 = n;
        Matcher matcher = villageInfoRegex.matcher(charSequence);
        matcher.region(n, n2);
        if (!matcher.find()) {
            return n3;
        }
        n3 = matcher.end();
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        String string4 = matcher.group(4);
        String string5 = matcher.group(5);
        String string6 = matcher.group(6);
        int n4 = Integer.parseInt(string2);
        int n5 = Integer.parseInt(string3);
        int n6 = Integer.parseInt(string5);
        int n7 = Integer.parseInt(string6);
        if (string4.equals("\u5348\u5f8c")) {
            n6 += 12;
        }
        this.limitHour = n6 %= 24;
        this.limitMinute = n7;
        return n3;
    }

    private int parseDayLink(CharSequence charSequence, int n, int n2) {
        int n3 = n;
        Matcher matcher = anchorRegex.matcher(charSequence);
        matcher.region(n, n2);
        while (matcher.find()) {
            n3 = matcher.end();
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            if (string2.equals("\u30d7\u30ed\u30ed\u30fc\u30b0")) {
                if (this.getType() != Type.PROLOGUE) continue;
                this.setHot(false);
                continue;
            }
            if (string2.endsWith("\u65e5\u76ee")) {
                int n4 = Integer.parseInt(string3);
                if (this.getType() != Type.PROGRESS || this.getDay() != n4) continue;
                this.setHot(false);
                continue;
            }
            if (string2.equals("\u30a8\u30d4\u30ed\u30fc\u30b0")) {
                if (this.getType() != Type.EPILOGUE) continue;
                this.setHot(false);
                continue;
            }
            if (!string2.equals("\u7d42\u4e86")) continue;
            break;
        }
        return n3;
    }

    private int parseTopics(HtmlSequence htmlSequence, int n, int n2) {
        int n3;
        int n4 = n;
        while ((n3 = this.findTopic(htmlSequence, n4, n2)) > n4) {
            n4 = n3;
        }
        return n4;
    }

    private int findTopic(HtmlSequence htmlSequence, int n, int n2) {
        int n3;
        Matcher matcher = startMessageRegex.matcher(htmlSequence);
        matcher.region(n, n2);
        if (!matcher.find()) {
            return n;
        }
        int n4 = matcher.end();
        matcher = switchTagRegex.matcher(htmlSequence);
        matcher.region(n4, n2);
        if (!matcher.find()) {
            return n;
        }
        n4 = matcher.end();
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        if (string != null) {
            SysEvent.EventClass eventClass = SysEvent.decodeEventClass(string);
            n3 = this.findSystemEvent(eventClass, htmlSequence, n4, n2);
        } else {
            n3 = this.findTalk(string2, string3, htmlSequence, n4, n2);
        }
        if (n4 >= n3) {
            return n;
        }
        return n3;
    }

    private int findSystemEvent(SysEvent.EventClass eventClass, CharSequence charSequence, int n, int n2) {
        Matcher matcher = eventBodyRegex.matcher(charSequence);
        matcher.region(n, n2);
        if (!matcher.find()) {
            return n;
        }
        int n3 = matcher.end();
        String string = matcher.group(1);
        SysEvent sysEvent = new SysEvent(eventClass, string);
        this.addTopic(sysEvent);
        SysEvent.Type type = sysEvent.getType();
        if (type == SysEvent.Type.MURDER || type == SysEvent.Type.NOMURDER) {
            for (Topic topic : this.topicList) {
                Talk talk;
                if (!(topic instanceof Talk) || (talk = (Talk)topic).getTalkType() != Talk.Type.WOLFONLY || !StringUtils.isTerminated(talk.getDialog(), "\uff01 \u4eca\u65e5\u304c\u304a\u524d\u306e\u547d\u65e5\u3060\uff01")) continue;
                talk.setCount(-1);
                this.countMap.clear();
            }
        }
        return n3;
    }

    private int findTalk(String string, String string2, HtmlSequence htmlSequence, int n, int n2) {
        Image image;
        Matcher matcher = talkRegex.matcher(htmlSequence);
        matcher.region(n, n2);
        if (!matcher.find()) {
            return n;
        }
        int n3 = matcher.end();
        int n4 = StringUtils.parseInt((CharSequence)htmlSequence, matcher, 2);
        int n5 = StringUtils.parseInt((CharSequence)htmlSequence, matcher, 3);
        if (StringUtils.compareSubSequence("\u5348\u5f8c", htmlSequence, matcher.start(1), matcher.end(1)) == 0) {
            n4 += 12;
        }
        n4 %= 24;
        CharSequence charSequence = htmlSequence.subSequence(matcher.start(6), matcher.end(6));
        Talk.Type type = Talk.decodeType(charSequence);
        if (type == null) {
            return n;
        }
        Village village = this.getVillage();
        Land land = village.getParentLand();
        Avatar avatar = village.getAvatar(string2);
        if (avatar == null) {
            avatar = new Avatar(string2);
            village.addAvatar(avatar);
        }
        String string3 = matcher.group(4);
        if (type == Talk.Type.GRAVE) {
            if (village.getGraveImage() == null) {
                image = land.downloadImage(string3);
                village.setGraveImage(image);
            }
        } else if (village.getAvatarFaceImage(avatar) == null && string3 != null) {
            image = land.downloadImage(string3);
            village.putAvatarFaceImage(avatar, image);
        }
        int n6 = matcher.start(8);
        int n7 = matcher.end(8);
        CharSequence charSequence2 = htmlSequence.subSequence(n6, n7);
        SortedMap<Long, byte[]> sortedMap = htmlSequence.subEncodeError(n6, n7);
        charSequence2 = Period.resolveRef(charSequence2);
        Talk talk = new Talk(this, type, avatar, string, n4, n5, charSequence2, sortedMap);
        int[] nArray = this.countMap.get(avatar);
        if (nArray == null) {
            nArray = new int[4];
            this.countMap.put(avatar, nArray);
        }
        int n8 = type.ordinal();
        int n9 = nArray[n8] + 1;
        nArray[n8] = n9;
        int n10 = n9;
        talk.setCount(n10);
        this.addTopic(talk);
        return n3;
    }

    public void unload() {
        this.limitHour = 0;
        this.limitMinute = 0;
        this.loginName = null;
        this.isFullOpen = false;
        this.isHot = false;
        this.topicList.clear();
        this.countMap.clear();
    }

    static {
        enRefTable = new String[][]{{"<br />", "\n"}, {"&lt;", "<"}, {"&gt;", ">"}, {"&quot;", "\""}, {"&amp;", "&"}};
        String string = " \\t\\n\\r";
        String string2 = "[" + string + "]";
        String string3 = string2 + "*";
        String string4 = string2 + "+";
        String string5 = ">" + string3 + "([^<]+?)" + string3 + "<strong>" + string3 + "[\\(\uff08]" + string3 + "([1-9][0-9]?)/([1-9][0-9]?)" + string3 + "(\u5348\u524d|\u5348\u5f8c)" + string3 + "([0-9][0-9]?)\u6642" + string3 + "([0-9][0-9]?)\u5206" + string3 + "\u306b\u66f4\u65b0" + string3 + "[\\)\uff09]" + string3 + "</strong>";
        String string6 = string3 + "<div class=\"message\">" + string3;
        String string7 = "<div class=\"(announce|order|extra)\">";
        String string8 = "<a name=\"([^\"]+)\">([^<]+)</a>";
        String string9 = string3 + "(?:" + string7 + "|" + string8 + ")" + string3;
        String string10 = "<br" + string3 + "/>";
        String string11 = "<a" + string4 + "href=\"([^\"]*)\"" + string3 + ">";
        String string12 = "</a>";
        String string13 = string11 + "([^<]*)" + string12;
        String string14 = "</div>";
        String string15 = string3 + "<span class=\"time\">" + string3 + "(\u5348\u524d|\u5348\u5f8c)" + string3 + "([0-9][0-9]?)\u6642" + string3 + "([0-9][0-9]?)\u5206" + string3 + "</span>" + string3 + "<table [^>]*? class=\"message_box\">" + string3 + "<tr>" + string3 + "<td width=\"[^\"]*\">" + string3 + "<img src=\"([^\"]+)\">" + string3 + "</td>" + string3 + "<td width=\"[^\"]*\">" + string3 + "<img src=\"([^\"]+)\">" + string3 + "</td>" + string3 + "<td>" + string3 + "<div class=\"mes_([^\"]+)_body[01]\">" + string3 + "<div class=\"mes_([^\"]+)_body[01]\">" + string3 + "(.*?)" + string3 + "<?/div>" + string3 + string14 + string3 + "</td>" + string3 + "</tr>" + string3 + "</table>" + string3 + string14 + string3;
        String string16 = "(?:[^<]*?|" + string10 + "|" + string13 + ")*?";
        string16 = "(" + string16 + ")" + string3 + string14 + string3 + string14 + string3;
        String string17 = "\u30d7\u30ed\u30ed\u30fc\u30b0";
        String string18 = "\u30a8\u30d4\u30ed\u30fc\u30b0";
        String string19 = "\u7d42\u4e86";
        String string20 = "([1-9][0-9]*)\u65e5\u76ee";
        String string21 = "(" + string17 + "|" + string18 + "|" + string20 + "|" + string19 + ")";
        String string22 = string11 + string21 + string12;
        String string23 = "<input type=(?:\"hidden\"|\"text\")(?: size=\"10\")? name=\"user_id\" value=\"([^\"]*)\" />|\\Q<a href=\"index.rb?cmd=to_sign_in\">sign in</a>\\E";
        villageInfoRegex = Pattern.compile(string5, 32);
        startMessageRegex = Pattern.compile(string6, 32);
        switchTagRegex = Pattern.compile(string9, 32);
        talkRegex = Pattern.compile(string15, 32);
        eventBodyRegex = Pattern.compile(string16, 32);
        anchorRegex = Pattern.compile(string22, 32);
        loginRegex = Pattern.compile(string23, 32);
        String string24 = "";
        for (String[] stringArray : enRefTable) {
            if (string24.length() > 0) {
                string24 = string24 + "|";
            }
            String string25 = "(" + stringArray[0] + ")";
            string24 = string24 + string25;
        }
        enRefRegex = Pattern.compile(string24, 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PROLOGUE,
        PROGRESS,
        EPILOGUE;

    }
}

