/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.sourceforge.jindolf.CodeX0208;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SjisInputStream
extends InputStream {
    private static final int UNDEFCHAR = 63;
    private final InputStream in;
    private int pushChar;
    private long charCount;
    private final SortedMap<Long, byte[]> encodeError = new TreeMap<Long, byte[]>();

    public SjisInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.init();
    }

    @Override
    public int read() throws IOException {
        if (this.pushChar >= 0) {
            int n = this.pushChar;
            this.pushChar = -1;
            ++this.charCount;
            return n;
        }
        int n = this.in.read();
        if (n < 0) {
            return -1;
        }
        if (!CodeX0208.isShiftJIS1stByte((byte)n)) {
            ++this.charCount;
            return n;
        }
        int n2 = this.in.read();
        if (n2 < 0) {
            this.pushEncodeError(new byte[]{(byte)n});
            ++this.charCount;
            return 63;
        }
        if (!CodeX0208.isShiftJIS2ndByte((byte)n2)) {
            this.pushEncodeError(new byte[]{(byte)n, (byte)n2});
            ++this.charCount;
            return 63;
        }
        if (!CodeX0208.isValidSJIS0208_1990(n, n2)) {
            this.pushEncodeError(new byte[]{(byte)n, (byte)n2});
            ++this.charCount;
            return 63;
        }
        this.pushChar = n2;
        return n;
    }

    @Override
    public int available() throws IOException {
        int n = this.in.available();
        if (this.pushChar >= 0) {
            ++n;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    protected void init() {
        this.pushChar = -1;
        this.charCount = 0L;
        this.encodeError.clear();
    }

    public long getCharCount() {
        return this.charCount;
    }

    protected void pushEncodeError(byte[] byArray) {
        this.encodeError.put(this.charCount, byArray);
    }

    public SortedMap<Long, byte[]> getEncodeError() {
        SortedMap<Long, byte[]> sortedMap = Collections.unmodifiableSortedMap(this.encodeError);
        return sortedMap;
    }
}

