/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static int parseInt(CharSequence charSequence, Matcher matcher, int n) throws IndexOutOfBoundsException {
        return StringUtils.parseInt(charSequence, matcher.start(n), matcher.end(n));
    }

    public static int parseInt(CharSequence charSequence) {
        return StringUtils.parseInt(charSequence, 0, charSequence.length());
    }

    public static int parseInt(CharSequence charSequence, int n, int n2) throws IndexOutOfBoundsException {
        char c;
        int n3;
        int n4 = 0;
        for (int i = n; i < n2 && (n3 = Character.digit(c = charSequence.charAt(i), 10)) >= 0; ++i) {
            n4 *= 10;
            n4 += n3;
        }
        return n4;
    }

    public static CharSequence suppressString(CharSequence charSequence) {
        String string = ((Object)charSequence).toString();
        if ((string = string.replaceAll("[ \\t\\n\\r\u3000]", "")).length() <= 10) {
            return string;
        }
        int n = string.length();
        String string2 = string.substring(0, 5);
        String string3 = string.substring(n - 5, n);
        string = string2 + "\u2026" + string3;
        return string;
    }

    public static SortedSet<Integer> parseIntList(CharSequence charSequence) throws NullPointerException {
        String[] stringArray;
        Pattern pattern = Pattern.compile("[, \\t]+");
        Pattern pattern2 = Pattern.compile("[ \\t]*\\-[ \\t]*");
        if (charSequence == null) {
            throw new NullPointerException();
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        SortedSet<Integer> sortedSet = Collections.unmodifiableSortedSet(treeSet);
        if (charSequence.length() <= 0) {
            return sortedSet;
        }
        for (String string : stringArray = pattern.split(charSequence)) {
            int n;
            int n2;
            int n3;
            if (string == null || string.length() <= 0) continue;
            String[] stringArray2 = pattern2.split(string);
            if (stringArray2.length >= 3) {
                throw new IllegalArgumentException(string);
            }
            try {
                n3 = Integer.parseInt(stringArray2[0]);
                n2 = stringArray2.length >= 2 ? Integer.parseInt(stringArray2[1]) : n3;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string, numberFormatException);
            }
            if (n3 > n2) {
                n = n3;
                n3 = n2;
                n2 = n;
                assert (n3 <= n2);
            }
            for (n = n3; n <= n2; ++n) {
                treeSet.add(n);
            }
        }
        return sortedSet;
    }

    public static boolean isTerminated(CharSequence charSequence, CharSequence charSequence2) throws NullPointerException {
        int n;
        if (charSequence == null || charSequence2 == null) {
            throw new NullPointerException();
        }
        int n2 = charSequence.length();
        int n3 = n2 - (n = charSequence2.length());
        if (n3 < 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(n3 + i);
            if (c2 == (c = charSequence2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int compareSubSequence(CharSequence charSequence, int n, int n2, CharSequence charSequence2, int n3, int n4) throws IndexOutOfBoundsException {
        int n5;
        int n6;
        int n7 = n;
        for (int i = n3; n7 < n2 && i < n4; ++n7, ++i) {
            n6 = charSequence.charAt(n7);
            int n8 = n6 - (n5 = (int)charSequence2.charAt(i));
            if (n8 == 0) continue;
            return n8;
        }
        n6 = n2 - n;
        n5 = n4 - n3;
        if (n6 == n5) {
            return 0;
        }
        if (n6 < n5) {
            return -1;
        }
        return 1;
    }

    public static int compareSubSequence(CharSequence charSequence, CharSequence charSequence2, int n, int n2) throws IndexOutOfBoundsException {
        int n3 = StringUtils.compareSubSequence(charSequence, 0, charSequence.length(), charSequence2, n, n2);
        return n3;
    }

    private StringUtils() {
        assert (false);
        throw new Error();
    }
}

