/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GameRole;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.StringUtils;
import jp.sourceforge.jindolf.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysEvent
implements Topic {
    private static final Pattern defaultRegex = Pattern.compile(".+", 32);
    private static final Pattern newlineRegex = Pattern.compile("\\n*");
    private static final Pattern hhmmRegex = Pattern.compile("(?:(\u5348\u524d)|(\u5348\u5f8c)) ([0-9]+)\u6642 ([0-9]+)\u5206");
    private final EventClass eventClass;
    private CharSequence message;
    private Type type = Type.UNKNOWN;
    private final List<Avatar> avatarList = new LinkedList<Avatar>();
    private final List<GameRole> roleList = new LinkedList<GameRole>();
    private final List<Integer> integerList = new LinkedList<Integer>();
    private final List<CharSequence> charseqList = new LinkedList<CharSequence>();
    private static final Pattern startentryRegex = Pattern.compile("\u663c\u9593\u306f\u4eba\u9593\u306e\u3075\u308a\u3092\u3057\u3066\u3001\u591c\u306b\u6b63\u4f53\u3092\u73fe\u3059\u3068\u3044\u3046\u4eba\u72fc\u3002\\n\u305d\u306e\u4eba\u72fc\u304c\u3001\u3053\u306e\u6751\u306b\u7d1b\u308c\u8fbc\u3093\u3067\u3044\u308b\u3068\u3044\u3046\u5642\u304c\u5e83\u304c\u3063\u305f\u3002\\n\\n\u6751\u4eba\u9054\u306f\u534a\u4fe1\u534a\u7591\u306a\u304c\u3089\u3082\u3001\u6751\u306f\u305a\u308c\u306e\u5bbf\u306b\u96c6\u3081\u3089\u308c\u308b\u3053\u3068\u306b\u306a\u3063\u305f\u3002");
    private static final Pattern startmirrorRegex = Pattern.compile("\u3055\u3042\u3001\u81ea\u3089\u306e\u59ff\u3092\u93e1\u306b\u6620\u3057\u3066\u307f\u3088\u3046\u3002\\n\u305d\u3053\u306b\u6620\u308b\u306e\u306f\u305f\u3060\u306e\u6751\u4eba\u304b\u3001\u305d\u308c\u3068\u3082\u8840\u306b\u98e2\u3048\u305f\u4eba\u72fc\u304b\u3002\\n\\n\u4f8b\u3048\u4eba\u72fc\u3067\u3082\u3001\u591a\u4eba\u6570\u3067\u7acb\u3061\u5411\u304b\u3048\u3070\u6016\u304f\u306f\u306a\u3044\u3002\\n\u554f\u984c\u306f\u3001\u3060\u308c\u304c\u4eba\u72fc\u306a\u306e\u304b\u3068\u3044\u3046\u4e8b\u3060\u3002\\n\u5360\u3044\u5e2b\u306e\u80fd\u529b\u3092\u6301\u3064\u4eba\u9593\u306a\u3089\u3070\u3001\u305d\u308c\u3092\u898b\u7834\u308c\u308b\u3060\u308d\u3046\u3002");
    private static final Pattern startmurderRegex = Pattern.compile("\u3064\u3044\u306b\u72a0\u7272\u8005\u304c\u51fa\u305f\u3002\u4eba\u72fc\u306f\u3053\u306e\u6751\u4eba\u9054\u306e\u306a\u304b\u306b\u3044\u308b\u3002\\n\u3057\u304b\u3057\u3001\u305d\u308c\u3092\u898b\u5206\u3051\u308b\u624b\u6bb5\u306f\u306a\u3044\u3002\\n\\n\u6751\u4eba\u9054\u306f\u3001\u7591\u308f\u3057\u3044\u8005\u3092\u6392\u9664\u3059\u308b\u305f\u3081\u3001\u6295\u7968\u3092\u884c\u3046\u4e8b\u306b\u3057\u305f\u3002\\n\u7121\u5b9f\u306e\u72a0\u7272\u8005\u304c\u51fa\u308b\u306e\u3082\u3084\u3080\u3092\u3048\u306a\u3044\u3002\u6751\u304c\u5168\u6ec5\u3059\u308b\u3088\u308a\u306f\u2026\u2026\u3002\\n\\n\u6700\u5f8c\u307e\u3067\u6b8b\u308b\u306e\u306f\u6751\u4eba\u304b\u3001\u305d\u308c\u3068\u3082\u4eba\u72fc\u304b\u3002");
    private static final Pattern nomurderRegex = Pattern.compile("\u4eca\u65e5\u306f\u72a0\u7272\u8005\u304c\u3044\u306a\u3044\u3088\u3046\u3060\u3002\u4eba\u72fc\u306f\u8972\u6483\u306b\u5931\u6557\u3057\u305f\u306e\u3060\u308d\u3046\u304b\u3002");
    private static final Pattern winvillageRegex = Pattern.compile("\u5168\u3066\u306e\u4eba\u72fc\u3092\u9000\u6cbb\u3057\u305f\u2026\u2026\u3002\u4eba\u72fc\u306b\u602f\u3048\u308b\u65e5\u3005\u306f\u53bb\u3063\u305f\u306e\u3060\uff01");
    private static final Pattern winwolfRegex = Pattern.compile("\u3082\u3046\u4eba\u72fc\u306b\u62b5\u6297\u3067\u304d\u308b\u307b\u3069\u6751\u4eba\u306f\u6b8b\u3063\u3066\u3044\u306a\u3044\u2026\u2026\u3002\\n\u4eba\u72fc\u306f\u6b8b\u3063\u305f\u6751\u4eba\u3092\u5168\u3066\u98df\u3089\u3044\u3001\u5225\u306e\u7372\u7269\u3092\u6c42\u3081\u3066\u3053\u306e\u6751\u3092\u53bb\u3063\u3066\u3044\u3063\u305f\u3002");
    private static final Pattern winhamsterRegex = Pattern.compile("\u5168\u3066\u306f\u7d42\u308f\u3063\u305f\u304b\u306e\u3088\u3046\u306b\u898b\u3048\u305f\u3002\\n\u3060\u304c\u3001\u5974\u304c\u751f\u304d\u6b8b\u3063\u3066\u3044\u305f\u2026\u2026\u3002");
    private static final Pattern nothingRegex = Pattern.compile("\u2026\u2026\u3002");
    private static Object[][] simpleRegexToType = new Object[][]{{startentryRegex, Type.STARTENTRY}, {startmirrorRegex, Type.STARTMIRROR}, {startmurderRegex, Type.STARTMURDER}, {nomurderRegex, Type.NOMURDER}, {winvillageRegex, Type.WINVILLAGE}, {winwolfRegex, Type.WINWOLF}, {winhamsterRegex, Type.WINHAMSTER}, {nothingRegex, Type.NOTHING}};
    private static final Pattern onstageRegex_1 = Pattern.compile("([0-9]+)\u4eba\u76ee\u3001");
    private static final Pattern onstageRegex_2 = Pattern.compile("\u3002");
    private static final Pattern openroleRegex_1 = Pattern.compile("\u3069\u3046\u3084\u3089\u3053\u306e\u4e2d\u306b\u306f\u3001");
    private static final Pattern openroleRegex_2 = Pattern.compile("\u304c([0-9]+)\u540d\u3001?");
    private static final Pattern openroleRegex_3 = Pattern.compile("\u3044\u308b\u3088\u3046\u3060\u3002");
    private static final Pattern survivorRegex_1 = Pattern.compile("\u73fe\u5728\u306e\u751f\u5b58\u8005\u306f");
    private static final Pattern survivorRegex_2 = Pattern.compile("\u3001");
    private static final Pattern survivorRegex_3 = Pattern.compile(" \u306e ([0-9]*) \u540d\u3002");
    private static final Pattern countingRegex_1 = Pattern.compile(" \u306f ");
    private static final Pattern countingRegex_2 = Pattern.compile(" \u306b\u6295\u7968\u3057\u305f\u3002\\n*");
    private static final Pattern countingRegex_3 = Pattern.compile(" \u306f\u6751\u4eba\u9054\u306e\u624b\u306b\u3088\u308a\u51e6\u5211\u3055\u308c\u305f\u3002");
    private static final Pattern suddendeathRegex_1 = Pattern.compile(" \u306f\u3001\u7a81\u7136\u6b7b\u3057\u305f\u3002");
    private static final Pattern murderRegex_1 = Pattern.compile("\u6b21\u306e\u65e5\u306e\u671d\u3001");
    private static final Pattern murderRegex_2 = Pattern.compile(" \u3068 ");
    private static final Pattern murderRegex_3 = Pattern.compile(" \u304c\u7121\u6b8b\u306a\u59ff\u3067\u767a\u898b\u3055\u308c\u305f\u3002");
    private static final Pattern pllistRegex_1 = Pattern.compile(" \uff08([^<]+?)\uff09\u3001");
    private static final Pattern pllistRegex_2 = Pattern.compile(" \uff08(?:<a href=\"([^\"]*)\">([^<]+)</a>)\uff09\u3001");
    private static final Pattern pllistRegex_3 = Pattern.compile("(?:(\u751f\u5b58)|(\u6b7b\u4ea1))\u3002");
    private static final Pattern pllistRegex_4 = Pattern.compile("\u3060\u3063\u305f\u3002\\n*");
    private static final Pattern gameoverRegex = Pattern.compile("\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
    private static final Pattern recruitRegex_1 = Pattern.compile("\u6f14\u3058\u305f\u3044\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u3092\u9078\u3073\u3001\u767a\u8a00\u3057\u3066\u304f\u3060\u3055\u3044\u3002\\n");
    private static final Pattern recruitRegex_2 = Pattern.compile(" \u306b([0-9]+)\u540d\u4ee5\u4e0a\u304c\u30a8\u30f3\u30c8\u30ea\u30fc\u3057\u3066\u3044\u308c\u3070\u9032\u884c\u3057\u307e\u3059\u3002\\n");
    private static final Pattern recruitRegex_3 = Pattern.compile("\u6700\u5927([0-9]+)\u540d\u307e\u3067\u53c2\u52a0\u53ef\u80fd\u3067\u3059\u3002\\n\\n");
    private static final Pattern recruitRegex_4 = Pattern.compile("\u203b\u30a8\u30f3\u30c8\u30ea\u30fc\u306f\u53d6\u308a\u6d88\u305b\u307e\u305b\u3093\u3002\u30eb\u30fc\u30eb\u3092\u3088\u304f\u7406\u89e3\u3057\u305f\u4e0a\u3067\u3054\u53c2\u52a0\u4e0b\u3055\u3044\u3002\\n\u203b\u59cb\u3081\u3066\u306e\u65b9\u306f\u3001\u6751\u4eba\u5e0c\u671b\u3067\u306e\u53c2\u52a0\u3068\u306a\u308a\u307e\u3059\u3002\\n\u203b\u5e0c\u671b\u80fd\u529b\u306b\u3064\u3044\u3066\u306e\u767a\u8a00\u306f\u63a7\u3048\u3066\u304f\u3060\u3055\u3044\u3002");
    private static final Pattern wordlessRegex_1 = Pattern.compile("\u672c\u65e5\u307e\u3060\u767a\u8a00\u3057\u3066\u3044\u306a\u3044\u8005\u306f\u3001");
    private static final Pattern wordlessRegex_2 = Pattern.compile("\u3001");
    private static final Pattern wordlessRegex_3 = Pattern.compile("\u4ee5\u4e0a ([0-9]+) \u540d\u3002");
    private static final Pattern promptRegex_1 = Pattern.compile(" \u307e\u3067\u306b\u3001\u8ab0\u3092\u51e6\u5211\u3059\u308b\u3079\u304d\u304b\u306e\u6295\u7968\u5148\u3092\u6c7a\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002\\n\u4e00\u756a\u7968\u3092\u96c6\u3081\u305f\u4eba\u7269\u304c\u51e6\u5211\u3055\u308c\u307e\u3059\u3002\u540c\u6570\u3060\u3063\u305f\u5834\u5408\u306f\u30e9\u30f3\u30c0\u30e0\u3067\u6c7a\u5b9a\u3055\u308c\u307e\u3059\u3002\\n\\n");
    private static final Pattern promptRegex_2 = Pattern.compile("\u7279\u6b8a\u306a\u80fd\u529b\u3092\u6301\u3064\u4eba\u306f\u3001");
    private static final Pattern promptRegex_3 = Pattern.compile(" \u307e\u3067\u306b\u884c\u52d5\u3092\u78ba\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
    private static final Pattern onepilogueRegex_1 = Pattern.compile("\u5074\u306e\u52dd\u5229\u3067\u3059\uff01\\n\u5168\u3066\u306e\u30ed\u30b0\u3068\u30e6\u30fc\u30b6\u30fc\u540d\u3092\u516c\u958b\u3057\u307e\u3059\u3002");
    private static final Pattern onepilogueRegex_2 = Pattern.compile(" \u307e\u3067\u81ea\u7531\u306b\u66f8\u304d\u8fbc\u3081\u307e\u3059\u306e\u3067\u3001\u4eca\u56de\u306e\u611f\u60f3\u306a\u3069\u3092\u3069\u3046\u305e\u3002");
    private static final Pattern waRegex = Pattern.compile(" \u306f\u3001");
    private static final Pattern actionRegex = Pattern.compile("( \u3092\u5360\u3063\u305f\u3002)|( \u3092\u5b88\u3063\u3066\u3044\u308b\u3002)");

    public static EventClass decodeEventClass(CharSequence charSequence) {
        EventClass eventClass;
        if ("announce".contentEquals(charSequence)) {
            eventClass = EventClass.ANNOUNCE;
        } else if ("order".contentEquals(charSequence)) {
            eventClass = EventClass.ORDER;
        } else if ("extra".contentEquals(charSequence)) {
            eventClass = EventClass.EXTRA;
        } else {
            assert (false);
            return null;
        }
        return eventClass;
    }

    public static CharSequence encodeEventClass(EventClass eventClass) {
        String string;
        switch (eventClass) {
            case ANNOUNCE: {
                string = "announce";
                break;
            }
            case ORDER: {
                string = "order";
                break;
            }
            case EXTRA: {
                string = "extra";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return string;
    }

    private static Matcher slideRegion(Matcher matcher) {
        int n = matcher.end();
        int n2 = matcher.regionEnd();
        matcher.region(n, n2);
        return matcher;
    }

    private static boolean lookStep(Pattern pattern, Matcher matcher) {
        matcher.usePattern(pattern);
        if (!matcher.lookingAt()) {
            return false;
        }
        SysEvent.slideRegion(matcher);
        return true;
    }

    private static int lookStepHHMM(Matcher matcher) {
        boolean bl;
        matcher.usePattern(hhmmRegex);
        if (!matcher.lookingAt()) {
            return -1;
        }
        if (matcher.start(1) >= 0) {
            bl = false;
        } else if (matcher.start(2) >= 0) {
            bl = true;
        } else {
            assert (false);
            return -1;
        }
        int n = StringUtils.parseInt(matcher.group(3));
        int n2 = StringUtils.parseInt(matcher.group(4));
        if (bl) {
            n += 12;
        }
        int n3 = (n %= 24) * 60 + n2;
        SysEvent.slideRegion(matcher);
        return n3;
    }

    private static Integer lookStepInt(Pattern pattern, Matcher matcher) {
        matcher.usePattern(pattern);
        if (!matcher.lookingAt()) {
            return null;
        }
        if (matcher.start(1) < 0) {
            return null;
        }
        int n = StringUtils.parseInt(matcher.group(1));
        SysEvent.slideRegion(matcher);
        return n;
    }

    private static List<String> lookStepString(Pattern pattern, Matcher matcher) {
        matcher.usePattern(pattern);
        if (!matcher.lookingAt()) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            if (matcher.start(i) < 0) continue;
            String string = matcher.group(i);
            linkedList.add(string);
        }
        SysEvent.slideRegion(matcher);
        return linkedList;
    }

    private static int lookStepExcGroup(Pattern pattern, Matcher matcher) {
        matcher.usePattern(pattern);
        if (!matcher.lookingAt()) {
            return -1;
        }
        int n = matcher.groupCount();
        for (int i = 1; i <= n; ++i) {
            if (matcher.start(i) < 0) continue;
            SysEvent.slideRegion(matcher);
            return i;
        }
        SysEvent.slideRegion(matcher);
        return -1;
    }

    private static Avatar lookStepAvatar(Matcher matcher) {
        Avatar avatar = Avatar.lookingAtAvatar(matcher);
        if (avatar == null) {
            return null;
        }
        SysEvent.slideRegion(matcher);
        return avatar;
    }

    private static GameRole lookStepRole(Matcher matcher) {
        GameRole gameRole = GameRole.lookingAtRole(matcher);
        if (gameRole == null) {
            return null;
        }
        SysEvent.slideRegion(matcher);
        return gameRole;
    }

    private static boolean hasCleanTail(Matcher matcher) {
        matcher.usePattern(newlineRegex);
        if (!matcher.matches()) {
            return false;
        }
        SysEvent.slideRegion(matcher);
        return true;
    }

    private static Matcher getDefaultMatcher(CharSequence charSequence, int n, int n2) {
        Matcher matcher = defaultRegex.matcher(charSequence);
        matcher.region(n, n2);
        return matcher;
    }

    private String replaceRef(String string) {
        string = string.replace("&gt;", ">").replace("&lt;", "<").replace("&quot;", "\"").replace("&amp;", "&");
        return string;
    }

    public SysEvent(EventClass eventClass, CharSequence charSequence) throws NullPointerException {
        boolean bl;
        if (eventClass == null || charSequence == null) {
            throw new NullPointerException();
        }
        this.eventClass = eventClass;
        this.message = ((Object)charSequence).toString().replace("<br />", "\n");
        int n = 0;
        int n2 = this.message.length();
        switch (this.eventClass) {
            case ANNOUNCE: {
                bl = this.parseAnnounce(this.message, n, n2);
                break;
            }
            case ORDER: {
                bl = this.parseOrder(this.message, n, n2);
                break;
            }
            case EXTRA: {
                bl = this.parseExtra(this.message, n, n2);
                break;
            }
            default: {
                assert (false);
                bl = false;
            }
        }
        if (!bl) {
            this.type = Type.UNKNOWN;
            this.clearList();
            Jindolf.logger.severe("\u89e3\u6790\u4e0d\u80fd\u306a\u30b7\u30b9\u30c6\u30e0\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u51fa\u73fe\u3057\u307e\u3057\u305f");
            return;
        }
        if (this.type == Type.PLLIST) {
            this.message = ((Object)this.message).toString().replaceAll("<a [^>]*>", "").replace("</a>", "");
        }
    }

    private void clearList() {
        this.avatarList.clear();
        this.roleList.clear();
        this.integerList.clear();
        this.charseqList.clear();
    }

    private boolean parseAnnounce(CharSequence charSequence, int n, int n2) {
        if (this.parseSimpleAnnounce(charSequence, n, n2)) {
            return true;
        }
        Matcher matcher = SysEvent.getDefaultMatcher(charSequence, n, n2);
        matcher.region(n, n2);
        if (this.parseOnStage(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        if (this.parseOpenRole(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        if (this.parseSurvivor(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        if (this.parseCounting(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        if (this.parseSuddenDeath(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        if (this.parseMurder(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        return this.parsePlList(matcher);
    }

    private boolean parseSimpleAnnounce(CharSequence charSequence, int n, int n2) {
        this.clearList();
        Matcher matcher = SysEvent.getDefaultMatcher(charSequence, n, n2);
        Type type = null;
        for (Object[] objectArray : simpleRegexToType) {
            Pattern pattern = (Pattern)objectArray[0];
            Type type2 = (Type)((Object)objectArray[1]);
            matcher.region(n, n2);
            if (!SysEvent.lookStep(pattern, matcher) || !SysEvent.hasCleanTail(matcher)) continue;
            type = type2;
            break;
        }
        if (type == null) {
            return false;
        }
        this.type = type;
        return true;
    }

    private boolean parseOnStage(Matcher matcher) {
        this.clearList();
        Integer n = SysEvent.lookStepInt(onstageRegex_1, matcher);
        if (n == null) {
            return false;
        }
        Avatar avatar = SysEvent.lookStepAvatar(matcher);
        if (avatar == null) {
            return false;
        }
        if (!SysEvent.lookStep(onstageRegex_2, matcher)) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.ONSTAGE;
        this.integerList.add(n);
        this.avatarList.add(avatar);
        return true;
    }

    private boolean parseOpenRole(Matcher matcher) {
        GameRole gameRole;
        this.clearList();
        if (!SysEvent.lookStep(openroleRegex_1, matcher)) {
            return false;
        }
        while ((gameRole = SysEvent.lookStepRole(matcher)) != null) {
            Integer n = SysEvent.lookStepInt(openroleRegex_2, matcher);
            if (n == null) {
                return false;
            }
            this.roleList.add(gameRole);
            this.integerList.add(n);
        }
        if (!SysEvent.lookStep(openroleRegex_3, matcher)) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.OPENROLE;
        return true;
    }

    private boolean parseSurvivor(Matcher matcher) {
        Comparable<Avatar> comparable;
        this.clearList();
        if (!SysEvent.lookStep(survivorRegex_1, matcher)) {
            return false;
        }
        while (SysEvent.lookStep(survivorRegex_2, matcher)) {
            comparable = SysEvent.lookStepAvatar(matcher);
            if (comparable == null) {
                return false;
            }
            this.avatarList.add((Avatar)comparable);
        }
        comparable = SysEvent.lookStepInt(survivorRegex_3, matcher);
        if (comparable == null) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.SURVIVOR;
        this.integerList.add((Integer)comparable);
        return true;
    }

    private boolean parseCounting(Matcher matcher) {
        Avatar avatar;
        this.clearList();
        Avatar avatar2 = null;
        while ((avatar = SysEvent.lookStepAvatar(matcher)) != null) {
            if (!SysEvent.lookStep(countingRegex_1, matcher)) {
                if (!SysEvent.lookStep(countingRegex_3, matcher)) {
                    return false;
                }
                avatar2 = avatar;
                break;
            }
            Avatar avatar3 = SysEvent.lookStepAvatar(matcher);
            if (avatar3 == null) {
                return false;
            }
            if (!SysEvent.lookStep(countingRegex_2, matcher)) {
                return false;
            }
            this.avatarList.add(avatar);
            this.avatarList.add(avatar3);
        }
        if (avatar2 != null) {
            this.avatarList.add(avatar2);
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.COUNTING;
        return true;
    }

    private boolean parseSuddenDeath(Matcher matcher) {
        this.clearList();
        Avatar avatar = SysEvent.lookStepAvatar(matcher);
        if (avatar == null) {
            return false;
        }
        if (!SysEvent.lookStep(suddendeathRegex_1, matcher)) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.SUDDENDEATH;
        this.avatarList.add(avatar);
        return true;
    }

    private boolean parseMurder(Matcher matcher) {
        this.clearList();
        if (!SysEvent.lookStep(murderRegex_1, matcher)) {
            return false;
        }
        Avatar avatar = SysEvent.lookStepAvatar(matcher);
        if (avatar == null) {
            return false;
        }
        Avatar avatar2 = null;
        if (SysEvent.lookStep(murderRegex_2, matcher) && (avatar2 = SysEvent.lookStepAvatar(matcher)) == null) {
            return false;
        }
        if (!SysEvent.lookStep(murderRegex_3, matcher)) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.MURDER;
        this.avatarList.add(avatar);
        if (avatar2 != null) {
            this.avatarList.add(avatar2);
        }
        return true;
    }

    private boolean parsePlList(Matcher matcher) {
        Avatar avatar;
        this.clearList();
        while ((avatar = SysEvent.lookStepAvatar(matcher)) != null) {
            int n;
            String string;
            String string2;
            List<String> list = SysEvent.lookStepString(pllistRegex_1, matcher);
            if (list != null && list.size() == 1) {
                string2 = "";
                string = list.get(0);
            } else {
                list = SysEvent.lookStepString(pllistRegex_2, matcher);
                if (list == null || list.size() != 2) {
                    return false;
                }
                string2 = list.get(0);
                string = list.get(1);
            }
            string2 = this.replaceRef(string2);
            string = this.replaceRef(string);
            int n2 = SysEvent.lookStepExcGroup(pllistRegex_3, matcher);
            if (n2 == 1) {
                n = 1;
            } else if (n2 == 2) {
                n = 0;
            } else {
                return false;
            }
            GameRole gameRole = SysEvent.lookStepRole(matcher);
            if (gameRole == null) {
                return false;
            }
            if (!SysEvent.lookStep(pllistRegex_4, matcher)) {
                return false;
            }
            this.avatarList.add(avatar);
            this.charseqList.add(string2);
            this.charseqList.add(string);
            this.integerList.add(n);
            this.roleList.add(gameRole);
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.PLLIST;
        return true;
    }

    private boolean parseOrder(CharSequence charSequence, int n, int n2) {
        Matcher matcher = SysEvent.getDefaultMatcher(charSequence, n, n2);
        matcher.region(n, n2);
        if (this.parseOnEpilogue(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        if (this.parsePrompt(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        if (this.parseWordless(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        if (this.parseRecruit(matcher)) {
            return true;
        }
        matcher.region(n, n2);
        return this.parseGameover(matcher);
    }

    private boolean parseGameover(Matcher matcher) {
        this.clearList();
        if (!SysEvent.lookStep(gameoverRegex, matcher)) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.GAMEOVER;
        return true;
    }

    private boolean parseRecruit(Matcher matcher) {
        this.clearList();
        if (!SysEvent.lookStep(recruitRegex_1, matcher)) {
            return false;
        }
        int n = SysEvent.lookStepHHMM(matcher);
        if (n < 0) {
            return false;
        }
        Integer n2 = SysEvent.lookStepInt(recruitRegex_2, matcher);
        if (n2 == null) {
            return false;
        }
        Integer n3 = SysEvent.lookStepInt(recruitRegex_3, matcher);
        if (n3 == null) {
            return false;
        }
        if (!SysEvent.lookStep(recruitRegex_4, matcher)) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.RECRUIT;
        this.integerList.add(n);
        this.integerList.add(n2);
        this.integerList.add(n3);
        return true;
    }

    private boolean parseWordless(Matcher matcher) {
        Comparable<Avatar> comparable;
        this.clearList();
        if (!SysEvent.lookStep(wordlessRegex_1, matcher)) {
            return false;
        }
        while ((comparable = SysEvent.lookStepAvatar(matcher)) != null) {
            this.avatarList.add((Avatar)comparable);
            if (SysEvent.lookStep(wordlessRegex_2, matcher)) continue;
            return false;
        }
        comparable = SysEvent.lookStepInt(wordlessRegex_3, matcher);
        if (comparable == null) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.WORDLESS;
        this.integerList.add((Integer)comparable);
        return true;
    }

    private boolean parsePrompt(Matcher matcher) {
        this.clearList();
        int n = SysEvent.lookStepHHMM(matcher);
        if (n >= 0 && !SysEvent.lookStep(promptRegex_1, matcher)) {
            return false;
        }
        if (!SysEvent.lookStep(promptRegex_2, matcher)) {
            return false;
        }
        int n2 = SysEvent.lookStepHHMM(matcher);
        if (n2 < 0) {
            return false;
        }
        if (!SysEvent.lookStep(promptRegex_3, matcher)) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.PROMPT;
        if (n >= 0) {
            this.integerList.add(n);
        }
        this.integerList.add(n2);
        return true;
    }

    private boolean parseOnEpilogue(Matcher matcher) {
        this.clearList();
        GameRole gameRole = SysEvent.lookStepRole(matcher);
        if (gameRole == null) {
            return false;
        }
        if (gameRole != GameRole.HABITANT && gameRole != GameRole.WOLF && gameRole != GameRole.HAMSTER) {
            return false;
        }
        if (!SysEvent.lookStep(onepilogueRegex_1, matcher)) {
            return false;
        }
        int n = SysEvent.lookStepHHMM(matcher);
        if (n < 0) {
            return false;
        }
        if (!SysEvent.lookStep(onepilogueRegex_2, matcher)) {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.type = Type.ONEPILOGUE;
        this.roleList.add(gameRole);
        this.integerList.add(n);
        return true;
    }

    private boolean parseExtra(CharSequence charSequence, int n, int n2) {
        Matcher matcher = SysEvent.getDefaultMatcher(charSequence, n, n2);
        boolean bl = this.parseExtra(matcher);
        return bl;
    }

    private boolean parseExtra(Matcher matcher) {
        this.clearList();
        Avatar avatar = SysEvent.lookStepAvatar(matcher);
        if (avatar == null) {
            return false;
        }
        if (!SysEvent.lookStep(waRegex, matcher)) {
            return false;
        }
        Avatar avatar2 = SysEvent.lookStepAvatar(matcher);
        if (avatar2 == null) {
            return false;
        }
        int n = SysEvent.lookStepExcGroup(actionRegex, matcher);
        if (n == 1) {
            this.type = Type.SCRY;
        } else if (n == 2) {
            this.type = Type.GUARD;
        } else {
            return false;
        }
        if (!SysEvent.hasCleanTail(matcher)) {
            return false;
        }
        this.avatarList.add(avatar);
        this.avatarList.add(avatar2);
        return true;
    }

    public List<Avatar> getAvatarList() {
        List<Avatar> list = Collections.unmodifiableList(this.avatarList);
        return list;
    }

    public List<GameRole> getRoleList() {
        List<GameRole> list = Collections.unmodifiableList(this.roleList);
        return list;
    }

    public List<Integer> getIntegerList() {
        List<Integer> list = Collections.unmodifiableList(this.integerList);
        return list;
    }

    public List<CharSequence> getCharSequenceList() {
        List<CharSequence> list = Collections.unmodifiableList(this.charseqList);
        return list;
    }

    public CharSequence getMessage() {
        return this.message;
    }

    public EventClass getEventClass() {
        return this.eventClass;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STARTENTRY,
        ONSTAGE,
        STARTMIRROR,
        OPENROLE,
        STARTMURDER,
        SURVIVOR,
        COUNTING,
        SUDDENDEATH,
        MURDER,
        NOMURDER,
        WINVILLAGE,
        WINWOLF,
        WINHAMSTER,
        PLLIST,
        NOTHING,
        RECRUIT,
        PROMPT,
        WORDLESS,
        ONEPILOGUE,
        GAMEOVER,
        SCRY,
        GUARD,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventClass {
        ANNOUNCE,
        ORDER,
        EXTRA;

    }
}

