/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import jp.sourceforge.jindolf.AnchorHitListener;
import jp.sourceforge.jindolf.Discussion;
import jp.sourceforge.jindolf.FontChooser;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.PeriodView;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.VillageInfoPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabBrowser
extends JTabbedPane {
    private Village village;
    private final VillageInfoPanel villageInfo = new VillageInfoPanel();
    private Font discussionFont = FontChooser.defaultFont;
    private FontRenderContext discussionRenderContext = FontChooser.defaultRenderContext;
    private final EventListenerList thisListenerList = new EventListenerList();

    public TabBrowser() {
        this.setTabPlacement(1);
        this.setTabLayoutPolicy(0);
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.villageInfo.setBorder(border);
        this.addTab("\u6751\u60c5\u5831", new JScrollPane(this.villageInfo));
        this.setVillage(null);
    }

    private void updateVillageInfo() {
        Village village = this.getVillage();
        this.villageInfo.updateVillage(village);
    }

    public void selectVillageInfoTab() {
        this.setSelectedIndex(0);
    }

    public Village getVillage() {
        return this.village;
    }

    public void setVillage(Village village) {
        if (village == null) {
            if (this.village != null) {
                this.village.unloadPeriods();
            }
            this.village = null;
            this.selectVillageInfoTab();
            this.modifyTabCount(0);
            this.updateVillageInfo();
            return;
        }
        if (village != this.village) {
            this.selectVillageInfoTab();
        }
        if (this.village != null) {
            this.village.unloadPeriods();
        }
        this.village = village;
        this.updateVillageInfo();
        int n = this.village.getPeriodSize();
        this.modifyTabCount(n);
        for (int i = 0; i < n; ++i) {
            Object object;
            Period period = this.village.getPeriod(i);
            int n2 = this.periodDaysToTabIndex(i);
            PeriodView periodView = this.getPeriodView(n2);
            if (periodView == null) {
                periodView = new PeriodView(period);
                periodView.setFontInfo(this.discussionFont, this.discussionRenderContext);
                this.setComponentAt(n2, periodView);
                object = periodView.getDiscussion();
                for (ActionListener actionListener : this.getActionListeners()) {
                    ((Discussion)object).addActionListener(actionListener);
                }
                for (EventListener eventListener : this.getAnchorHitListeners()) {
                    ((Discussion)object).addAnchorHitListener((AnchorHitListener)eventListener);
                }
            }
            object = period.getCaption();
            this.setTitleAt(n2, (String)object);
            if (period == periodView.getPeriod()) continue;
            periodView.setPeriod(period);
        }
    }

    private void modifyTabCount(int n) {
        int n2;
        int n3 = n - 1;
        while (this.tabIndexToPeriodDays(n2 = this.getTabCount() - 1) < n3) {
            String string = "";
            JPanel jPanel = new JPanel();
            this.addTab(string, jPanel);
        }
        while (this.tabIndexToPeriodDays(n2 = this.getTabCount() - 1) > n3) {
            this.remove(n2);
        }
    }

    public int periodDaysToTabIndex(int n) {
        int n2 = n + 1;
        if (n2 >= this.getTabCount()) {
            return -1;
        }
        return n2;
    }

    private int tabIndexToPeriodDays(int n) {
        if (n >= this.getTabCount()) {
            return -1;
        }
        int n2 = n - 1;
        return n2;
    }

    public List<PeriodView> getPeriodViewList() {
        LinkedList<PeriodView> linkedList = new LinkedList<PeriodView>();
        int n = this.getTabCount();
        for (int i = 0; i <= n - 1; ++i) {
            Component component = this.getComponent(i);
            if (component == null || !(component instanceof PeriodView)) continue;
            PeriodView periodView = (PeriodView)component;
            linkedList.add(periodView);
        }
        return linkedList;
    }

    public Discussion currentDiscussion() {
        int n = this.getSelectedIndex();
        Discussion discussion = this.getDiscussion(n);
        return discussion;
    }

    public PeriodView currentPeriodView() {
        int n = this.getSelectedIndex();
        PeriodView periodView = this.getPeriodView(n);
        return periodView;
    }

    public PeriodView getPeriodView(int n) {
        if (this.tabIndexToPeriodDays(n) < 0) {
            return null;
        }
        if (n >= this.getTabCount()) {
            return null;
        }
        Component component = this.getComponentAt(n);
        if (component == null) {
            return null;
        }
        if (!(component instanceof PeriodView)) {
            return null;
        }
        PeriodView periodView = (PeriodView)component;
        return periodView;
    }

    private Discussion getDiscussion(int n) {
        PeriodView periodView = this.getPeriodView(n);
        if (periodView == null) {
            return null;
        }
        Discussion discussion = periodView.getDiscussion();
        return discussion;
    }

    public void setFontInfo(Font font, FontRenderContext fontRenderContext) {
        this.discussionFont = font;
        this.discussionRenderContext = fontRenderContext;
        for (int i = 0; i <= this.getTabCount() - 1; ++i) {
            PeriodView periodView = this.getPeriodView(i);
            if (periodView == null) continue;
            periodView.setFontInfo(this.discussionFont, this.discussionRenderContext);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.thisListenerList.add(ActionListener.class, actionListener);
        if (this.village == null) {
            return;
        }
        int n = this.village.getPeriodSize();
        for (int i = 0; i < n; ++i) {
            int n2 = this.periodDaysToTabIndex(i);
            Discussion discussion = this.getDiscussion(n2);
            if (discussion == null) continue;
            discussion.addActionListener(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.thisListenerList.remove(ActionListener.class, actionListener);
        if (this.village == null) {
            return;
        }
        int n = this.village.getPeriodSize();
        for (int i = 0; i < n; ++i) {
            int n2 = this.periodDaysToTabIndex(i);
            Discussion discussion = this.getDiscussion(n2);
            if (discussion == null) continue;
            discussion.removeActionListener(actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.thisListenerList.getListeners(ActionListener.class);
    }

    public void addAnchorHitListener(AnchorHitListener anchorHitListener) {
        this.thisListenerList.add(AnchorHitListener.class, anchorHitListener);
        if (this.village == null) {
            return;
        }
        int n = this.village.getPeriodSize();
        for (int i = 0; i < n; ++i) {
            int n2 = this.periodDaysToTabIndex(i);
            Discussion discussion = this.getDiscussion(n2);
            if (discussion == null) continue;
            discussion.addAnchorHitListener(anchorHitListener);
        }
    }

    public void removeAnchorHitListener(AnchorHitListener anchorHitListener) {
        this.thisListenerList.remove(AnchorHitListener.class, anchorHitListener);
        if (this.village == null) {
            return;
        }
        int n = this.village.getPeriodSize();
        for (int i = 0; i < n; ++i) {
            int n2 = this.periodDaysToTabIndex(i);
            Discussion discussion = this.getDiscussion(n2);
            if (discussion == null) continue;
            discussion.removeAnchorHitListener(anchorHitListener);
        }
    }

    public AnchorHitListener[] getAnchorHitListeners() {
        return (AnchorHitListener[])this.thisListenerList.getListeners(AnchorHitListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener[] eventListenerArray = this.thisListenerList.getListeners(clazz);
        if (eventListenerArray.length <= 0) {
            eventListenerArray = super.getListeners(clazz);
        }
        return eventListenerArray;
    }
}

