/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.NavigationFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import jp.sourceforge.jindolf.BalloonBorder;
import jp.sourceforge.jindolf.TextEditor;
import jp.sourceforge.jindolf.TextPopup;

public class TalkEditor
extends JPanel
implements DocumentListener {
    private static final int MAX_CHARS = 200;
    private static final int MAX_LINES = 5;
    private static final Color COLOR_ACTIVATED = Color.GRAY;
    private final PlainDocument document = new PlainDocument();
    private int sequenceNumber;
    private boolean isActive = false;
    private final JLabel seqCount = new JLabel();
    private final JLabel talkStat = new JLabel();
    private final TextEditor textEditor = new TextEditor();
    private Font textFont;

    public static int choplimit(CharSequence charSequence, int n) {
        char c;
        int n2 = charSequence.length();
        if (n >= n2) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2 && ++n3 < 200 && ((c = charSequence.charAt(i)) != '\n' || ++n4 < 5); ++i) {
        }
        return n3;
    }

    public TalkEditor() {
        this(0);
    }

    private TalkEditor(int n) {
        this.setOpaque(true);
        this.document.addDocumentListener(this);
        this.seqCount.setForeground(Color.WHITE);
        this.talkStat.setForeground(Color.WHITE);
        this.seqCount.setOpaque(false);
        this.talkStat.setOpaque(false);
        this.textEditor.setMargin(new Insets(3, 3, 3, 3));
        this.textEditor.setDocument(this.document);
        TextPopup textPopup = new TextPopup();
        this.textEditor.setComponentPopupMenu(textPopup);
        this.textFont = this.textEditor.getFont();
        this.setSequenceNumber(n);
        this.updateStat();
        this.setActive(false);
        this.design();
    }

    private void design() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 1, 3);
        this.add((Component)this.seqCount, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JComponent jComponent = BalloonBorder.decorateTransparentBorder(this.textEditor);
        this.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.talkStat, gridBagConstraints);
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(border);
    }

    public void setTextFont(Font font) {
        this.textFont = font;
        this.textEditor.setFont(this.textFont);
        this.textEditor.repaint();
        this.revalidate();
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setNavigationFilter(NavigationFilter navigationFilter) {
        this.textEditor.setNavigationFilter(navigationFilter);
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int n) {
        this.sequenceNumber = n;
        String string = "=== #" + this.sequenceNumber + " ===";
        this.seqCount.setText(string);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getText() {
        String string;
        block2: {
            int n = this.document.getLength();
            string = "";
            try {
                string = this.document.getText(0, n);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return string;
    }

    public int getTextLength() {
        return this.document.getLength();
    }

    private int getTextLines() {
        int n = 0;
        Segment segment = new Segment();
        segment.setPartialReturn(true);
        boolean bl = false;
        int n2 = 0;
        for (int i = this.getTextLength(); i > 0; i -= segment.count) {
            char c;
            block8: {
                try {
                    this.document.getText(n2, i, segment);
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
            while ((c = segment.current()) != '\uffff') {
                if (c == '\n') {
                    if (!bl) {
                        ++n;
                    }
                    bl = false;
                } else if (!bl) {
                    bl = true;
                    ++n;
                }
                segment.next();
            }
            n2 += segment.count;
        }
        return n;
    }

    public void appendHead(CharSequence charSequence) {
        block4: {
            if (charSequence == null) {
                return;
            }
            if (charSequence.length() <= 0) {
                return;
            }
            try {
                this.document.insertString(0, ((Object)charSequence).toString(), null);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void appendTail(CharSequence charSequence) {
        block4: {
            if (charSequence == null) {
                return;
            }
            if (charSequence.length() <= 0) {
                return;
            }
            int n = this.getTextLength();
            try {
                this.document.insertString(n, ((Object)charSequence).toString(), null);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void chopHead(int n) {
        block4: {
            if (n <= 0) {
                return;
            }
            int n2 = this.getTextLength();
            if (n > n2) {
                n = n2;
            }
            try {
                this.document.remove(0, n);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void clearText() {
        block2: {
            int n = this.document.getLength();
            try {
                this.document.remove(0, n);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        if (this.isActive) {
            this.setOpaque(true);
            this.setBackground(COLOR_ACTIVATED);
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(dimension);
            this.scrollRectToVisible(rectangle);
            this.textEditor.scrollCaretToVisible();
        } else {
            this.setOpaque(false);
        }
        this.repaint();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean onIMEoperation() {
        boolean bl = this.textEditor.onIMEoperation();
        return bl;
    }

    public int getCaretPosition() {
        int n = this.textEditor.getCaretPosition();
        return n;
    }

    public void setCaretPosition(int n) throws IllegalArgumentException {
        this.textEditor.setCaretPosition(n);
    }

    private void updateStat() {
        if (this.onIMEoperation()) {
            return;
        }
        int n = this.getTextLength();
        int n2 = this.getTextLines();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n).append("\u5b57 ").append(n2).append("\u884c");
        this.talkStat.setText(stringBuilder.toString());
    }

    public String chopRest() {
        String string;
        block3: {
            int n;
            String string2 = this.getText();
            int n2 = this.getTextLength();
            int n3 = n2 - (n = TalkEditor.choplimit(string2, 0));
            if (n3 <= 0) {
                return null;
            }
            string = null;
            try {
                string = this.document.getText(n, n3);
                this.document.remove(n, n3);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return string;
    }

    public boolean requestEditorFocus() {
        boolean bl = this.textEditor.requestFocusInWindow();
        return bl;
    }

    public boolean hasEditorFocus() {
        boolean bl = this.textEditor.hasFocus();
        return bl;
    }

    public void addTextFocusListener(FocusListener focusListener) {
        this.textEditor.addFocusListener(focusListener);
    }

    public void removeTextFocusListener(FocusListener focusListener) {
        this.textEditor.removeFocusListener(focusListener);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateStat();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateStat();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateStat();
    }
}

