/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jp.sourceforge.jindolf.ClipboardAction;
import jp.sourceforge.jindolf.EditArray;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.TalkEditor;
import jp.sourceforge.jindolf.TextEditor;
import jp.sourceforge.jindolf.TextPopup;

public class TalkPreview
extends JFrame
implements ActionListener,
ChangeListener {
    private static final String FRAMETITLE = "\u767a\u8a00\u30a8\u30c7\u30a3\u30bf - " + Jindolf.TITLE;
    private static final Color COLOR_EDITORBACK = Color.BLACK;
    private final JTextComponent freeMemo = new TextEditor();
    private final EditArray editArray = new EditArray();
    private final JButton cutButton = new JButton("\u30ab\u30c3\u30c8");
    private final JButton copyButton = new JButton("\u30b3\u30d4\u30fc");
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JButton cutAllButton = new JButton("\u5168\u30ab\u30c3\u30c8");
    private final JButton copyAllButton = new JButton("\u5168\u30b3\u30d4\u30fc");
    private final JButton clearAllButton = new JButton("\u5168\u30af\u30ea\u30a2");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private final TitledBorder numberBorder = BorderFactory.createTitledBorder("");
    private final JComponent singleGroup = this.buildSingleGroup();
    private final JComponent multiGroup = this.buildMultiGroup();
    private final JLabel letsBrowser = new JLabel("\u6295\u7a3f\u306fWeb\u30d6\u30e9\u30a6\u30b6\u304b\u3089\u3069\u3046\u305e");

    public TalkPreview(Frame frame) {
        super(FRAMETITLE);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(1);
        this.cutButton.addActionListener(this);
        this.copyButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.cutAllButton.addActionListener(this);
        this.copyAllButton.addActionListener(this);
        this.clearAllButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.editArray.addChangeListener(this);
        Container container = this.getContentPane();
        this.design(container);
        this.setBorderNumber(1);
    }

    private void design(Container container) {
        JComponent jComponent = this.buildFreeNotePanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JViewport jViewport = new JViewport();
        jViewport.setBackground(COLOR_EDITORBACK);
        jViewport.setView(this.editArray);
        jScrollPane.setViewport(jViewport);
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        jPanel.add((Component)jScrollPane, "Center");
        JComponent jComponent2 = this.buildButtonPanel();
        jPanel.add((Component)jComponent2, "East");
        AbstractBorder abstractBorder = BorderFactory.createTitledBorder("\u767a\u8a00\u7de8\u96c6");
        jPanel.setBorder(abstractBorder);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(1);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setDividerSize(10);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setLeftComponent(jComponent);
        jSplitPane.setRightComponent(jPanel);
        Border border = BorderFactory.createBevelBorder(1);
        Border border2 = BorderFactory.createEmptyBorder(2, 5, 2, 2);
        abstractBorder = BorderFactory.createCompoundBorder(border, border2);
        this.letsBrowser.setBorder(abstractBorder);
        borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        container.add((Component)jSplitPane, "Center");
        container.add((Component)this.letsBrowser, "South");
    }

    private JComponent buildButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.singleGroup, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        jPanel.add((Component)this.multiGroup, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(3, 3, 10, 3);
        jPanel.add((Component)this.closeButton, gridBagConstraints);
        return jPanel;
    }

    private JComponent buildSingleGroup() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.cutButton, gridBagConstraints);
        jPanel.add((Component)this.copyButton, gridBagConstraints);
        jPanel.add((Component)this.clearButton, gridBagConstraints);
        jPanel.setBorder(this.numberBorder);
        return jPanel;
    }

    private JComponent buildMultiGroup() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.cutAllButton, gridBagConstraints);
        jPanel.add((Component)this.copyAllButton, gridBagConstraints);
        jPanel.add((Component)this.clearAllButton, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u5168\u767a\u8a00\u3092");
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private JComponent buildFreeNotePanel() {
        Insets insets = new Insets(3, 3, 3, 3);
        this.freeMemo.setMargin(insets);
        TextPopup textPopup = new TextPopup();
        this.freeMemo.setComponentPopupMenu(textPopup);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JViewport jViewport = new JViewport();
        jViewport.setView(this.freeMemo);
        jScrollPane.setViewport(jViewport);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u30d5\u30ea\u30fc\u30e1\u30e2");
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private void setBorderNumber(int n) {
        String string = "\u767a\u8a00#" + n + " \u3092";
        this.numberBorder.setTitle(string);
        this.singleGroup.revalidate();
        this.singleGroup.repaint();
    }

    public void setTextFont(Font font) {
        this.freeMemo.setFont(font);
        this.editArray.setTextFont(font);
    }

    public Font getTextFont() {
        return this.editArray.getTextFont();
    }

    private int warnClear() {
        int n = JOptionPane.showConfirmDialog(this, "\u672c\u5f53\u306b\u767a\u8a00\u3092\u30af\u30ea\u30a2\u3057\u3066\u3082\u3088\u3044\u3067\u3059\u304b\uff1f", "\u767a\u8a00\u30af\u30ea\u30a2\u78ba\u8a8d", 2, 3);
        return n;
    }

    private void actionCutActive() {
        this.actionCopyActive();
        this.actionClearActive(false);
    }

    private void actionCopyActive() {
        TalkEditor talkEditor = this.editArray.getActiveEditor();
        if (talkEditor == null) {
            return;
        }
        String string = talkEditor.getText();
        ClipboardAction.copyToClipboard(string);
    }

    private void actionClearActive(boolean bl) {
        if (bl && this.warnClear() != 0) {
            return;
        }
        TalkEditor talkEditor = this.editArray.getActiveEditor();
        if (talkEditor == null) {
            return;
        }
        talkEditor.clearText();
    }

    private void actionCutAll() {
        this.actionCopyAll();
        this.actionClearAll(false);
    }

    private void actionCopyAll() {
        CharSequence charSequence = this.editArray.getAllText();
        ClipboardAction.copyToClipboard(charSequence);
    }

    private void actionClearAll(boolean bl) {
        if (bl && this.warnClear() != 0) {
            return;
        }
        this.editArray.clearAllEditor();
    }

    private void actionClose() {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cutButton) {
            this.actionCutActive();
        } else if (object == this.copyButton) {
            this.actionCopyActive();
        } else if (object == this.clearButton) {
            this.actionClearActive(true);
        } else if (object == this.cutAllButton) {
            this.actionCutAll();
        } else if (object == this.copyAllButton) {
            this.actionCopyAll();
        } else if (object == this.clearAllButton) {
            this.actionClearAll(true);
        } else if (object == this.closeButton) {
            this.actionClose();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        TalkEditor talkEditor = this.editArray.getActiveEditor();
        int n = talkEditor.getSequenceNumber();
        this.setBorderNumber(n);
    }
}

