/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.HtmlSequence;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Village
implements Comparable<Village> {
    private static final Comparator<Village> vComparator = new VillageComparator();
    private static final Pattern anchorRegex;
    private static final Pattern titleRegex;
    private static final Pattern villageInfoRegex;
    private final Land parentLand;
    private final String villageID;
    private final int villageIDNum;
    private final String villageName;
    private final boolean isValid;
    private int limitMonth;
    private int limitDay;
    private int limitHour;
    private int limitMinute;
    private State state = State.UNKNOWN;
    private final LinkedList<Period> periodList = new LinkedList();
    private final List<Period> unmodList = Collections.unmodifiableList(this.periodList);
    private Image tombImage = null;
    private final Map<String, Avatar> avatarMap = new HashMap<String, Avatar>();
    private final Map<Avatar, Image> faceImageMap = new HashMap<Avatar, Image>();

    public static Comparator<Village> comparator() {
        return vComparator;
    }

    public Village(Land land, String string, String string2) {
        this.parentLand = land;
        this.villageID = string.intern();
        this.villageIDNum = Integer.parseInt(this.villageID);
        this.villageName = string2.intern();
        this.isValid = this.parentLand.isValidVillageId(this.villageIDNum);
    }

    public Land getParentLand() {
        return this.parentLand;
    }

    public String getVillageID() {
        return this.villageID;
    }

    public int getVillageIDNum() {
        return this.villageIDNum;
    }

    public String getVillageName() {
        return this.parentLand.getLandPrefix() + this.getVillageID();
    }

    public String getVillageFullName() {
        return this.villageName;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Period getPrologue() {
        for (Period period : this.periodList) {
            if (!period.isPrologue()) continue;
            return period;
        }
        return null;
    }

    public Period getEpilogue() {
        for (Period period : this.periodList) {
            if (!period.isEpilogue()) continue;
            return period;
        }
        return null;
    }

    public Period getProgress(int n) {
        for (Period period : this.periodList) {
            if (!period.isProgress() || period.getDay() != n) continue;
            return period;
        }
        return null;
    }

    public int getProgressDays() {
        int n = 0;
        for (Period period : this.periodList) {
            if (!period.isProgress()) continue;
            ++n;
        }
        return n;
    }

    public Period getPeriod(int n) {
        return this.periodList.get(n);
    }

    public Period getPeriod(Anchor anchor) {
        if (anchor.isEpilogueDay()) {
            Period period = this.getEpilogue();
            return period;
        }
        int n = anchor.getDay();
        Period period = this.getPeriod(n);
        return period;
    }

    public int getPeriodSize() {
        return this.periodList.size();
    }

    public List<Period> getPeriodList() {
        return this.unmodList;
    }

    public Avatar getAvatar(String string) {
        Avatar avatar = Avatar.getPredefinedAvatar(string);
        if (avatar != null) {
            return avatar;
        }
        avatar = this.avatarMap.get(string);
        if (avatar != null) {
            return avatar;
        }
        return null;
    }

    public void addAvatar(Avatar avatar) {
        if (avatar == null) {
            return;
        }
        String string = avatar.getFullName();
        this.avatarMap.put(string, avatar);
    }

    public void putAvatarFaceImage(Avatar avatar, Image image) {
        this.faceImageMap.put(avatar, image);
    }

    public Image getAvatarFaceImage(Avatar avatar) {
        return this.faceImageMap.get(avatar);
    }

    public Image getGraveImage() {
        return this.tombImage;
    }

    public void setGraveImage(Image image) throws NullPointerException {
        if (image == null) {
            throw new NullPointerException();
        }
        this.tombImage = image;
    }

    public CharSequence getCGIQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("?vid=").append(this.getVillageID());
        return stringBuilder;
    }

    public int getLimitMonth() {
        return this.limitMonth;
    }

    public int getLimitDay() {
        return this.limitDay;
    }

    public int getLimitHour() {
        return this.limitHour;
    }

    public int getLimitMinute() {
        return this.limitMinute;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void updatePeriodList() throws IOException {
        Land land = this.getParentLand();
        ServerAccess serverAccess = land.getServerAccess();
        HtmlSequence htmlSequence = land.getType() == Land.Type.ACTIVE ? serverAccess.getHTMLBoneHead(this) : serverAccess.getHTMLVillage(this);
        this.parseTitle(htmlSequence);
        this.updatePeriodList(htmlSequence);
    }

    private void updatePeriodList(CharSequence charSequence) {
        Object object;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        Matcher matcher = anchorRegex.matcher(charSequence);
        while (matcher.find()) {
            object2 = matcher.group(2);
            object = matcher.group(3);
            if (((String)object2).equals("\u30d7\u30ed\u30ed\u30fc\u30b0")) {
                bl = true;
                continue;
            }
            if (((String)object2).endsWith("\u65e5\u76ee")) {
                int n2;
                bl3 = true;
                n = n2 = Integer.parseInt((String)object);
                continue;
            }
            if (((String)object2).equals("\u30a8\u30d4\u30ed\u30fc\u30b0")) {
                bl2 = true;
                continue;
            }
            if (!((String)object2).equals("\u7d42\u4e86")) continue;
            bl4 = true;
            break;
        }
        if (this.getParentLand().getType() != Land.Type.ACTIVE) {
            this.setState(State.GAMEOVER);
        } else if (bl4) {
            this.setState(State.GAMEOVER);
        } else if (bl2) {
            this.setState(State.EPILOGUE);
        } else if (bl3) {
            this.setState(State.PROGRESS);
        } else if (bl) {
            this.setState(State.PROLOGUE);
        } else {
            this.setState(State.UNKNOWN);
            this.periodList.clear();
            assert (false);
            return;
        }
        object2 = null;
        if (bl) {
            object = this.getPrologue();
            if (object == null) {
                object2 = new Period(this, Period.Type.PROLOGUE, 0);
                this.setPeriod(0, (Period)object2);
            } else {
                object2 = object;
            }
        }
        if (bl3) {
            for (int i = 1; i <= n; ++i) {
                Period period = this.getProgress(i);
                if (period == null) {
                    object2 = new Period(this, Period.Type.PROGRESS, i);
                    this.setPeriod(i, (Period)object2);
                    continue;
                }
                object2 = period;
            }
        }
        if (bl2) {
            Period period = this.getEpilogue();
            if (period == null) {
                object2 = new Period(this, Period.Type.EPILOGUE, n + 1);
                this.setPeriod(n + 1, (Period)object2);
            } else {
                object2 = period;
            }
        }
        assert (this.getPeriodSize() > 0);
        assert (object2 != null);
        while (this.periodList.getLast() != object2) {
            this.periodList.removeLast();
        }
        if (this.getState() != State.GAMEOVER) {
            ((Period)object2).setHot(true);
        }
    }

    private void setPeriod(int n, Period period) throws IndexOutOfBoundsException {
        int n2 = this.periodList.size();
        if (n == n2) {
            this.periodList.add(period);
        } else if (n < n2) {
            this.periodList.set(n, period);
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    private void parseTitle(CharSequence charSequence) {
        String string;
        Matcher matcher = titleRegex.matcher(charSequence);
        if (matcher.find()) {
            string = matcher.group(1);
        }
        if ((matcher = villageInfoRegex.matcher(charSequence)).find()) {
            string = matcher.group(1);
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            String string4 = matcher.group(4);
            String string5 = matcher.group(5);
            String string6 = matcher.group(6);
            this.limitMonth = Integer.parseInt(string2);
            this.limitDay = Integer.parseInt(string3);
            this.limitHour = Integer.parseInt(string5);
            this.limitMinute = Integer.parseInt(string6);
            if (string4.equals("\u5348\u5f8c")) {
                this.limitHour += 12;
            }
            this.limitHour %= 24;
        }
    }

    public List<Talk> getTalkListFromAnchor(Anchor anchor) throws IOException {
        LinkedList<Talk> linkedList = new LinkedList<Talk>();
        Period period = this.getPeriod(anchor);
        if (period == null) {
            return linkedList;
        }
        period.updatePeriod();
        for (Topic topic : period.getTopicList()) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getHour() != anchor.getHour() || talk.getMinute() != anchor.getMinute()) continue;
            linkedList.add(talk);
        }
        return linkedList;
    }

    public void unloadPeriods() {
        for (Period period : this.periodList) {
            period.unload();
        }
    }

    @Override
    public int compareTo(Village village) {
        int n = vComparator.compare(this, village);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Village)) {
            return false;
        }
        Village village = (Village)object;
        if (this.getParentLand() != village.getParentLand()) {
            return false;
        }
        int n = this.compareTo(village);
        return n == 0;
    }

    public int hashCode() {
        int n = this.getParentLand().hashCode();
        int n2 = this.getVillageID().hashCode();
        int n3 = n ^ n2;
        return n3;
    }

    public String toString() {
        return this.getVillageFullName();
    }

    static {
        String string = " \\t\\n\\r";
        String string2 = "[" + string + "]";
        String string3 = string2 + "*";
        String string4 = string2 + "+";
        String string5 = "\u30d7\u30ed\u30ed\u30fc\u30b0";
        String string6 = "\u30a8\u30d4\u30ed\u30fc\u30b0";
        String string7 = "\u7d42\u4e86";
        String string8 = "([1-9][0-9]*)\u65e5\u76ee";
        String string9 = "<a" + string4 + "href=\"([^\"]*)\"" + string3 + ">" + string3;
        String string10 = string3 + "</a>";
        String string11 = "(" + string5 + "|" + string6 + "|" + string8 + "|" + string7 + ")";
        String string12 = string9 + string11 + string10;
        String string13 = "<title>" + string3 + "([^<]*)" + string3 + "</title>";
        String string14 = ">" + string3 + "([^<]+?)" + string3 + "<strong>" + string3 + "[\\(\uff08]" + string3 + "([1-9][0-9]?)/([1-9][0-9]?)" + string3 + "(\u5348\u524d|\u5348\u5f8c)" + string3 + "([0-9][0-9]?)\u6642" + string3 + "([0-9][0-9]?)\u5206" + string3 + "\u306b\u66f4\u65b0" + string3 + "[\\)\uff09]" + string3 + "</strong>";
        anchorRegex = Pattern.compile(string12, 32);
        titleRegex = Pattern.compile(string13, 32);
        villageInfoRegex = Pattern.compile(string14, 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PROLOGUE,
        PROGRESS,
        EPILOGUE,
        GAMEOVER,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VillageComparator
    implements Comparator<Village> {
        private VillageComparator() {
        }

        @Override
        public int compare(Village village, Village village2) {
            if (village == null && village2 == null) {
                return 0;
            }
            if (village == null && village2 != null) {
                return -1;
            }
            if (village != null && village2 == null) {
                return 1;
            }
            int n = village.getVillageIDNum();
            int n2 = village2.getVillageIDNum();
            return n - n2;
        }
    }
}

