/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import jp.sourceforge.jindolf.ClipboardAction;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.TextPopup;
import jp.sourceforge.jindolf.UriExporter;
import jp.sourceforge.jindolf.WebIPC;

public class WebIPCDialog
extends JDialog
implements ActionListener {
    private static final String FRAMETITLE = "URL\u3078\u306e\u30a2\u30af\u30bb\u30b9\u78ba\u8a8d - " + Jindolf.TITLE;
    private final JLabel info = new JLabel("\u4ee5\u4e0b\u306eURL\u3078\u306e\u30a2\u30af\u30bb\u30b9\u304c\u6307\u793a\u3055\u308c\u307e\u3057\u305f\u3002");
    private final JTextArea urltext = new JTextArea("");
    private final JButton browse = new JButton("\u30c7\u30d5\u30a9\u30eb\u30c8\u306eWeb\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a");
    private final JButton clipcopy = new JButton("URL\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc");
    private final JLabel dndLabel = new JLabel("\u2026\u307e\u305f\u306f\u30d6\u30e9\u30a6\u30b6\u306bDrag&Drop \u2192");
    private final JButton cancel = new JButton("\u9589\u3058\u308b");
    private final WebIPC ipc;
    private URI uri;

    public static void showDialog(Frame frame, String string) {
        WebIPCDialog webIPCDialog = new WebIPCDialog(frame);
        webIPCDialog.setURLtext(string);
        webIPCDialog.pack();
        webIPCDialog.setLocationRelativeTo(frame);
        webIPCDialog.setVisible(true);
    }

    private static boolean isValidURI(URI uRI) {
        if (uRI == null) {
            return false;
        }
        if (!uRI.isAbsolute()) {
            return false;
        }
        String string = uRI.getScheme();
        if (string == null) {
            return false;
        }
        if (!string.equalsIgnoreCase("http") && !string.equalsIgnoreCase("https")) {
            return false;
        }
        String string2 = uRI.getHost();
        return string2 != null;
    }

    public WebIPCDialog(Frame frame) {
        super(frame, FRAMETITLE, true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        WebIPC webIPC = null;
        if (WebIPC.isDesktopSupported() && !(webIPC = WebIPC.getWebIPC()).isSupported(WebIPC.Action.BROWSE)) {
            webIPC = null;
        }
        this.ipc = webIPC;
        Border border = BorderFactory.createEmptyBorder(1, 4, 1, 4);
        Border border2 = BorderFactory.createEtchedBorder(0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.urltext.setBorder(compoundBorder);
        this.urltext.setEditable(false);
        this.urltext.setLineWrap(true);
        this.urltext.setComponentPopupMenu(new TextPopup());
        GUIUtils.forceMonoPitchFont(this.urltext);
        this.dndLabel.setIcon(GUIUtils.getWWWIcon());
        this.dndLabel.setHorizontalTextPosition(2);
        this.dndLabel.setTransferHandler(new DnDHandler());
        this.dndLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, mouseEvent, 1);
            }
        });
        Container container = this.getContentPane();
        this.design(container);
        this.browse.addActionListener(this);
        this.clipcopy.addActionListener(this);
        this.cancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.browse);
        this.browse.requestFocusInWindow();
        if (this.ipc == null) {
            this.browse.setEnabled(false);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WebIPCDialog.this.actionCancel();
            }
        });
    }

    private void design(Container container) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        JComponent jComponent = this.buildButtonPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        container.add((Component)this.info, gridBagConstraints);
        container.add((Component)this.urltext, gridBagConstraints);
        container.add((Component)jComponent, gridBagConstraints);
        container.add((Component)this.cancel, gridBagConstraints);
    }

    private JComponent buildButtonPanel() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u30a2\u30af\u30bb\u30b9\u3059\u308b\u65b9\u6cd5\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        jPanel.setBorder(titledBorder);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.browse, gridBagConstraints);
        jPanel.add((Component)this.clipcopy, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 3, 10, 3);
        jPanel.add((Component)this.dndLabel, gridBagConstraints);
        return jPanel;
    }

    public void setURLtext(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.uri = uRI;
        if (this.uri == null) {
            return;
        }
        if (!WebIPCDialog.isValidURI(this.uri)) {
            return;
        }
        String string2 = this.uri.toASCIIString();
        this.urltext.setText(string2);
        this.urltext.revalidate();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browse) {
            this.actionBrowse();
        } else if (object == this.clipcopy) {
            this.actionClipboardCopy();
        } else if (object == this.cancel) {
            this.actionCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionBrowse() {
        if (this.uri == null) {
            this.close();
            return;
        }
        try {
            try {
                this.ipc.browse(this.uri);
            }
            catch (NullPointerException nullPointerException) {
                assert (false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String string = "URL " + this.uri.toASCIIString() + " \u3078\u306e\u30a2\u30af\u30bb\u30b9\u3092Web\u30d6\u30e9\u30a6\u30b6\u306b\u6307\u793a\u3057\u307e\u3057\u305f";
            Jindolf.logger.info(string);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionClipboardCopy() {
        if (this.uri == null) {
            this.close();
            return;
        }
        String string = this.uri.toASCIIString();
        try {
            ClipboardAction.copyToClipboard(string);
            String string2 = "\u6587\u5b57\u5217\u300c" + string + "\u300d\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f";
            Jindolf.logger.info(string2);
        }
        finally {
            this.close();
        }
    }

    private void actionCancel() {
        this.close();
    }

    private void close() {
        this.setVisible(false);
    }

    private class DnDHandler
    extends TransferHandler {
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            UriExporter uriExporter = new UriExporter(WebIPCDialog.this.uri);
            return uriExporter;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 0) {
                return;
            }
            String string = "URL " + WebIPCDialog.this.uri.toASCIIString() + " \u304c\u3069\u3053\u304b\u3078\u30c9\u30e9\u30c3\u30b0&\u30c9\u30ed\u30c3\u30d7\u3055\u308c\u307e\u3057\u305f";
            Jindolf.logger.info(string);
            WebIPCDialog.this.close();
        }

        public Icon getVisualRepresentation(Transferable transferable) {
            return GUIUtils.getWWWIcon();
        }
    }
}

