/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Destiny;
import jp.sourceforge.jindolf.FaceIconSet;
import jp.sourceforge.jindolf.GameRole;
import jp.sourceforge.jindolf.Jindolf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WolfBBS {
    private static final String wikiChar = "#&[]()<>+-*:|~/,'%?";
    private static final Pattern wikinameRegex = Pattern.compile("[A-Z][a-z]+([A-Z])[a-z]+");
    private static final String FACEICONSET = "resources/faceIconSet.properties";
    private static final String ORDER_PREFIX = "iconset.order.";
    private static final List<FaceIconSet> faceIconSetList = new LinkedList<FaceIconSet>();
    public static final String COMMENTLINE;
    private static final Charset eucCharset;
    private static final String WOLFBBS_URL = "http://wolfbbs.jp/";

    private static void loadFaceIconSet() {
        InputStream inputStream = Jindolf.getResourceAsStream(FACEICONSET);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            Jindolf.logger.log(Level.SEVERE, "\u9854\u30a2\u30a4\u30b3\u30f3\u30bb\u30c3\u30c8\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", iOException);
            Jindolf.exit(1);
        }
        WolfBBS.loadFaceIconSet(properties);
    }

    private static void loadFaceIconSet(Properties properties) {
        Object object;
        String string;
        String string2 = properties.getProperty("codeCheck");
        if (string2 == null || string2.length() != 1 || string2.charAt(0) != '\u72fc') {
            Jindolf.logger.severe("\u9854\u30a2\u30a4\u30b3\u30f3\u30bb\u30c3\u30c8\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u304a\u304b\u3057\u3044\u3088\u3046\u3067\u3059\u3002native2ascii \u306f\u6b63\u3057\u304f\u9069\u7528\u3057\u307e\u3057\u305f\u304b\uff1f");
            Jindolf.exit(1);
            return;
        }
        Set<Object> set = properties.keySet();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (Object object2 : set) {
            if (object2 == null || !(string = object2.toString()).startsWith(ORDER_PREFIX)) continue;
            string = string.replace(ORDER_PREFIX, "");
            try {
                object = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            treeSet.add(object);
        }
        for (Object object2 : treeSet) {
            string = properties.getProperty(ORDER_PREFIX + object2);
            object = WolfBBS.loadFaceIconSet(properties, string);
            faceIconSetList.add((FaceIconSet)object);
        }
    }

    private static FaceIconSet loadFaceIconSet(Properties properties, String string) {
        String string2 = properties.getProperty(string + ".author");
        String string3 = properties.getProperty(string + ".caption");
        String string4 = properties.getProperty(string + ".url");
        FaceIconSet faceIconSet = new FaceIconSet(string3, string2, string4);
        SortedSet<Avatar> sortedSet = Avatar.getPredefinedAvatarSet();
        for (Avatar avatar : sortedSet) {
            String string5 = avatar.getIdentifier();
            String string6 = string + ".iconWiki." + string5;
            String string7 = properties.getProperty(string6);
            faceIconSet.registIconWiki(avatar, string7);
        }
        return faceIconSet;
    }

    public static List<FaceIconSet> getFaceIconSetList() {
        List<FaceIconSet> list = Collections.unmodifiableList(faceIconSetList);
        return list;
    }

    public static boolean isWikiChar(char c) {
        return wikiChar.indexOf(c) >= 0;
    }

    public static CharSequence escapeWikiChar(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (WolfBBS.isWikiChar(c)) {
                try {
                    WolfBBS.appendNumCharRef(stringBuilder, c);
                    continue;
                }
                catch (IOException iOException) {
                    assert (false);
                    return null;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public static CharSequence escapeWikiName(CharSequence charSequence) {
        StringBuilder stringBuilder = null;
        Matcher matcher = wikinameRegex.matcher(charSequence);
        int n = 0;
        while (matcher.find(n)) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            int n4 = matcher.start(1);
            int n5 = matcher.end(1);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(charSequence, n, n2);
            stringBuilder.append(charSequence, n2, n4);
            try {
                WolfBBS.appendNumCharRef(stringBuilder, charSequence.charAt(n4));
            }
            catch (IOException iOException) {
                assert (false);
                return null;
            }
            stringBuilder.append(charSequence, n5, n3);
            n = n3;
        }
        if (n == 0) {
            return charSequence;
        }
        stringBuilder.append(charSequence, n, charSequence.length());
        return stringBuilder;
    }

    public static CharSequence escapeWikiSyntax(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        charSequence2 = WolfBBS.escapeWikiChar(charSequence2);
        charSequence2 = WolfBBS.escapeWikiName(charSequence2);
        return charSequence2;
    }

    public static Appendable appendNumCharRef(Appendable appendable, char c) throws IOException {
        appendable.append("&#x");
        char c2 = c;
        String string = Integer.toHexString(c2);
        appendable.append(string);
        appendable.append(';');
        return appendable;
    }

    public static CharSequence toNumCharRef(char c) {
        StringBuilder stringBuilder = new StringBuilder(8);
        try {
            WolfBBS.appendNumCharRef(stringBuilder, c);
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
        return stringBuilder;
    }

    public static String getTeamWikiColor(GameRole gameRole) {
        String string;
        switch (gameRole) {
            case HABITANT: 
            case SEER: 
            case SHAMAN: 
            case HUNTER: 
            case FRATER: {
                string = "#b7bad3";
                break;
            }
            case WOLF: 
            case MADMAN: {
                string = "#e0b8b8";
                break;
            }
            case HAMSTER: {
                string = "#b9d0be";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return string;
    }

    public static String getRoleIconWiki(GameRole gameRole) {
        String string = gameRole.getRoleName();
        String string2 = "&char(" + string + ");";
        return string2;
    }

    public static String getDestinyColorWiki(Destiny destiny) {
        String string = destiny == Destiny.ALIVE ? "#ffffff" : "#aaaaaa";
        return string;
    }

    private static boolean isSimpleIdToken(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        if ('a' <= c && c <= 'z') {
            return true;
        }
        return c == '-' || c == '_';
    }

    private static StringBuilder encodeId(StringBuilder stringBuilder, char c) {
        ByteBuffer byteBuffer;
        if (WolfBBS.isSimpleIdToken(c)) {
            stringBuilder.append(c);
            return stringBuilder;
        }
        CharBuffer charBuffer = CharBuffer.allocate(1);
        charBuffer.append(c);
        charBuffer.rewind();
        CharsetEncoder charsetEncoder = eucCharset.newEncoder();
        try {
            byteBuffer = charsetEncoder.encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            stringBuilder.append('X');
            return stringBuilder;
        }
        int n = byteBuffer.limit();
        while (byteBuffer.position() < n) {
            int n2 = byteBuffer.get();
            if (n2 < 0) {
                n2 += 256;
            }
            String string = Integer.toHexString(n2).toUpperCase();
            stringBuilder.append('%');
            if (string.length() < 2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    private static StringBuilder encodeId(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            WolfBBS.encodeId(stringBuilder, c);
        }
        return stringBuilder;
    }

    public static String encodeURLFromId(CharSequence charSequence) {
        StringBuilder stringBuilder = WolfBBS.encodeId(charSequence);
        String string = WOLFBBS_URL + stringBuilder + ".html";
        return string;
    }

    private WolfBBS() {
        assert (false);
        throw new Error();
    }

    static {
        eucCharset = Charset.forName("EUC-JP");
        WolfBBS.loadFaceIconSet();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("// ");
        while (stringBuilder.length() < 72) {
            stringBuilder.append('=');
        }
        stringBuilder.append('\n');
        COMMENTLINE = stringBuilder.toString();
    }
}

