/*
 * Topic filter
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: TopicFilter.java 245 2008-10-10 10:21:00Z olyutorskii $
 */

package jp.sourceforge.jindolf;

/**
 * 発言Topicのフィルタリングを行うインタフェース。
 */
public interface TopicFilter {

    /**
     * フィルタの状態を表すインタフェース
     */
    public interface FilterContext{}

    /**
     * 与えられたTopicをフィルタリングする。
     * @param topic Topic
     * @return フィルタリングするならtrue
     */
    public boolean isFiltered(Topic topic);

    /**
     * フィルタの内部状態を表すインスタンスを取得する。
     * @return フィルタの内部状態
     */
    public FilterContext getFilterContext();

    /**
     * 以前得られたフィルタ内部状態と同じフィルタリング条件を
     * 現在も保っているか判別する。
     * @param context フィルタの内部状態
     * @return 同じ状態ならtrue
     */
    public boolean isSame(FilterContext context);
}
