/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.core.PreDefAvatar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Avatar
implements Comparable<Avatar> {
    private static final List<PreDefAvatar> preDefAvatarList = PreDefAvatar.getPreDefAvatarList();
    private static final SortedSet<Avatar> predefinedAvatarSet = Avatar.loadPredefSet();
    private static final List<Avatar> predefinedAvatarList = new ArrayList<Avatar>(predefinedAvatarSet.size());
    private static final Map<String, Avatar> avatarMap = new TreeMap<String, Avatar>();
    private static final Pattern avatarRegex;
    public static final Avatar AVATAR_GERD;
    private final String name;
    private final String jobTitle;
    private final String fullName;
    private final int idNum;
    private final String identifier;

    private static SortedSet<Avatar> loadPredefSet() {
        TreeSet<Avatar> treeSet = new TreeSet();
        for (PreDefAvatar preDefAvatar : preDefAvatarList) {
            String string = preDefAvatar.getShortName();
            String string2 = preDefAvatar.getJobTitle();
            int n = preDefAvatar.getSerialNo();
            String string3 = preDefAvatar.getAvatarId();
            Avatar avatar = new Avatar(string, string2, n, string3);
            treeSet.add(avatar);
        }
        treeSet = Collections.unmodifiableSortedSet(treeSet);
        return treeSet;
    }

    public static SortedSet<Avatar> getPredefinedAvatarSet() {
        return predefinedAvatarSet;
    }

    public static Avatar getPredefinedAvatar(String string) {
        return avatarMap.get(string);
    }

    public static Avatar lookingAtAvatar(Matcher matcher) {
        matcher.usePattern(avatarRegex);
        if (!matcher.lookingAt()) {
            return null;
        }
        int n = matcher.groupCount();
        for (int i = 1; i <= n; ++i) {
            if (matcher.start(i) < 0) continue;
            Avatar avatar = predefinedAvatarList.get(i - 1);
            return avatar;
        }
        return null;
    }

    private Avatar(String string, String string2, int n, String string3) {
        this.name = string.intern();
        this.jobTitle = string2.intern();
        this.idNum = n;
        this.identifier = string3.intern();
        this.fullName = (this.jobTitle + " " + this.name).intern();
    }

    public Avatar(String string) {
        this.fullName = string.intern();
        this.idNum = -1;
        String[] stringArray = this.fullName.split("\\p{Blank}+", 2);
        if (stringArray.length == 1) {
            this.jobTitle = null;
            this.name = this.fullName;
        } else if (stringArray.length == 2) {
            this.jobTitle = stringArray[0].intern();
            this.name = stringArray[1].intern();
        } else {
            this.jobTitle = null;
            this.name = null;
            assert (false);
        }
        this.identifier = "???".intern();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getName() {
        return this.name;
    }

    public int getIdNum() {
        return this.idNum;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Avatar)) {
            return false;
        }
        Avatar avatar = (Avatar)object;
        boolean bl2 = this.fullName.equals(avatar.fullName);
        boolean bl3 = bl = this.idNum == avatar.idNum;
        return bl2 && bl;
    }

    public int hashCode() {
        return this.fullName.hashCode() ^ this.idNum;
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public int compareTo(Avatar avatar) {
        if (avatar == null) {
            return 1;
        }
        return this.idNum - avatar.idNum;
    }

    static {
        String string = "";
        for (Avatar avatar : predefinedAvatarSet) {
            predefinedAvatarList.add(avatar);
            String string2 = avatar.getFullName();
            avatarMap.put(string2, avatar);
            if (string.length() > 0) {
                string = string + "|";
            }
            string = string + "(" + Pattern.quote(string2) + ")";
        }
        avatarRegex = Pattern.compile(string);
        AVATAR_GERD = Avatar.getPredefinedAvatar("\u697d\u5929\u5bb6 \u30b2\u30eb\u30c8");
    }
}

