/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.font.FontRenderContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.AccountPanel;
import jp.sourceforge.jindolf.ActionManager;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.AnchorHitEvent;
import jp.sourceforge.jindolf.AnchorHitListener;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.CsvExporter;
import jp.sourceforge.jindolf.DaySummary;
import jp.sourceforge.jindolf.Discussion;
import jp.sourceforge.jindolf.FilterPanel;
import jp.sourceforge.jindolf.FindPanel;
import jp.sourceforge.jindolf.FontChooser;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.HelpFrame;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.LandsTree;
import jp.sourceforge.jindolf.LogFrame;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.PeriodView;
import jp.sourceforge.jindolf.PileHandler;
import jp.sourceforge.jindolf.RegexPattern;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.StringUtils;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.TalkPreview;
import jp.sourceforge.jindolf.TopView;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.VillageDigest;
import jp.sourceforge.jindolf.WebIPCDialog;
import jp.sourceforge.jindolf.core.VillageState;

public class Controller
implements ActionListener,
TreeWillExpandListener,
TreeSelectionListener,
ChangeListener,
AnchorHitListener {
    private final ActionManager actionManager;
    private final TopView topView;
    private final LandsModel model;
    private final FilterPanel filterFrame;
    private final LogFrame showlogFrame;
    private final FontChooser fontChooser;
    private final FindPanel findPanel;
    private final TalkPreview talkPreview;
    private JFrame helpFrame;
    private AccountPanel accountFrame;
    private DaySummary daySummaryPanel;
    private VillageDigest digestPanel;
    private Map<Window, Boolean> windowMap = new HashMap<Window, Boolean>();
    private volatile boolean isBusyNow;
    private JFrame topFrame = null;

    public Controller(ActionManager actionManager, TopView topView, LandsModel landsModel) {
        this.actionManager = actionManager;
        this.topView = topView;
        this.model = landsModel;
        JToolBar jToolBar = this.actionManager.getBrowseToolBar();
        this.topView.setBrowseToolBar(jToolBar);
        this.actionManager.addActionListener(this);
        JTree jTree = this.topView.getTreeView();
        jTree.setModel(this.model);
        jTree.addTreeWillExpandListener(this);
        jTree.addTreeSelectionListener(this);
        this.topView.getTabBrowser().addChangeListener(this);
        this.topView.getTabBrowser().addActionListener(this);
        this.topView.getTabBrowser().addAnchorHitListener(this);
        JButton jButton = this.topView.getLandsTree().getReloadVillageListButton();
        jButton.addActionListener(this);
        jButton.setEnabled(false);
        this.filterFrame = new FilterPanel(this.topFrame);
        this.filterFrame.addChangeListener(this);
        this.filterFrame.pack();
        this.filterFrame.setVisible(false);
        this.showlogFrame = new LogFrame(this.topFrame);
        this.showlogFrame.pack();
        this.showlogFrame.setSize(600, 250);
        this.showlogFrame.setLocationByPlatform(true);
        this.showlogFrame.setVisible(false);
        if (Jindolf.hasLoggingPermission()) {
            Handler[] handlerArray;
            Handler handler = this.showlogFrame.getHandler();
            Jindolf.logger.addHandler(handler);
            for (Handler handler2 : handlerArray = Jindolf.logger.getHandlers()) {
                if (!(handler2 instanceof PileHandler)) continue;
                PileHandler pileHandler = (PileHandler)handler2;
                pileHandler.delegate(handler);
                pileHandler.close();
            }
        }
        this.talkPreview = new TalkPreview(this.topFrame);
        this.talkPreview.pack();
        this.talkPreview.setSize(700, 500);
        this.talkPreview.setVisible(false);
        this.fontChooser = new FontChooser(this.topFrame);
        this.fontChooser.pack();
        this.fontChooser.setSize(450, 450);
        this.fontChooser.setVisible(false);
        this.initFontChooser();
        this.findPanel = new FindPanel(this.topFrame);
        this.findPanel.pack();
        this.findPanel.setVisible(false);
        this.windowMap.put(this.filterFrame, true);
        this.windowMap.put(this.showlogFrame, false);
        this.windowMap.put(this.talkPreview, false);
        this.windowMap.put(this.fontChooser, false);
        this.windowMap.put(this.findPanel, true);
        this.topView.getTabBrowser().setFontInfo(this.fontChooser.getSelectedFont(), this.fontChooser.getFontRenderContext());
        this.talkPreview.setTextFont(this.fontChooser.getSelectedFont());
    }

    public JFrame createTopFrame() {
        this.topFrame = new JFrame();
        Container container = this.topFrame.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        container.add((Component)this.topView, "Center");
        JComponent jComponent = new JComponent(){};
        jComponent.addMouseListener(new MouseAdapter(){});
        jComponent.addKeyListener(new KeyAdapter(){});
        this.topFrame.setGlassPane(jComponent);
        this.topFrame.setJMenuBar(this.actionManager.getMenuBar());
        this.setFrameTitle(null);
        this.windowMap.put(this.topFrame, false);
        return this.topFrame;
    }

    private void initFontChooser() {
        Object object;
        FontRenderContext fontRenderContext = this.fontChooser.getFontRenderContext();
        boolean bl = fontRenderContext.isAntiAliased();
        boolean bl2 = fontRenderContext.usesFractionalMetrics();
        if (AppSetting.getInitfont() != null) {
            object = Font.decode(AppSetting.getInitfont());
            if (!((Font)object).equals(this.fontChooser.getSelectedFont())) {
                this.fontChooser.setSelectedFont((Font)object);
            }
            if (FontChooser.guessBitmapFont((Font)object)) {
                bl = false;
                bl2 = false;
            } else {
                bl = true;
                bl2 = true;
            }
        }
        if (AppSetting.useAntialias() != null) {
            bl = AppSetting.useAntialias();
        }
        if (AppSetting.useFractional() != null) {
            bl2 = AppSetting.useFractional();
        }
        object = new FontRenderContext(fontRenderContext.getTransform(), bl, bl2);
        this.fontChooser.setFontRenderContext((FontRenderContext)object);
    }

    private void actionAbout() {
        String string = Jindolf.TITLE + "   Version " + "2.19.2" + "\n" + Jindolf.COPYRIGHT + "\n" + "\u30e9\u30a4\u30bb\u30f3\u30b9: " + "The MIT License" + "\n" + "\u9023\u7d61\u5148: " + "http://jindolf.sourceforge.jp/";
        JOptionPane jOptionPane = new JOptionPane(string, 1, -1, GUIUtils.getLogoIcon());
        JDialog jDialog = jOptionPane.createDialog(this.topFrame, Jindolf.TITLE + "\u306b\u3064\u3044\u3066");
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    private void actionExit() {
        Jindolf.exit(0);
    }

    private void actionHelp() {
        if (this.helpFrame != null) {
            this.toggleWindow(this.helpFrame);
            return;
        }
        this.helpFrame = new HelpFrame();
        this.helpFrame.pack();
        this.helpFrame.setSize(450, 450);
        this.windowMap.put(this.helpFrame, false);
        this.helpFrame.setVisible(true);
    }

    private void actionShowWebVillage() {
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess serverAccess = land.getServerAccess();
        URL uRL = serverAccess.getVillageURL(village);
        String string = uRL.toString();
        if (village.getState() != VillageState.GAMEOVER) {
            string = string + "#bottom";
        }
        WebIPCDialog.showDialog(this.topFrame, string);
    }

    private void actionShowWebWiki() {
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        String string = village.getVillageName();
        String string2 = "http://wolfbbs.jp/" + string + "%C2%BC.html";
        WebIPCDialog.showDialog(this.topFrame, string2.toString());
    }

    private void actionShowWebCast() {
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess serverAccess = land.getServerAccess();
        URL uRL = serverAccess.getVillageURL(village);
        String string = "http://hon5.com/jinro/";
        try {
            string = string + "?u=" + URLEncoder.encode(uRL.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        string = string + "&s=1";
        WebIPCDialog.showDialog(this.topFrame, string.toString());
    }

    private void actionShowWebDay() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess serverAccess = land.getServerAccess();
        URL uRL = serverAccess.getPeriodURL(period);
        String string = uRL.toString();
        if (period.isHot()) {
            string = string + "#bottom";
        }
        WebIPCDialog.showDialog(this.topFrame, string);
    }

    private void actionShowWebTalk() {
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Discussion discussion = periodView.getDiscussion();
        Talk talk = discussion.getPopupedTalk();
        if (talk == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess serverAccess = land.getServerAccess();
        URL uRL = serverAccess.getPeriodURL(period);
        String string = uRL.toString();
        string = string + "#" + talk.getMessageID();
        WebIPCDialog.showDialog(this.topFrame, string);
    }

    private void actionShowPortal() {
        WebIPCDialog.showDialog(this.topFrame, "http://jindolf.sourceforge.jp/");
    }

    private void actionChangeLaF() {
        LookAndFeel lookAndFeel;
        Object object;
        String string = this.actionManager.getSelectedLookAndFeel();
        try {
            object = Class.forName(string);
            lookAndFeel = (LookAndFeel)((Class)object).newInstance();
        }
        catch (Exception exception) {
            String string2 = "\u3053\u306eLook&Feel[" + string + "]\u3092\u8aad\u307f\u8fbc\u3080\u4e8b\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
            Jindolf.logger.log(Level.WARNING, string2, exception);
            JOptionPane.showMessageDialog(this.topFrame, string2, "Look&Feel - " + Jindolf.TITLE, 2);
            return;
        }
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            String string3 = "\u3053\u306eLook&Feel[" + lookAndFeel.getName() + "]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            Jindolf.logger.log(Level.WARNING, string3, unsupportedLookAndFeelException);
            JOptionPane.showMessageDialog(this.topFrame, string3, "Look&Feel - " + Jindolf.TITLE, 2);
            return;
        }
        Jindolf.logger.info("Look&Feel\u304c[" + lookAndFeel.getName() + "]\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002");
        object = new Runnable(){

            public void run() {
                Set set = Controller.this.windowMap.keySet();
                for (Window window : set) {
                    SwingUtilities.updateComponentTreeUI(window);
                    window.validate();
                    boolean bl = (Boolean)Controller.this.windowMap.get(window);
                    if (!bl) continue;
                    window.pack();
                }
            }
        };
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable((Runnable)object){
            final /* synthetic */ Runnable val$updateUITask;
            {
                this.val$updateUITask = runnable;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("Look&Feel\u3092\u66f4\u65b0\u4e2d\u2026");
                try {
                    SwingUtilities.invokeAndWait(this.val$updateUITask);
                }
                catch (Exception exception) {
                    Jindolf.logger.log(Level.WARNING, "Look&Feel\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", exception);
                }
                finally {
                    Controller.this.updateStatusBar("Look&Feel\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f");
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void actionShowFilter() {
        this.toggleWindow(this.filterFrame);
    }

    private void actionShowAccount() {
        if (this.accountFrame != null) {
            this.toggleWindow(this.accountFrame);
            return;
        }
        this.accountFrame = new AccountPanel((Frame)this.topFrame, this.model);
        this.accountFrame.pack();
        this.accountFrame.setVisible(true);
        this.windowMap.put(this.accountFrame, true);
    }

    private void actionShowLog() {
        this.toggleWindow(this.showlogFrame);
    }

    private void actionTalkPreview() {
        this.toggleWindow(this.talkPreview);
    }

    private void actionFontSelect() {
        this.fontChooser.setVisible(true);
        if (this.fontChooser.isCanceled()) {
            return;
        }
        final Font font = this.fontChooser.getSelectedFont();
        final FontRenderContext fontRenderContext = this.fontChooser.getFontRenderContext();
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u3092\u5909\u66f4\u4e2d\u2026");
                try {
                    TabBrowser tabBrowser = Controller.this.topView.getTabBrowser();
                    tabBrowser.setFontInfo(font, fontRenderContext);
                    Controller.this.talkPreview.setTextFont(font);
                }
                catch (Exception exception) {
                    Jindolf.logger.log(Level.WARNING, "\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", exception);
                }
                finally {
                    Controller.this.updateStatusBar("\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u304c\u5909\u66f4\u3055\u308c\u307e\u3057\u305f");
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void actionShowDigest() {
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        final Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        VillageState villageState = village.getState();
        if (villageState != VillageState.EPILOGUE && villageState != VillageState.GAMEOVER || !village.isValid()) {
            String string = "\u30a8\u30d4\u30ed\u30fc\u30b0\u3092\u6b63\u5e38\u306b\u8fce\u3048\u3066\u3044\u306a\u3044\u6751\u306f\n\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u6a5f\u80fd\u3092\u5229\u7528\u3067\u304d\u307e\u305b\u3093";
            String string2 = "\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u4e0d\u53ef - " + Jindolf.TITLE;
            JOptionPane jOptionPane = new JOptionPane(string, 2, -1);
            JDialog jDialog = jOptionPane.createDialog(this.topFrame, string2);
            jDialog.pack();
            jDialog.setVisible(true);
            jDialog.dispose();
            return;
        }
        if (this.digestPanel == null) {
            this.digestPanel = new VillageDigest(this.topFrame);
            this.digestPanel.pack();
            this.digestPanel.setSize(600, 550);
            this.windowMap.put(this.digestPanel, false);
        }
        final VillageDigest villageDigest = this.digestPanel;
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            public void run() {
                Controller.this.taskFullOpenAllPeriod();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        villageDigest.setVillage(village);
                        villageDigest.setVisible(true);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskFullOpenAllPeriod() {
        this.setBusy(true);
        this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u958b\u59cb");
        try {
            TabBrowser tabBrowser = this.topView.getTabBrowser();
            Village village = tabBrowser.getVillage();
            if (village == null) {
                return;
            }
            for (PeriodView periodView : tabBrowser.getPeriodViewList()) {
                Period period = periodView.getPeriod();
                if (period == null || period.isFullOpen()) continue;
                String string = "" + period.getDay() + "\u65e5\u76ee\u306e" + "\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059";
                this.updateStatusBar(string);
                try {
                    period.reloadPeriod();
                }
                catch (IOException iOException) {
                    this.showNetworkError(village, iOException);
                    this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    this.setBusy(false);
                    return;
                }
                periodView.showTopics();
            }
        }
        finally {
            this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
            this.setBusy(false);
        }
    }

    private void actionShowFind() {
        this.findPanel.setVisible(true);
        if (this.findPanel.isCanceled()) {
            this.updateFindPanel();
            return;
        }
        if (this.findPanel.isBulkSearch()) {
            this.bulkSearch();
        } else {
            this.regexSearch();
        }
    }

    private void regexSearch() {
        Pattern pattern;
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        RegexPattern regexPattern = this.findPanel.getRegexPattern();
        int n = discussion.setRegexPattern(regexPattern);
        String string = "\uff3b" + n + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f";
        this.updateStatusBar(string);
        String string2 = "";
        if (regexPattern != null && (pattern = regexPattern.getPattern()) != null) {
            string2 = "\u6b63\u898f\u8868\u73fe " + pattern.pattern() + " \u306b";
        }
        string2 = string2 + string;
        Jindolf.logger.info(string2);
    }

    private void bulkSearch() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            public void run() {
                Controller.this.taskBulkSearch();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void taskBulkSearch() {
        void var6_9;
        Serializable serializable;
        this.taskLoadAllPeriod();
        int n = 0;
        RegexPattern regexPattern = this.findPanel.getRegexPattern();
        StringBuilder stringBuilder = new StringBuilder();
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        for (PeriodView object2 : tabBrowser.getPeriodViewList()) {
            serializable = object2.getDiscussion();
            int n2 = ((Discussion)serializable).setRegexPattern(regexPattern);
            n += n2;
            if (n2 <= 0) continue;
            Period period = ((Discussion)serializable).getPeriod();
            stringBuilder.append(' ').append(period.getDay()).append("d:");
            stringBuilder.append(n2).append("\u4ef6");
        }
        String string = "\uff3b" + n + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002" + stringBuilder.toString();
        this.updateStatusBar(string);
        String string2 = "";
        if (regexPattern != null && (serializable = regexPattern.getPattern()) != null) {
            String string3 = "\u6b63\u898f\u8868\u73fe " + ((Pattern)serializable).pattern() + " \u306b";
        }
        String string4 = (String)var6_9 + (String)string;
        Jindolf.logger.info(string4);
    }

    private void updateFindPanel() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        RegexPattern regexPattern = discussion.getRegexPattern();
        this.findPanel.setRegexPattern(regexPattern);
    }

    private void actionDaySummary() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        if (this.daySummaryPanel == null) {
            this.daySummaryPanel = new DaySummary(this.topFrame);
            this.daySummaryPanel.pack();
            this.daySummaryPanel.setSize(400, 500);
        }
        this.daySummaryPanel.summaryPeriod(period);
        this.daySummaryPanel.setVisible(true);
        this.windowMap.put(this.daySummaryPanel, false);
    }

    private void actionDayExportCsv() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        File file = CsvExporter.exportPeriod(period, this.filterFrame);
        if (file != null) {
            String string = "CSV\u30d5\u30a1\u30a4\u30eb(" + file.getName() + ")\u3078\u306e\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f";
            this.updateStatusBar(string);
        }
    }

    private void actionSearchNext() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.nextHotTarget();
    }

    private void actionSearchPrev() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.prevHotTarget();
    }

    private void actionReloadPeriod() {
        this.updatePeriod(true);
    }

    private void actionLoadAllPeriod() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            public void run() {
                Controller.this.taskLoadAllPeriod();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskLoadAllPeriod() {
        this.setBusy(true);
        this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u958b\u59cb");
        try {
            TabBrowser tabBrowser = this.topView.getTabBrowser();
            Village village = tabBrowser.getVillage();
            if (village == null) {
                return;
            }
            for (PeriodView periodView : tabBrowser.getPeriodViewList()) {
                Period period = periodView.getPeriod();
                if (period == null) continue;
                String string = "" + period.getDay() + "\u65e5\u76ee\u306e" + "\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059";
                this.updateStatusBar(string);
                try {
                    period.updatePeriod();
                }
                catch (IOException iOException) {
                    this.showNetworkError(village, iOException);
                    this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    this.setBusy(false);
                    return;
                }
                periodView.showTopics();
            }
        }
        finally {
            this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
            this.setBusy(false);
        }
    }

    private void actionReloadVillageList() {
        JTree jTree = this.topView.getTreeView();
        TreePath treePath = jTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Land land = null;
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            Object object = treePath.getPathComponent(i);
            if (!(object instanceof Land)) continue;
            land = (Land)object;
            break;
        }
        if (land == null) {
            return;
        }
        this.topView.showInitPanel();
        this.execReloadVillageList(land);
    }

    private void actionCopySelected() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence charSequence = discussion.copySelected();
        if (charSequence == null) {
            return;
        }
        charSequence = StringUtils.suppressString(charSequence);
        this.updateStatusBar("[" + charSequence + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void actionCopyTalk() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence charSequence = discussion.copyTalk();
        if (charSequence == null) {
            return;
        }
        charSequence = StringUtils.suppressString(charSequence);
        this.updateStatusBar("[" + charSequence + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void actionJumpAnchor() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Discussion discussion = periodView.getDiscussion();
        final TabBrowser tabBrowser = this.topView.getTabBrowser();
        final Village village = tabBrowser.getVillage();
        final Anchor anchor = discussion.getPopupedAnchor();
        if (anchor == null) {
            return;
        }
        final int n = anchor.getDay();
        final int n2 = tabBrowser.periodDaysToTabIndex(n);
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u30b8\u30e3\u30f3\u30d7\u5148\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                try {
                    final Period period = village.getPeriod(n);
                    if (period == null) {
                        Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u30b8\u30e3\u30f3\u30d7\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                        return;
                    }
                    period.updatePeriod();
                    Talk talk = null;
                    for (Topic object2 : period.getTopicList()) {
                        Talk talk2;
                        if (!(object2 instanceof Talk) || (talk2 = (Talk)object2).getHour() != anchor.getHour() || talk2.getMinute() != anchor.getMinute()) continue;
                        talk = talk2;
                        break;
                    }
                    if (talk == null) {
                        Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u30b8\u30e3\u30f3\u30d7\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                        return;
                    }
                    Iterator<Topic> iterator = talk;
                    final PeriodView periodView = tabBrowser.getPeriodView(n2);
                    SwingUtilities.invokeLater(new Runnable((Talk)((Object)iterator)){
                        final /* synthetic */ Talk val$targetTalk;
                        {
                            this.val$targetTalk = talk;
                        }

                        public void run() {
                            tabBrowser.setSelectedIndex(n2);
                            periodView.setPeriod(period);
                            periodView.scrollToTalk(this.val$targetTalk);
                        }
                    });
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306b\u30b8\u30e3\u30f3\u30d7\u3057\u307e\u3057\u305f");
                }
                catch (IOException iOException) {
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void execReloadVillageList(final Land land) {
        final LandsTree landsTree = this.topView.getLandsTree();
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                try {
                    try {
                        Controller.this.model.loadVillageList(land);
                    }
                    catch (IOException iOException) {
                        Controller.this.showNetworkError(land, iOException);
                    }
                    landsTree.expandLand(land);
                }
                finally {
                    Controller.this.updateStatusBar("\u6751\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void updatePeriod(final boolean bl) {
        final TabBrowser tabBrowser = this.topView.getTabBrowser();
        final Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        this.setFrameTitle(village.getVillageFullName());
        final PeriodView periodView = this.currentPeriodView();
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.setTopicFilter(this.filterFrame);
        final Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                try {
                    boolean bl2 = this.loadPeriod();
                    if (bl2 && !period.isHot() && !this.updatePeriodList()) {
                        return;
                    }
                    this.renderBrowser();
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadPeriod() {
                boolean bl2;
                Controller.this.updateStatusBar("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059\u2026");
                try {
                    bl2 = period.isHot();
                    try {
                        period.loadPeriod(bl);
                    }
                    catch (IOException iOException) {
                        Controller.this.showNetworkError(village, iOException);
                    }
                }
                finally {
                    Controller.this.updateStatusBar("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                }
                return bl2;
            }

            private boolean updatePeriodList() {
                Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u3066\u3044\u307e\u3059\u2026");
                try {
                    village.updatePeriodList();
                }
                catch (IOException iOException) {
                    Controller.this.showNetworkError(village, iOException);
                    return false;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            tabBrowser.setVillage(village);
                        }
                    });
                }
                catch (Exception exception) {
                    Jindolf.logger.log(Level.SEVERE, "\u30bf\u30d6\u64cd\u4f5c\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", exception);
                }
                Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u307e\u3057\u305f\u2026");
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void renderBrowser() {
                Controller.this.updateStatusBar("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    final int n = periodView.getVerticalPosition();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                periodView.showTopics();
                            }
                        });
                    }
                    catch (Exception exception) {
                        Jindolf.logger.log(Level.SEVERE, "\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", exception);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            periodView.setVerticalPosition(n);
                        }
                    });
                }
                finally {
                    Controller.this.updateStatusBar("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u5b8c\u4e86");
                }
            }
        });
    }

    private void filterChanged() {
        final Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.setTopicFilter(this.filterFrame);
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    discussion.filtering();
                }
                finally {
                    Controller.this.updateStatusBar("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u5b8c\u4e86");
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private PeriodView currentPeriodView() {
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        PeriodView periodView = tabBrowser.currentPeriodView();
        return periodView;
    }

    private Discussion currentDiscussion() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return null;
        }
        Discussion discussion = periodView.getDiscussion();
        return discussion;
    }

    private void toggleWindow(Window window) {
        if (window == null) {
            return;
        }
        if (window instanceof Frame) {
            boolean bl;
            Frame frame = (Frame)window;
            int n = frame.getExtendedState();
            boolean bl2 = bl = (n & 1) != 0;
            if (bl) {
                frame.setExtendedState(n &= 0xFFFFFFFE);
                frame.setVisible(true);
                return;
            }
        }
        if (window.isVisible()) {
            window.setVisible(false);
            window.dispose();
        } else {
            window.setVisible(true);
        }
    }

    public void showNetworkError(Village village, IOException iOException) {
        Land land = village.getParentLand();
        this.showNetworkError(land, iOException);
    }

    public void showNetworkError(Land land, IOException iOException) {
        Jindolf.logger.log(Level.WARNING, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3067\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", iOException);
        ServerAccess serverAccess = land.getServerAccess();
        String string = land.getLandDef().getLandName() + "\u3092\u904b\u55b6\u3059\u308b\u30b5\u30fc\u30d0\u3068\u306e\u9593\u306e\u901a\u4fe1\u3067" + "\u4f55\u3089\u304b\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n" + "\u76f8\u624b\u30b5\u30fc\u30d0\u306eURL\u306f [ " + serverAccess.getBaseURL() + " ] \u3060\u3088\u3002\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u904a\u3079\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u307f\u3066\u306d!\n";
        JOptionPane jOptionPane = new JOptionPane(string, 2, -1);
        JDialog jDialog = jOptionPane.createDialog(this.topFrame, "\u901a\u4fe1\u7570\u5e38\u767a\u751f - " + Jindolf.TITLE);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof Land) {
            Land land = (Land)object;
            this.setFrameTitle(land.getLandDef().getLandName());
            this.topView.showLandInfo(land);
            this.actionManager.appearVillage(false);
            this.actionManager.appearPeriod(false);
        } else if (object instanceof Village) {
            final Village village = (Village)object;
            ExecutorService executorService = Executors.newCachedThreadPool();
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Controller.this.setBusy(true);
                    Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                    try {
                        village.updatePeriodList();
                    }
                    catch (IOException iOException) {
                        Controller.this.showNetworkError(village, iOException);
                        return;
                    }
                    finally {
                        Controller.this.updateStatusBar("\u6751\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                        Controller.this.setBusy(false);
                    }
                    Controller.this.actionManager.appearVillage(true);
                    Controller.this.setFrameTitle(village.getVillageFullName());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Controller.this.topView.showVillageInfo(village);
                        }
                    });
                }
            });
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.filterFrame) {
            this.filterChanged();
        } else if (object instanceof TabBrowser) {
            this.updateFindPanel();
            this.updatePeriod(false);
            PeriodView periodView = this.currentPeriodView();
            if (periodView == null) {
                this.actionManager.appearPeriod(false);
            } else {
                this.actionManager.appearPeriod(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isBusyNow) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.equals("ACCOUNT")) {
            this.actionShowAccount();
        } else if (string.equals("EXIT")) {
            this.actionExit();
        } else if (string.equals("COPY")) {
            this.actionCopySelected();
        } else if (string.equals("SHOWFIND")) {
            this.actionShowFind();
        } else if (string.equals("SEARCHNEXT")) {
            this.actionSearchNext();
        } else if (string.equals("SEARCHPREV")) {
            this.actionSearchPrev();
        } else if (string.equals("ALLPERIOD")) {
            this.actionLoadAllPeriod();
        } else if (string.equals("DIGEST")) {
            this.actionShowDigest();
        } else if (string.equals("WEBVILL")) {
            this.actionShowWebVillage();
        } else if (string.equals("WEBWIKI")) {
            this.actionShowWebWiki();
        } else if (string.equals("WEBCAST")) {
            this.actionShowWebCast();
        } else if (string.equals("RELOAD")) {
            this.actionReloadPeriod();
        } else if (string.equals("DAYSUMMARY")) {
            this.actionDaySummary();
        } else if (string.equals("DAYEXPCSV")) {
            this.actionDayExportCsv();
        } else if (string.equals("WEBDAY")) {
            this.actionShowWebDay();
        } else if (string.equals("FONTSELECT")) {
            this.actionFontSelect();
        } else if (string.equals("LANDF")) {
            this.actionChangeLaF();
        } else if (string.equals("SHOWFILT")) {
            this.actionShowFilter();
        } else if (string.equals("SHOWEDIT")) {
            this.actionTalkPreview();
        } else if (string.equals("SHOWLOG")) {
            this.actionShowLog();
        } else if (string.equals("HELPDOC")) {
            this.actionHelp();
        } else if (string.equals("SHOWPORTAL")) {
            this.actionShowPortal();
        } else if (string.equals("ABOUT")) {
            this.actionAbout();
        } else if (string.equals("VILLAGELIST")) {
            this.actionReloadVillageList();
        } else if (string.equals("COPYTALK")) {
            this.actionCopyTalk();
        } else if (string.equals("JUMPANCHOR")) {
            this.actionJumpAnchor();
        } else if (string.equals("WEBTALK")) {
            this.actionShowWebTalk();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        if (!(treeExpansionEvent.getSource() instanceof JTree)) {
            return;
        }
        TreePath treePath = treeExpansionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof Land)) {
            return;
        }
        Land land = (Land)object;
        if (land.getVillageCount() > 0) {
            return;
        }
        this.execReloadVillageList(land);
    }

    public void anchorHitted(AnchorHitEvent anchorHitEvent) {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        final Village village = period.getVillage();
        final TalkDraw talkDraw = anchorHitEvent.getTalkDraw();
        final Anchor anchor = anchorHitEvent.getAnchor();
        final Discussion discussion = periodView.getDiscussion();
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u2026");
                try {
                    final List<Talk> list = village.getTalkListFromAnchor(anchor);
                    if (list == null || list.size() <= 0) {
                        Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            talkDraw.showAnchorTalks(anchor, list);
                            discussion.layoutRows();
                        }
                    });
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306e\u5c55\u958b\u5b8c\u4e86");
                }
                catch (IOException iOException) {
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void setBusy(final boolean bl) {
        this.isBusyNow = bl;
        Runnable runnable = new Runnable(){

            public void run() {
                Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
                Component component = Controller.this.topFrame.getGlassPane();
                component.setCursor(cursor);
                component.setVisible(bl);
                Controller.this.topView.setBusy(bl);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Jindolf.logger.log(Level.SEVERE, "\u30d3\u30b8\u30fc\u51e6\u7406\u3067\u5931\u6557", exception);
            }
        }
    }

    private void updateStatusBar(String string) {
        this.topView.updateSysMessage(string);
    }

    private void setFrameTitle(CharSequence charSequence) {
        String string = Jindolf.TITLE;
        if (charSequence != null && charSequence.length() > 0) {
            string = charSequence + " - " + string;
        }
        this.topFrame.setTitle(string);
    }
}

