/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.core.TalkType;

public class DaySummary
extends JDialog
implements WindowListener,
ActionListener,
ItemListener {
    private static final String FRAMETITLE = "\u767a\u8a00\u96c6\u8a08 - " + Jindolf.TITLE;
    private static final NumberFormat aveCharFormat;
    private static final String PUBTALK = "\u767d\u767a\u8a00";
    private static final String WOLFTALK = "\u8d64\u767a\u8a00";
    private static final String GRAVETALK = "\u9752\u767a\u8a00";
    private static final String PRVTALK = "\u7070\u767a\u8a00";
    private static final String ALLTALK = "\u5168\u767a\u8a00";
    private static final int HORIZONTAL_GAP = 5;
    private static final int VERTICAL_GAP = 1;
    private static final Color COLOR_ALL;
    private final DefaultTableModel tableModel;
    private final TableColumn avatarColumn;
    private final JTable tableComp;
    private final JComboBox typeSelector = new JComboBox();
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private final JLabel caption = new JLabel();
    private final JLabel totalSum = new JLabel();
    private TalkType talkFilter;
    private Period period;

    private static DefaultTableModel createInitModel() {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        Object[] objectArray = new Object[]{"\u540d\u524d", "\u767a\u8a00\u56de\u6570", "\u5e73\u5747\u6587\u5b57\u5217\u9577", "\u6700\u7d42\u767a\u8a00"};
        defaultTableModel.setColumnCount(objectArray.length);
        defaultTableModel.setColumnIdentifiers(objectArray);
        return defaultTableModel;
    }

    public DaySummary(Frame frame) {
        super(frame, FRAMETITLE, true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.tableModel = DaySummary.createInitModel();
        this.tableComp = new JTable();
        this.tableComp.setModel(this.tableModel);
        this.tableComp.setSelectionMode(0);
        this.tableComp.setIntercellSpacing(new Dimension(5, 1));
        this.tableComp.setDefaultEditor(Object.class, null);
        this.tableComp.setDefaultRenderer(Object.class, new CustomRenderer());
        this.tableComp.setShowGrid(true);
        TableColumnModel tableColumnModel = this.tableComp.getColumnModel();
        this.avatarColumn = tableColumnModel.getColumn(0);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        tableColumnModel.getColumn(1).setCellRenderer(defaultTableCellRenderer);
        defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        tableColumnModel.getColumn(2).setCellRenderer(defaultTableCellRenderer);
        defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        tableColumnModel.getColumn(3).setCellRenderer(defaultTableCellRenderer);
        this.typeSelector.addItem(PUBTALK);
        this.typeSelector.addItem(WOLFTALK);
        this.typeSelector.addItem(GRAVETALK);
        this.typeSelector.addItem(PRVTALK);
        this.typeSelector.addItem(ALLTALK);
        this.closeButton.addActionListener(this);
        this.typeSelector.addItemListener(this);
        this.typeSelector.setSelectedItem(null);
        this.typeSelector.setSelectedItem(PUBTALK);
        this.design();
        this.clearModel();
    }

    private void clearModel() {
        int n = this.tableModel.getRowCount();
        for (int i = 1; i <= n; ++i) {
            this.tableModel.removeRow(0);
        }
    }

    private void appendRow(Avatar avatar, Integer n, Integer n2, String string) {
        String string2 = n + " \u56de";
        double d = n <= 0 ? 0.0 : (double)n2.intValue() / (double)n.intValue();
        String string3 = aveCharFormat.format(d) + " \u6587\u5b57";
        Object[] objectArray = new Object[]{avatar, string2, string3, string};
        int n3 = this.tableModel.getRowCount();
        this.tableModel.insertRow(n3, objectArray);
    }

    private void design() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.caption, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        container.add((Component)this.typeSelector, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this.tableComp);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.totalSum, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        container.add((Component)this.closeButton, gridBagConstraints);
    }

    public void summaryPeriod(Period period) {
        this.period = period;
        this.summaryPeriod();
    }

    private void summaryPeriod() {
        Object object;
        Integer n;
        Object object2;
        Object object32;
        this.clearModel();
        if (this.period == null) {
            return;
        }
        TreeSet<Object> treeSet = new TreeSet<Object>();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>();
        List<Topic> list = this.period.getTopicList();
        for (Topic object42 : list) {
            if (!(object42 instanceof Talk) || ((Talk)(object32 = (Talk)object42)).getTalkCount() <= 0 || this.talkFilter != null && ((Talk)object32).getTalkType() != this.talkFilter) continue;
            object2 = ((Talk)object32).getAvatar();
            n = (Integer)hashMap.get(object2);
            if (n == null) {
                n = new Integer(0);
            }
            object = n;
            Integer n2 = n = Integer.valueOf(n + 1);
            hashMap.put(object2, n);
            object = (Integer)hashMap2.get(object2);
            if (object == null) {
                object = new Integer(0);
            }
            object = (Integer)object + ((Talk)object32).getTotalChars();
            hashMap2.put(object2, object);
            hashMap3.put(object2, object32);
            treeSet.add(object2);
        }
        int n3 = 0;
        for (Object object32 : treeSet) {
            object2 = (Integer)hashMap.get(object32);
            n = (Integer)hashMap2.get(object32);
            object = ((Talk)hashMap3.get(object32)).getAnchorNotation();
            this.appendRow((Avatar)object32, (Integer)object2, n, (String)object);
            n3 += ((Integer)object2).intValue();
        }
        this.totalSum.setText("\u5408\u8a08\uff1a" + n3 + " \u767a\u8a00");
        Village village = this.period.getVillage();
        object32 = village.getVillageName();
        object2 = this.period.getCaption();
        this.caption.setText((String)object32 + "\u6751 " + (String)object2);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.closeButton) {
            return;
        }
        this.close();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        Object object = this.typeSelector.getSelectedItem();
        if (object == PUBTALK) {
            this.talkFilter = TalkType.PUBLIC;
        } else if (object == WOLFTALK) {
            this.talkFilter = TalkType.WOLFONLY;
        } else if (object == GRAVETALK) {
            this.talkFilter = TalkType.GRAVE;
        } else if (object == PRVTALK) {
            this.talkFilter = TalkType.PRIVATE;
        } else if (object == ALLTALK) {
            this.talkFilter = null;
        }
        this.summaryPeriod();
    }

    private void close() {
        this.clearModel();
        this.period = null;
        this.setVisible(false);
    }

    static {
        COLOR_ALL = new Color(0xFFFF80);
        aveCharFormat = NumberFormat.getInstance();
        aveCharFormat.setMaximumFractionDigits(1);
        aveCharFormat.setMinimumFractionDigits(1);
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object object) {
            if (object instanceof Avatar) {
                Serializable serializable;
                Avatar avatar = (Avatar)object;
                Village village = DaySummary.this.period.getVillage();
                Image image = village.getAvatarFaceImage(avatar);
                if (image == null) {
                    image = village.getGraveImage();
                }
                if (image != null) {
                    serializable = new ImageIcon(image);
                    this.setIcon((Icon)((Object)serializable));
                }
                this.setText(avatar.getName());
                serializable = this.getPreferredSize();
                int n = 2 + ((Dimension)serializable).height;
                if (DaySummary.this.tableComp.getRowHeight() < n) {
                    DaySummary.this.tableComp.setRowHeight(n);
                }
                int n2 = 10 + ((Dimension)serializable).width;
                if (DaySummary.this.avatarColumn.getPreferredWidth() < n2) {
                    DaySummary.this.avatarColumn.setPreferredWidth(n2);
                }
                return;
            }
            super.setValue(object);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Object object2 = DaySummary.this.typeSelector.getSelectedItem();
            Color color = null;
            if (object2 == DaySummary.PUBTALK) {
                color = TalkDraw.COLOR_PUBLIC;
            } else if (object2 == DaySummary.WOLFTALK) {
                color = TalkDraw.COLOR_WOLFONLY;
            } else if (object2 == DaySummary.GRAVETALK) {
                color = TalkDraw.COLOR_GRAVE;
            } else if (object2 == DaySummary.PRVTALK) {
                color = TalkDraw.COLOR_PRIVATE;
            } else if (object2 == DaySummary.ALLTALK) {
                color = COLOR_ALL;
            } else {
                assert (false);
                return null;
            }
            component.setForeground(Color.BLACK);
            component.setBackground(color);
            return component;
        }
    }
}

