/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.TextPopup;

public class HelpFrame
extends JFrame
implements ActionListener,
HyperlinkListener {
    private static final String HELP_HTML = "resources/html/help.html";
    private JTabbedPane tabPanel = new JTabbedPane();
    private JEditorPane htmlView = new JEditorPane();
    private JTextArea vmInfo = new JTextArea();
    private JButton closeButton = new JButton("\u9589\u3058\u308b");

    public HelpFrame() {
        super(Jindolf.TITLE + " \u30d8\u30eb\u30d7");
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.htmlView.setEditable(false);
        this.htmlView.setContentType("text/html");
        this.htmlView.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.htmlView.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.htmlView.setBorder(border);
        this.htmlView.addHyperlinkListener(this);
        this.htmlView.setComponentPopupMenu(new TextPopup());
        this.vmInfo.setEditable(false);
        this.vmInfo.setLineWrap(true);
        this.vmInfo.setComponentPopupMenu(new TextPopup());
        this.closeButton.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HelpFrame.this.close();
            }
        });
        URL uRL = Jindolf.getResource(HELP_HTML);
        this.loadURL(uRL);
        this.vmInfo.setText(AppSetting.getVMInfo());
        this.design();
    }

    private void design() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.htmlView);
        this.tabPanel.add("\u30d8\u30eb\u30d7", jScrollPane);
        jScrollPane = new JScrollPane(this.vmInfo);
        this.tabPanel.add("\u5b9f\u884c\u74b0\u5883", jScrollPane);
        container.add((Component)this.tabPanel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        container.add((Component)this.closeButton, gridBagConstraints);
    }

    private void close() {
        this.setVisible(false);
    }

    private void loadURL(URL uRL) {
        if (uRL == null) {
            return;
        }
        try {
            this.htmlView.setPage(uRL);
        }
        catch (IOException iOException) {
            Jindolf.logger.log(Level.WARNING, "\u30d8\u30eb\u30d7\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", iOException);
            assert (false);
            throw new Error();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.closeButton) {
            return;
        }
        this.close();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL uRL = hyperlinkEvent.getURL();
        this.loadURL(uRL);
    }
}

