/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.HtmlSequence;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.NetUtil;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.core.LandDef;
import jp.sourceforge.jindolf.core.LandState;
import jp.sourceforge.jindolf.core.VillageState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Land {
    private static final String Spchar = " \\t\\n\\r";
    private static final String Sp = "[ \\t\\n\\r]";
    private static final String Sp_n = "[ \\t\\n\\r]*";
    private static final String Sp_m = "[ \\t\\n\\r]+";
    private static final Pattern anchorRegex;
    private final LandDef landDef;
    private final ServerAccess serverAccess;
    private final List<Village> villageList = new LinkedList<Village>();

    public static String getValueFromCGIQueries(String string, String string2) {
        String string3 = null;
        String[] stringArray = string2.split("\\Q&\\E");
        if (stringArray == null) {
            return null;
        }
        for (String string4 : stringArray) {
            String[] stringArray2;
            if (string4 == null || (stringArray2 = string4.split("\\Q=\\E")) == null || stringArray2.length != 2) continue;
            String string5 = stringArray2[0];
            String string6 = stringArray2[1];
            if (string5 != null && string5.equals(string) && (string3 = string6) != null && string3.length() > 0) break;
        }
        return string3;
    }

    public static String getVillageIDFromHREF(CharSequence charSequence) {
        String string = NetUtil.getQueryFromHREF(charSequence);
        if (string == null) {
            return null;
        }
        String string2 = Land.getValueFromCGIQueries("vid", string);
        if (string2 == null) {
            return null;
        }
        if (string2.length() <= 0) {
            return null;
        }
        return string2;
    }

    public Land(LandDef landDef) throws IllegalArgumentException {
        URL uRL;
        this.landDef = landDef;
        try {
            uRL = this.landDef.getCgiURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
        this.serverAccess = new ServerAccess(uRL);
    }

    public LandDef getLandDef() {
        return this.landDef;
    }

    public ServerAccess getServerAccess() {
        return this.serverAccess;
    }

    public Village getVillage(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.getVillageCount()) {
            return null;
        }
        Village village = this.villageList.get(n);
        return village;
    }

    public int getVillageCount() {
        int n = this.villageList.size();
        return n;
    }

    public List<Village> getVillageList() {
        return Collections.unmodifiableList(this.villageList);
    }

    public Image downloadImage(String string) {
        Image image;
        ServerAccess serverAccess = this.getServerAccess();
        try {
            image = serverAccess.downloadImage(string);
        }
        catch (IOException iOException) {
            Jindolf.logger.log(Level.WARNING, "\u30a4\u30e1\u30fc\u30b8[" + string + "]" + "\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", iOException);
            return null;
        }
        return image;
    }

    private Collection<Village> parseVillageList(CharSequence charSequence) {
        Vector<Village> vector = new Vector<Village>();
        Matcher matcher = anchorRegex.matcher(charSequence);
        while (matcher.find()) {
            String string;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (string2 == null || string2.length() <= 0) continue;
            if (string3 == null) {
                string3 = "";
            }
            if ((string = Land.getVillageIDFromHREF(string2)) == null || string.length() <= 0) continue;
            String string5 = string3.replaceAll(Sp_m, " ").trim();
            String[] stringArray = string5.split(" ");
            if (stringArray != null && stringArray[0] != null && stringArray[0].equals(string)) {
                string5 = this.getLandDef().getLandPrefix() + string5;
            }
            Village village = new Village(this, string, string5);
            VillageState villageState = string4 == null || this.getLandDef().getLandState() == LandState.HISTORICAL ? VillageState.GAMEOVER : (string4.equals("\u53c2\u52a0\u8005\u52df\u96c6\u4e2d\u3067\u3059\u3002") ? VillageState.PROLOGUE : (string4.equals("\u958b\u59cb\u5f85\u3061\u3067\u3059\u3002") ? VillageState.PROLOGUE : (string4.equals("\u9032\u884c\u4e2d\u3067\u3059\u3002") ? VillageState.PROGRESS : (string4.equals("\u52dd\u6557\u304c\u6c7a\u5b9a\u3057\u307e\u3057\u305f\u3002") ? VillageState.EPILOGUE : (string4.equals("\u7d42\u4e86\u30fb\u30ed\u30b0\u516c\u958b\u4e2d\u3002") ? VillageState.GAMEOVER : VillageState.UNKNOWN)))));
            village.setState(villageState);
            vector.add(village);
        }
        return vector;
    }

    public void updateVillageList() throws IOException {
        TreeSet<Village> treeSet = new TreeSet<Village>();
        ServerAccess serverAccess = this.getServerAccess();
        HtmlSequence htmlSequence = serverAccess.getHTMLTopPage();
        Collection<Village> collection = this.parseVillageList(htmlSequence);
        treeSet.addAll(collection);
        htmlSequence = serverAccess.getHTMLLandList();
        collection = this.parseVillageList(htmlSequence);
        treeSet.addAll(collection);
        this.villageList.clear();
        this.villageList.addAll(treeSet);
    }

    public String toString() {
        return this.getLandDef().getLandName();
    }

    static {
        String string = "<a[ \\t\\n\\r]+href=\"([^\"]*)\"[ \\t\\n\\r]*>";
        String string2 = "</a>";
        String string3 = "[ \\t\\n\\r]*<strong>[^<]*</strong>[ \\t\\n\\r]*</td>";
        String string4 = "[ \\t\\n\\r]*<td>([^<]*)</td>";
        String string5 = "(?:" + string3 + string4 + ")?";
        String string6 = string + "([^<]*)" + string2 + string5;
        anchorRegex = Pattern.compile(string6, 32);
    }
}

