/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.WebIPCDialog;
import jp.sourceforge.jindolf.core.LandDef;
import jp.sourceforge.jindolf.core.LandState;

public class LandInfoPanel
extends JPanel
implements ActionListener {
    private static final String COMMAND_SHOWBASE = "SHOWBASE";
    private static final String COMMAND_SHOWCONTACT = "SHOWCONTACT";
    private final JLabel landName = new JLabel();
    private final JLabel landIdentifier = new JLabel();
    private final JLabel baseURL = new JLabel();
    private final JLabel startDate = new JLabel();
    private final JLabel endDate = new JLabel();
    private final JLabel landState = new JLabel();
    private final JLabel locale = new JLabel();
    private final JLabel timezone = new JLabel();
    private final JLabel contact = new JLabel();
    private final JLabel description = new JLabel();

    private static String getStatusMark(LandState landState) {
        String string;
        switch (landState) {
            case CLOSED: {
                string = "\u30b5\u30fc\u30d3\u30b9\u7d42\u4e86";
                break;
            }
            case HISTORICAL: {
                string = "\u904e\u53bb\u30ed\u30b0\u63d0\u4f9b\u306e\u307f";
                break;
            }
            case ACTIVE: {
                string = "\u7a3c\u52d5\u4e2d";
                break;
            }
            default: {
                assert (false);
                string = "";
            }
        }
        return string;
    }

    public LandInfoPanel() {
        GUIUtils.forceMonoPitchFont(this.baseURL);
        GUIUtils.forceMonoPitchFont(this.contact);
        GUIUtils.forceMonoPitchFont(this.landIdentifier);
        GUIUtils.forceMonoPitchFont(this.locale);
        this.design();
    }

    private void layoutRow(String string, JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        String string2 = string + " : ";
        JLabel jLabel = new JLabel(string2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jComponent, gridBagConstraints);
    }

    private JComponent buildShowWeb(JLabel jLabel, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JButton jButton = new JButton("Web");
        jButton.setIcon(GUIUtils.getWWWIcon());
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        jButton.setToolTipText("Web\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a");
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private void design() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.layoutRow("\u56fd\u540d", this.landName);
        this.layoutRow("\u8b58\u5225\u540d", this.landIdentifier);
        JComponent jComponent = this.buildShowWeb(this.baseURL, COMMAND_SHOWBASE);
        this.layoutRow("\u30d9\u30fc\u30b9URL", jComponent);
        this.layoutRow("\u5efa\u56fd", this.startDate);
        this.layoutRow("\u4ea1\u56fd", this.endDate);
        this.layoutRow("\u72b6\u614b", this.landState);
        this.layoutRow("\u30ed\u30b1\u30fc\u30eb", this.locale);
        this.layoutRow("\u6642\u9593\u5e2f", this.timezone);
        JComponent jComponent2 = this.buildShowWeb(this.contact, COMMAND_SHOWCONTACT);
        this.layoutRow("\u9023\u7d61\u5148", jComponent2);
        this.layoutRow("\u8aac\u660e", this.description);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    public void update(Land land) {
        LandDef landDef = land.getLandDef();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        Date date = landDef.getStartDate();
        String string = dateFormat.format(date);
        if (date.equals(LandDef.DATE_UNKNOWN)) {
            string = "(\u4e0d\u660e)";
        }
        Date date2 = landDef.getEndDate();
        String string2 = dateFormat.format(date2);
        if (date2.equals(LandDef.DATE_UNKNOWN)) {
            string2 = "\u307e\u3060\u307e\u3060";
        }
        String string3 = LandInfoPanel.getStatusMark(land.getLandDef().getLandState());
        String string4 = land.getServerAccess().getBaseURL().toString();
        this.landName.setText(landDef.getLandName());
        this.landIdentifier.setText(landDef.getLandId());
        this.baseURL.setText(string4);
        this.startDate.setText(string);
        this.endDate.setText(string2);
        this.landState.setText(string3);
        this.locale.setText(landDef.getLocale().toString());
        this.timezone.setText(landDef.getTimeZone().getDisplayName());
        this.contact.setText(landDef.getContactInfo());
        this.description.setText(landDef.getDescription());
        this.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Window window = SwingUtilities.getWindowAncestor(this);
        Frame frame = null;
        if (window instanceof Frame) {
            frame = (Frame)window;
        }
        if ((string = actionEvent.getActionCommand()).equals(COMMAND_SHOWBASE)) {
            WebIPCDialog.showDialog(frame, this.baseURL.getText());
        } else if (string.equals(COMMAND_SHOWCONTACT)) {
            WebIPCDialog.showDialog(frame, this.contact.getText());
        }
    }
}

