/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.core.LandDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LandsModel
implements TreeModel {
    private static final String LANDS_DEF = "resources/land.properties";
    private static final String KEY_PREFIX = "land.order.";
    private static final String ROOT = "ROOT";
    private static final int SECTION_INTERVAL = 100;
    private final List<Land> landList = new LinkedList<Land>();
    private final List<Land> unmodList = Collections.unmodifiableList(this.landList);
    private final Map<Land, List<VillageSection>> sectionMap = new HashMap<Land, List<VillageSection>>();
    private boolean isLandListLoaded = false;
    private final EventListenerList listeners = new EventListenerList();
    private boolean ascending = false;

    public void loadVillageList(Land land) throws IOException {
        land.updateVillageList();
        List list = VillageSection.getSectionList(land, 100);
        this.sectionMap.put(land, list);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        Object[] objectArray = list.toArray();
        Object[] objectArray2 = new Object[]{ROOT, land};
        TreePath treePath = new TreePath(objectArray2);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireTreeStructureChanged(treeModelEvent);
    }

    public void loadLandList() {
        if (this.isLandListLoaded) {
            return;
        }
        this.landList.clear();
        for (LandDef landDef : LandDef.getLandDefList()) {
            Land land = new Land(landDef);
            this.landList.add(land);
        }
        this.isLandListLoaded = true;
        this.fireLandListChanged();
    }

    private void fireLandListChanged() {
        int n = this.landList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = i;
        }
        Object[] objectArray = this.landList.toArray();
        TreePath treePath = new TreePath(ROOT);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireTreeStructureChanged(treeModelEvent);
    }

    public void setAscending(boolean bl) {
        if (this.ascending == bl) {
            return;
        }
        this.ascending = bl;
        this.fireLandListChanged();
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(TreeModelListener.class, treeModelListener);
    }

    private TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.getTreeModelListeners()) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public List<Land> getLandList() {
        return this.unmodList;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.getChildCount(object)) {
            return null;
        }
        if (object == ROOT) {
            List<Land> list = this.getLandList();
            if (!this.ascending) {
                n = list.size() - n - 1;
            }
            Land land = list.get(n);
            return land;
        }
        if (object instanceof Land) {
            Land land = (Land)object;
            List<VillageSection> list = this.sectionMap.get(land);
            if (!this.ascending) {
                n = list.size() - n - 1;
            }
            VillageSection villageSection = list.get(n);
            return villageSection;
        }
        if (object instanceof VillageSection) {
            VillageSection villageSection = (VillageSection)object;
            if (!this.ascending) {
                n = villageSection.getVillageCount() - n - 1;
            }
            Village village = villageSection.getVillage(n);
            return village;
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        if (object == ROOT) {
            return this.getLandList().size();
        }
        if (object instanceof Land) {
            Land land = (Land)object;
            List<VillageSection> list = this.sectionMap.get(land);
            if (list == null) {
                return 0;
            }
            return list.size();
        }
        if (object instanceof VillageSection) {
            VillageSection villageSection = (VillageSection)object;
            return villageSection.getVillageCount();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object2 == null) {
            return -1;
        }
        if (object == ROOT) {
            List<Land> list = this.getLandList();
            int n = list.indexOf(object2);
            if (!this.ascending) {
                n = list.size() - n - 1;
            }
            return n;
        }
        if (object instanceof Land) {
            Land land = (Land)object;
            List<VillageSection> list = this.sectionMap.get(land);
            int n = list.indexOf(object2);
            if (!this.ascending) {
                n = list.size() - n - 1;
            }
            return n;
        }
        if (object instanceof VillageSection) {
            VillageSection villageSection = (VillageSection)object;
            int n = villageSection.getIndexOfVillage(object2);
            if (!this.ascending) {
                n = villageSection.getVillageCount() - n - 1;
            }
            return n;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object == ROOT) {
            return false;
        }
        if (object instanceof Land) {
            return false;
        }
        if (object instanceof VillageSection) {
            return false;
        }
        if (object instanceof Village) {
            return true;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VillageSection {
        private final int startID;
        private final int endID;
        private final String prefix;
        private final List<Village> villageList = new LinkedList<Village>();

        private static List<VillageSection> getSectionList(Land land, int n) throws IllegalArgumentException {
            int n2;
            if (n <= 0) {
                throw new IllegalArgumentException();
            }
            List<Village> list = land.getVillageList();
            Village village = list.get(0);
            Village village2 = list.get(list.size() - 1);
            int n3 = village.getVillageIDNum();
            int n4 = village2.getVillageIDNum();
            LinkedList<VillageSection> linkedList = new LinkedList<VillageSection>();
            for (int i = n2 = n3 / n * n; i <= n4; i += n) {
                VillageSection villageSection = new VillageSection(land, i, i + n - 1);
                linkedList.add(villageSection);
            }
            return Collections.unmodifiableList(linkedList);
        }

        private VillageSection(Land land, int n, int n2) throws IndexOutOfBoundsException {
            if (n < 0 || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            this.startID = n;
            this.endID = n2;
            this.prefix = land.getLandDef().getLandPrefix();
            for (Village village : land.getVillageList()) {
                int n3 = village.getVillageIDNum();
                if (n > n3 || n3 > n2) continue;
                this.villageList.add(village);
            }
        }

        private int getVillageCount() {
            return this.villageList.size();
        }

        private Village getVillage(int n) {
            return this.villageList.get(n);
        }

        private int getIndexOfVillage(Object object) {
            return this.villageList.indexOf(object);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.prefix).append(this.startID);
            stringBuilder.append(" \uff5e ");
            stringBuilder.append(this.prefix).append(this.endID);
            return stringBuilder.toString();
        }
    }
}

