/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.MatteBorder;
import jp.sourceforge.jindolf.Discussion;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.core.TalkType;

public class PeriodView
extends JPanel
implements ItemListener {
    private static final Color COLOR_SELECT = new Color(0xFFFF80);
    private Period period;
    private final Discussion discussion;
    private final JScrollPane scroller = new JScrollPane();
    private final JLabel caption = new JLabel();
    private final JLabel limit = new JLabel();
    private final JComboBox talkSelector = new JComboBox();
    private final DefaultComboBoxModel model = new DefaultComboBoxModel();

    public PeriodView(Period period) {
        this.period = period;
        this.talkSelector.setEditable(false);
        this.talkSelector.setMaximumRowCount(20);
        this.talkSelector.setModel(this.model);
        this.talkSelector.setRenderer(new AnchorRenderer());
        this.talkSelector.addItemListener(this);
        this.discussion = new Discussion();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(15, 15, 15, 15, Color.BLACK);
        this.discussion.setBorder(matteBorder);
        this.discussion.setPeriod(this.period);
        JViewport jViewport = this.scroller.getViewport();
        jViewport.setBackground(Color.BLACK);
        jViewport.setView(this.discussion);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.design();
    }

    private void design() {
        JPanel jPanel = new JPanel();
        LayoutManager2 layoutManager2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(layoutManager2);
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.caption, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.limit, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.talkSelector, gridBagConstraints);
        layoutManager2 = new BorderLayout();
        this.setLayout(layoutManager2);
        this.add((Component)jPanel, "North");
        this.add((Component)this.scroller, "Center");
    }

    public void setPeriod(Period period) {
        this.discussion.setPeriod(period);
        this.period = period;
        this.updateTopPanel();
    }

    public Period getPeriod() {
        return this.discussion.getPeriod();
    }

    private void updateTopPanel() {
        if (this.period == null) {
            this.caption.setText("");
            this.limit.setText("");
            this.model.removeAllElements();
            return;
        }
        Village village = this.period.getVillage();
        String string = village.getVillageName();
        String string2 = this.period.getCaption();
        String string3 = this.period.getLimit();
        String string4 = this.period.getLoginName();
        String string5 = this.period.isFullOpen() ? "" : (string4 != null ? " (\u30ed\u30b0\u30a4\u30f3\u4e2d)" : " (\u30ed\u30b0\u30a2\u30a6\u30c8\u4e2d)");
        String string6 = string + "\u6751 " + string2 + string5;
        this.caption.setText(string6);
        this.limit.setText("\u66f4\u65b0\u6642\u523b " + string3);
        this.model.removeAllElements();
        this.model.addElement(" ");
        List<Topic> list = this.period.getTopicList();
        for (Topic topic : list) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getTalkCount() <= 0) continue;
            this.model.addElement(talk);
        }
    }

    public void showTopics() {
        Period period = this.discussion.getPeriod();
        this.setPeriod(period);
    }

    public void setFontInfo(Font font, FontRenderContext fontRenderContext) {
        this.discussion.setFontInfo(font, fontRenderContext);
    }

    public Discussion getDiscussion() {
        return this.discussion;
    }

    public int getVerticalPosition() {
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        int n = jScrollBar.getValue();
        return n;
    }

    public void setVerticalPosition(int n) {
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        Object object = this.talkSelector.getSelectedItem();
        if (!(object instanceof Talk)) {
            return;
        }
        Talk talk = (Talk)object;
        this.scrollToTalk(talk);
    }

    public void scrollToTalk(Talk talk) {
        if (talk == null) {
            return;
        }
        if (talk.getPeriod() != this.period) {
            return;
        }
        Rectangle rectangle = this.discussion.getTalkBounds(talk);
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.y -= 15;
        rectangle2.height = this.scroller.getHeight();
        this.discussion.scrollRectToVisible(rectangle2);
    }

    private class AnchorRenderer
    extends DefaultListCellRenderer {
        private AnchorRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            Object object3;
            Talk talk = null;
            if (object instanceof Talk) {
                talk = (Talk)object;
                object3 = talk.getAnchorNotation();
                object2 = talk.getAvatar().getName();
                object = (String)object3 + " " + (String)object2;
            }
            object3 = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (talk != null) {
                object2 = null;
                if (bl) {
                    object2 = COLOR_SELECT;
                } else {
                    TalkType talkType = talk.getTalkType();
                    object2 = TalkDraw.getTypedColor(talkType);
                }
                ((Component)object3).setForeground(Color.BLACK);
                ((Component)object3).setBackground((Color)object2);
            }
            return object3;
        }
    }
}

