/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import jp.sourceforge.jindolf.AbstractTextRow;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.SysEvent;

public class SysEventDraw
extends AbstractTextRow {
    public static final Color COLOR_ANNOUNCE = new Color(0xFFFFFF);
    public static final Color COLOR_ORDER = new Color(0xF04040);
    public static final Color COLOR_EXTRA = new Color(0x808080);
    private static final int INSET = 10;
    private static final int UNDER_MARGIN = 15;
    private final SysEvent sysEvent;
    private final GlyphDraw sysMessage;

    public SysEventDraw(SysEvent sysEvent) {
        this.sysEvent = sysEvent;
        this.sysMessage = new GlyphDraw(this.sysEvent.getMessage());
        this.sysMessage.setColor(this.getEventColor());
    }

    public SysEvent getSysEvent() {
        return this.sysEvent;
    }

    protected Color getEventColor() {
        Color color;
        switch (this.sysEvent.getEventFamily()) {
            case ANNOUNCE: {
                color = COLOR_ANNOUNCE;
                break;
            }
            case ORDER: {
                color = COLOR_ORDER;
                break;
            }
            case EXTRA: {
                color = COLOR_EXTRA;
                break;
            }
            default: {
                assert (false);
                color = null;
            }
        }
        return color;
    }

    public Rectangle setWidth(int n) {
        Rectangle rectangle = this.sysMessage.setWidth(n - 10 - 10);
        this.bounds.width = n;
        this.bounds.height = rectangle.height + 10 + 10 + 15;
        return this.bounds;
    }

    public void setFontInfo(Font font, FontRenderContext fontRenderContext) {
        super.setFontInfo(font, fontRenderContext);
        this.sysMessage.setFontInfo(this.font, this.renderContext);
        int n = this.getWidth();
        this.setWidth(n);
    }

    public void drag(Point point, Point point2) {
        this.sysMessage.drag(point, point2);
    }

    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.sysMessage.appendSelected(appendable);
        return appendable;
    }

    public void clearSelect() {
        this.sysMessage.clearSelect();
    }

    public void setPos(int n, int n2) {
        super.setPos(n, n2);
        this.sysMessage.setPos(this.bounds.x + 10, this.bounds.y + 10);
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setColor(this.getEventColor());
        graphics2D.drawRect(this.bounds.x, this.bounds.y, this.bounds.width - 1, this.bounds.height - 15);
        this.sysMessage.paint(graphics2D);
    }
}

