/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandInfoPanel;
import jp.sourceforge.jindolf.LandsTree;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.Village;

public class TopView
extends JPanel {
    private static final String INITCARD = "INITCARD";
    private static final String LANDCARD = "LANDINFO";
    private static final String BROWSECARD = "BROWSER";
    private final JComponent cards;
    private final CardLayout cardLayout = new CardLayout();
    private final LandsTree landsTreeView = new LandsTree();
    private final LandInfoPanel landInfo = new LandInfoPanel();
    private final JTextField sysMessage = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();
    private final TabBrowser tabBrowser = new TabBrowser();
    private JComponent browsePanel;

    public TopView() {
        this.cards = this.createCards();
        JComponent jComponent = this.createSplitPane(this.landsTreeView, this.cards);
        JComponent jComponent2 = this.createStatusBar();
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.add((Component)jComponent, "Center");
        this.add((Component)jComponent2, "South");
    }

    private JComponent createCards() {
        this.browsePanel = this.createBrowsePanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.cardLayout);
        jPanel.add(INITCARD, this.createInitCard());
        jPanel.add(LANDCARD, this.createLandInfoCard());
        jPanel.add(BROWSECARD, this.browsePanel);
        return jPanel;
    }

    private JComponent createInitCard() {
        JLabel jLabel = new JLabel("\u2190 \u6751\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u203b \u53c2\u52a0\u4e2d\u306e\u6751\u304c\u3042\u308b\u4eba\u306f<br></br>");
        stringBuilder.append("\u30e1\u30cb\u30e5\u30fc\u306e\u300c\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406\u300d\u304b\u3089<br></br>");
        stringBuilder.append("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u3060\u3055\u3044");
        stringBuilder.insert(0, "<center>").append("</center>");
        stringBuilder.insert(0, "<body>").append("</body>");
        stringBuilder.insert(0, "<html>").append("</html>");
        JLabel jLabel2 = new JLabel(stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("\u203b \u305f\u307e\u306b\u306fWeb\u30d6\u30e9\u30a6\u30b6\u3067\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3001");
        stringBuilder2.append("<br></br>");
        stringBuilder2.append("\u904b\u55b6\u306e\u52d5\u5411\u3092\u78ba\u304b\u3081\u3088\u3046\u306d\uff01");
        stringBuilder2.insert(0, "<center>").append("</center>");
        stringBuilder2.insert(0, "<body>").append("</body>");
        stringBuilder2.insert(0, "<html>").append("</html>");
        JLabel jLabel3 = new JLabel(stringBuilder2.toString());
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        return jScrollPane;
    }

    private JComponent createLandInfoCard() {
        this.landInfo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.landInfo);
        return jScrollPane;
    }

    private JComponent createBrowsePanel() {
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        jPanel.add((Component)this.tabBrowser, "Center");
        return jPanel;
    }

    public void setBrowseToolBar(JToolBar jToolBar) {
        this.browsePanel.add((Component)jToolBar, "North");
    }

    private JComponent createSplitPane(JComponent jComponent, JComponent jComponent2) {
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(jComponent);
        jSplitPane.setRightComponent(jComponent2);
        jSplitPane.setOrientation(1);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(200);
        return jSplitPane;
    }

    private JComponent createStatusBar() {
        this.sysMessage.setText(Jindolf.TITLE + " " + "2.19.2" + " \u3092\u4f7f\u3063\u3066\u304f\u308c\u3066\u3042\u308a\u304c\u3068\u3046\uff01");
        this.sysMessage.setEditable(false);
        Border border = BorderFactory.createBevelBorder(1);
        Border border2 = BorderFactory.createEmptyBorder(2, 5, 2, 2);
        CompoundBorder compoundBorder = new CompoundBorder(border, border2);
        this.sysMessage.setBorder(compoundBorder);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setOrientation(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(99);
        this.progressBar.setValue(0);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.sysMessage, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        return jPanel;
    }

    public JTree getTreeView() {
        return this.landsTreeView.getTreeView();
    }

    public TabBrowser getTabBrowser() {
        return this.tabBrowser;
    }

    public LandsTree getLandsTree() {
        return this.landsTreeView;
    }

    public void setBusy(boolean bl) {
        this.progressBar.setIndeterminate(bl);
    }

    public void updateSysMessage(String string) {
        if (string == null) {
            return;
        }
        if (string.length() <= 0) {
            string = " ";
        }
        this.sysMessage.setText(string);
        GUIUtils.dispatchEmptyAWTEvent();
    }

    public void showInitPanel() {
        this.cardLayout.show(this.cards, INITCARD);
    }

    public void showVillageInfo(Village village) {
        this.tabBrowser.setVillage(village);
        this.cardLayout.show(this.cards, BROWSECARD);
        this.tabBrowser.repaint();
        this.tabBrowser.revalidate();
    }

    public void showLandInfo(Land land) {
        this.landInfo.update(land);
        this.cardLayout.show(this.cards, LANDCARD);
    }
}

