/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.ClipboardAction;
import jp.sourceforge.jindolf.FaceIconSet;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.GameSummary;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Player;
import jp.sourceforge.jindolf.TextPopup;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.WebIPCDialog;
import jp.sourceforge.jindolf.WolfBBS;
import jp.sourceforge.jindolf.core.GameRole;
import jp.sourceforge.jindolf.core.Team;

public class VillageDigest
extends JDialog
implements ActionListener,
ItemListener {
    private static final String FRAMETITLE = "\u6751\u306e\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8 - " + Jindolf.TITLE;
    private static final String ITEMDELIM = " : ";
    private final JComponent summaryPanel = this.buildSummaryPanel();
    private final JLabel faceLabel = new JLabel();
    private final ImageIcon faceIcon = new ImageIcon();
    private final JComboBox playerBox = new JComboBox();
    private final DefaultComboBoxModel playerListModel = new DefaultComboBoxModel();
    private final JButton prevPlayer = new JButton("\u2191");
    private final JButton nextPlayer = new JButton("\u2193");
    private final JLabel roleLabel = new JLabel();
    private final JLabel destinyLabel = new JLabel();
    private final JLabel specialSkillLabel = new JLabel();
    private final JLabel entryLabel = new JLabel();
    private final JLabel idLabel = new JLabel();
    private final JLabel urlLabel = new JLabel();
    private final JButton webButton = new JButton("Web");
    private final JComponent urlLine = this.buildUrlLine();
    private final JComponent playerPanel = this.buildPlayerPanel();
    private URL playerUrl;
    private final JComboBox iconSetBox = new JComboBox();
    private final DefaultComboBoxModel iconSetListModel = new DefaultComboBoxModel();
    private final JLabel authorLabel = new JLabel();
    private final JLabel authorUrlLabel = new JLabel();
    private final JButton genCastTableButton = new JButton("\u30ad\u30e3\u30b9\u30c8\u8868Wiki\u751f\u6210");
    private final JButton copyClipButton = new JButton("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc");
    private final JTextArea templateArea = new JTextArea();
    private final JButton voteButton = new JButton("\u6295\u7968Wiki\u751f\u6210");
    private final JButton vlgWikiButton = new JButton("\u6751\u8a73\u7d30Wiki\u751f\u6210");
    private final JComponent clipboardPanel = this.buildClipboardPanel();
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private Village village;
    private GameSummary gameSummary;

    private static void addCaptionedItem(Container container, CharSequence charSequence, CharSequence charSequence2, Object object) {
        LayoutManager layoutManager = container.getLayout();
        if (!(layoutManager instanceof GridBagLayout)) {
            throw new IllegalArgumentException();
        }
        JLabel jLabel = new JLabel(((Object)charSequence).toString());
        JLabel jLabel2 = new JLabel(((Object)charSequence2).toString());
        JComponent jComponent = object instanceof JComponent ? (JComponent)object : new JLabel(object.toString());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        container.add((Component)jLabel, gridBagConstraints);
        container.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        container.add((Component)jComponent, gridBagConstraints);
    }

    private static void addCaptionedItem(Container container, CharSequence charSequence, Object object) {
        VillageDigest.addCaptionedItem(container, charSequence, ITEMDELIM, object);
    }

    private static void addFatPad(Container container) {
        LayoutManager layoutManager = container.getLayout();
        if (!(layoutManager instanceof GridBagLayout)) {
            throw new IllegalArgumentException();
        }
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel, gridBagConstraints);
    }

    private static JComponent createGridBagComponent() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        return jPanel;
    }

    public VillageDigest(Frame frame) {
        super(frame, FRAMETITLE, true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                VillageDigest.this.actionClose();
            }
        });
        this.faceLabel.setIcon(this.faceIcon);
        this.playerBox.setModel(this.playerListModel);
        this.playerBox.addItemListener(this);
        this.prevPlayer.setMargin(new Insets(1, 1, 1, 1));
        this.prevPlayer.addActionListener(this);
        this.prevPlayer.setToolTipText("\u524d\u306e\u30d7\u30ec\u30a4\u30e4\u30fc");
        this.nextPlayer.setMargin(new Insets(1, 1, 1, 1));
        this.nextPlayer.addActionListener(this);
        this.nextPlayer.setToolTipText("\u6b21\u306e\u30d7\u30ec\u30a4\u30e4\u30fc");
        this.webButton.setIcon(GUIUtils.getWWWIcon());
        this.webButton.setMargin(new Insets(1, 1, 1, 1));
        this.webButton.addActionListener(this);
        this.webButton.setToolTipText("Web\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a");
        this.iconSetBox.setModel(this.iconSetListModel);
        this.iconSetBox.addItemListener(this);
        for (FaceIconSet object2 : WolfBBS.getFaceIconSetList()) {
            this.iconSetListModel.addElement(object2);
        }
        this.templateArea.setEditable(true);
        this.templateArea.setLineWrap(true);
        GUIUtils.forceMonoPitchFont(this.templateArea);
        TextPopup textPopup = new TextPopup();
        this.templateArea.setComponentPopupMenu(textPopup);
        this.genCastTableButton.addActionListener(this);
        this.voteButton.addActionListener(this);
        this.vlgWikiButton.addActionListener(this);
        this.copyClipButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        Container container = this.getContentPane();
        this.design(container);
    }

    private JComponent buildSummaryPanel() {
        JComponent jComponent = VillageDigest.createGridBagComponent();
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        jComponent.setBorder(border);
        return jComponent;
    }

    private JComponent buildUrlLine() {
        JComponent jComponent = VillageDigest.createGridBagComponent();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jComponent.add((Component)this.urlLabel, gridBagConstraints);
        jComponent.add((Component)this.webButton, gridBagConstraints);
        return jComponent;
    }

    private JComponent buildPlayerPanel() {
        JComponent jComponent = VillageDigest.createGridBagComponent();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jComponent.add((Component)this.faceLabel, gridBagConstraints);
        jComponent.add((Component)new JLabel(ITEMDELIM), gridBagConstraints);
        gridBagConstraints.anchor = 18;
        jComponent.add((Component)this.playerBox, gridBagConstraints);
        jComponent.add((Component)this.prevPlayer, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jComponent.add((Component)this.nextPlayer, gridBagConstraints);
        VillageDigest.addCaptionedItem(jComponent, "\u5f79\u8077", this.roleLabel);
        VillageDigest.addCaptionedItem(jComponent, "\u904b\u547d", this.destinyLabel);
        VillageDigest.addCaptionedItem(jComponent, "\u7279\u6b8a\u6280\u80fd", this.specialSkillLabel);
        VillageDigest.addCaptionedItem(jComponent, "\u30a8\u30f3\u30c8\u30ea#", this.entryLabel);
        VillageDigest.addCaptionedItem(jComponent, "ID", this.idLabel);
        VillageDigest.addCaptionedItem(jComponent, "URL", this.urlLine);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jComponent.add((Component)new JPanel(), gridBagConstraints);
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        jComponent.setBorder(border);
        return jComponent;
    }

    private JComponent buildCastPanel() {
        JComponent jComponent = VillageDigest.createGridBagComponent();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        VillageDigest.addCaptionedItem(jComponent, "\u9854\u30a2\u30a4\u30b3\u30f3\u30bb\u30c3\u30c8\u3092\u9078\u629e", this.iconSetBox);
        VillageDigest.addCaptionedItem(jComponent, "\u4f5c\u8005", this.authorLabel);
        VillageDigest.addCaptionedItem(jComponent, "URL", this.authorUrlLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jComponent.add((Component)this.genCastTableButton, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u30ad\u30e3\u30b9\u30c8\u8868Wiki\u751f\u6210");
        jComponent.setBorder(titledBorder);
        return jComponent;
    }

    private JComponent buildVotePanel() {
        JComponent jComponent = VillageDigest.createGridBagComponent();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jComponent.add((Component)this.voteButton, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u6295\u7968Wiki\u751f\u6210");
        jComponent.setBorder(titledBorder);
        return jComponent;
    }

    private JComponent buildVillageWikiPanel() {
        JComponent jComponent = VillageDigest.createGridBagComponent();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jComponent.add((Component)this.vlgWikiButton, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u6751\u8a73\u7d30Wiki\u751f\u6210");
        jComponent.setBorder(titledBorder);
        return jComponent;
    }

    private JComponent buildClipText() {
        JComponent jComponent = VillageDigest.createGridBagComponent();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        jComponent.add((Component)this.copyClipButton, gridBagConstraints);
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.templateArea.setBorder(border);
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setView(this.templateArea);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setMinimumSize(new Dimension(10, 50));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jComponent.add((Component)jScrollPane, gridBagConstraints);
        border = BorderFactory.createTitledBorder("PukiWiki\u30c6\u30ad\u30b9\u30c8");
        jComponent.setBorder(border);
        return jComponent;
    }

    private JComponent buildClipboardPanel() {
        JComponent jComponent = VillageDigest.createGridBagComponent();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        JComponent jComponent2 = this.buildCastPanel();
        jComponent.add((Component)jComponent2, gridBagConstraints);
        JComponent jComponent3 = this.buildVillageWikiPanel();
        jComponent.add((Component)jComponent3, gridBagConstraints);
        JComponent jComponent4 = this.buildVotePanel();
        jComponent.add((Component)jComponent4, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        JComponent jComponent5 = this.buildClipText();
        jComponent.add((Component)jComponent5, gridBagConstraints);
        return jComponent;
    }

    private void design(Container container) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getVerticalScrollBar().setUnitIncrement(15);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(15);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setView(this.summaryPanel);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(15);
        jScrollPane2.getHorizontalScrollBar().setUnitIncrement(15);
        JViewport jViewport2 = jScrollPane2.getViewport();
        jViewport2.setView(this.playerPanel);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("\u6751\u8a73\u7d30", jScrollPane);
        jTabbedPane.add("\u30d7\u30ec\u30a4\u30e4\u30fc\u8a73\u7d30", jScrollPane2);
        jTabbedPane.add("\u307e\u3068\u3081\u30b5\u30a4\u30c8\u7528Wiki\u751f\u6210", this.clipboardPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jTabbedPane, gridBagConstraints);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        container.add((Component)this.closeButton, gridBagConstraints);
    }

    private void actionClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void setVillage(Village village) {
        this.clear();
        this.village = village;
        if (village == null) {
            return;
        }
        this.gameSummary = new GameSummary(this.village);
        this.updateSummary();
        for (Player player : this.gameSummary.getPlayerList()) {
            Avatar avatar = player.getAvatar();
            this.playerListModel.addElement(avatar);
        }
        if (this.playerListModel.getSize() >= 2) {
            Player player;
            Iterator<Player> iterator = this.playerListModel.getElementAt(1);
            this.playerListModel.setSelectedItem(iterator);
            player = this.playerListModel.getElementAt(0);
            this.playerListModel.setSelectedItem(player);
        }
    }

    private void updateSummary() {
        CharSequence charSequence;
        Object object;
        CharSequence charSequence2;
        List<Player> list;
        Object object22;
        String string = this.village.getVillageFullName();
        Team team = this.gameSummary.getWinnerTeam();
        String string2 = team.getTeamName();
        int n = this.gameSummary.countAvatarNum();
        String string3 = "\u30b2\u30eb\u30c8 + " + (n - 1) + "\u540d = " + n + "\u540d";
        JComponent jComponent = VillageDigest.createGridBagComponent();
        for (Object object22 : GameRole.values()) {
            list = this.gameSummary.getRoledPlayerList((GameRole)((Object)object22));
            if (list.size() <= 0) continue;
            String n2 = object22.getRoleName();
            VillageDigest.addCaptionedItem(jComponent, n2, " \u00d7 ", list.size());
        }
        String string4 = this.gameSummary.countSuddenDeath() + "\u540d";
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        Date date = this.gameSummary.get1stTalkDate();
        object22 = dateFormat.format(date);
        date = this.gameSummary.getLastTalkDate();
        list = dateFormat.format(date);
        int n2 = this.village.getLimitHour();
        int n3 = this.village.getLimitMinute();
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2).append(':');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        JComponent jComponent2 = VillageDigest.createGridBagComponent();
        for (int stringBuilder2 = 1; stringBuilder2 < this.village.getPeriodSize(); ++stringBuilder2) {
            List<Player> n4 = this.gameSummary.getSurvivorList(stringBuilder2);
            charSequence2 = GameSummary.getRoleBalanceSequence(n4);
            object = this.village.getPeriod(stringBuilder2);
            charSequence = ((Period)object).getCaption();
            VillageDigest.addCaptionedItem(jComponent2, charSequence, charSequence2);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        int n4 = this.village.getProgressDays();
        stringBuilder2.append("\u30d7\u30ed\u30ed\u30fc\u30b0 + ").append(n4).append("\u65e5 + \u30a8\u30d4\u30ed\u30fc\u30b0");
        charSequence2 = this.gameSummary.dumpExecutionInfo();
        charSequence = this.gameSummary.dumpAssaultInfo();
        object = this.gameSummary.dumpSeerActivity();
        CharSequence charSequence3 = this.gameSummary.dumpHunterActivity();
        this.summaryPanel.removeAll();
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u6751\u540d", string);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u52dd\u8005", string2);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u6240\u8981\u65e5\u6570", stringBuilder2);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u66f4\u65b0\u6642\u523b", stringBuilder);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u767a\u8a00\u958b\u59cb", object22);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u6700\u7d42\u767a\u8a00", list);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u53c2\u52a0\u4eba\u6570", string3);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u5f79\u8077\u5185\u8a33", jComponent);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u51e6\u5211\u5185\u8a33", charSequence2);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u8972\u6483\u5185\u8a33", charSequence);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u7a81\u7136\u6b7b", string4);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u4eba\u53e3\u63a8\u79fb", jComponent2);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u5360\u6210\u7e3e", object);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u72e9\u6210\u7e3e", charSequence3);
        VillageDigest.addFatPad(this.summaryPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.actionClose();
        } else if (object == this.webButton) {
            this.actionWebAccess();
        } else if (object == this.copyClipButton) {
            this.actionCopyToClipboard();
        } else if (object == this.genCastTableButton) {
            this.actionGenCastTable();
        } else if (object == this.voteButton) {
            this.actionGenVoteBox();
        } else if (object == this.vlgWikiButton) {
            this.actionGenVillageWiki();
        } else if (object == this.prevPlayer) {
            int n = this.playerBox.getSelectedIndex();
            if (n <= 0) {
                return;
            }
            this.playerBox.setSelectedIndex(--n);
        } else if (object == this.nextPlayer) {
            int n;
            int n2 = this.playerBox.getSelectedIndex();
            if (n2 >= (n = this.playerBox.getItemCount()) - 1) {
                return;
            }
            this.playerBox.setSelectedIndex(++n2);
        }
    }

    private void actionGenCastTable() {
        Object object = this.iconSetListModel.getSelectedItem();
        if (object == null || !(object instanceof FaceIconSet)) {
            return;
        }
        FaceIconSet faceIconSet = (FaceIconSet)object;
        CharSequence charSequence = this.gameSummary.dumpCastingBoard(faceIconSet);
        this.putWikiText(charSequence);
    }

    private void actionGenVoteBox() {
        CharSequence charSequence = this.gameSummary.dumpVoteBox();
        this.putWikiText(charSequence);
    }

    private void actionGenVillageWiki() {
        CharSequence charSequence = this.gameSummary.dumpVillageWiki();
        this.putWikiText(charSequence);
    }

    private void putWikiText(CharSequence charSequence) {
        this.templateArea.setText(((Object)charSequence).toString());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VillageDigest.this.templateArea.scrollRectToVisible(new Rectangle());
            }
        });
    }

    private void actionCopyToClipboard() {
        String string = this.templateArea.getText();
        ClipboardAction.copyToClipboard(string);
    }

    private void actionWebAccess() {
        Object object = this.playerBox.getSelectedItem();
        if (object == null || !(object instanceof Avatar)) {
            return;
        }
        String string = this.playerUrl.toString();
        if (string == null || string.length() <= 0) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        Frame frame = null;
        if (window instanceof Frame) {
            frame = (Frame)window;
        }
        WebIPCDialog.showDialog(frame, string);
    }

    private void selectPlayer(Avatar avatar) {
        if (avatar == this.playerBox.getItemAt(0)) {
            this.prevPlayer.setEnabled(false);
        } else {
            this.prevPlayer.setEnabled(true);
        }
        int n = this.playerBox.getItemCount();
        if (avatar == this.playerBox.getItemAt(n - 1)) {
            this.nextPlayer.setEnabled(false);
        } else {
            this.nextPlayer.setEnabled(true);
        }
        Image image = this.village.getAvatarFaceImage(avatar);
        this.faceIcon.setImage(image);
        this.faceLabel.setIcon(null);
        this.faceLabel.setIcon(this.faceIcon);
        Player player = this.gameSummary.getPlayer(avatar);
        GameRole gameRole = player.getRole();
        this.roleLabel.setText(gameRole.getRoleName());
        String string = player.getDestinyMessage();
        this.destinyLabel.setText(string);
        CharSequence charSequence = "";
        switch (gameRole) {
            case SEER: {
                charSequence = this.gameSummary.dumpSeerActivity();
                break;
            }
            case HUNTER: {
                charSequence = this.gameSummary.dumpHunterActivity();
                break;
            }
        }
        this.specialSkillLabel.setText(charSequence.toString());
        this.entryLabel.setText("" + player.getEntryNo());
        String string2 = player.getIdName();
        this.idLabel.setText(string2);
        String string3 = player.getUrlText();
        if (string3 == null || string3.length() <= 0) {
            string3 = WolfBBS.encodeURLFromId(string2);
            this.urlLabel.setText("\u3082\u3057\u304b\u3057\u3066 " + string3);
        } else {
            this.urlLabel.setText(string3);
        }
        try {
            this.playerUrl = new URL(string3);
            this.webButton.setVisible(true);
        }
        catch (MalformedURLException malformedURLException) {
            this.playerUrl = null;
            this.webButton.setVisible(false);
        }
    }

    private void selectIconSet(FaceIconSet faceIconSet) {
        String string = faceIconSet.getAuthor();
        String string2 = faceIconSet.getUrlText();
        this.authorLabel.setText(string + "\u6c0f");
        this.authorUrlLabel.setText(string2);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (n != 1) {
            return;
        }
        Object object = itemEvent.getSource();
        Object object2 = itemEvent.getItem();
        if (object2 == null) {
            return;
        }
        if (object == this.playerBox) {
            if (!(object2 instanceof Avatar)) {
                return;
            }
            Avatar avatar = (Avatar)object2;
            this.selectPlayer(avatar);
        } else if (object == this.iconSetBox) {
            if (!(object2 instanceof FaceIconSet)) {
                return;
            }
            FaceIconSet faceIconSet = (FaceIconSet)object2;
            this.selectIconSet(faceIconSet);
        }
    }

    private void clear() {
        this.templateArea.setText("");
        this.playerListModel.removeAllElements();
    }
}

