/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import jp.sourceforge.jindolf.core.LandState;
import jp.sourceforge.jindolf.core.SchemaUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LandDef {
    private static final String SCHEMA_LANDDEF = "http://jindolf.sourceforge.jp/xml/xsd/coreXML.xsd";
    private static final String RES_LANDDEF = "resources/xml/landDefList.xml";
    private static final List<LandDef> unmodList;
    private static final Pattern iso8601Regex;
    public static final Date DATE_UNKNOWN;
    private final String landName;
    private final String landId;
    private final String formalName;
    private final String landPrefix;
    private final LandState landState;
    private final int minMembers;
    private final int maxMembers;
    private final URI webURI;
    private final URI cgiURI;
    private final URI tombFaceIconURI;
    private final URI tombBodyIconURI;
    private final String faceURITemplate;
    private final String bodyURITemplate;
    private final Locale locale;
    private final Charset encoding;
    private final TimeZone timeZone;
    private final Date startDate;
    private final Date endDate;
    private final String description;
    private final String contactInfo;
    private final SortedSet<Integer> invalidSet;

    public static Element loadLandInfoList(DocumentBuilder documentBuilder) throws ParserConfigurationException, IOException, SAXException {
        InputStream inputStream = LandDef.class.getResourceAsStream(RES_LANDDEF);
        Document document = documentBuilder.parse(inputStream);
        Element element = document.getDocumentElement();
        String string = element.getTagName();
        if (!string.equals("landDefList")) {
            throw new SAXException("illegal root " + string);
        }
        return element;
    }

    private static List<LandDef> registLandInfoList(Element element) throws SAXException {
        NodeList nodeList = element.getElementsByTagName("landDef");
        int n = nodeList.getLength();
        if (n <= 0) {
            throw new SAXException("there is no <landDef>");
        }
        ArrayList<LandDef> arrayList = new ArrayList<LandDef>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Element element2 = (Element)node;
            LandDef landDef = LandDef.buildLandDef(element2);
            arrayList.add(landDef);
        }
        return arrayList;
    }

    private static LandDef buildLandDef(Element element) throws SAXException {
        LandDef landDef;
        URI uRI;
        URI uRI2;
        URI uRI3;
        URI uRI4;
        LandState landState;
        String string = element.getAttributeNode("landName").getValue();
        String string2 = element.getAttributeNode("landId").getValue();
        String string3 = element.getAttributeNode("formalName").getValue();
        String string4 = element.getAttributeNode("landPrefix").getValue();
        String string5 = element.getAttributeNode("landState").getValue();
        if (string5.equals("closed")) {
            landState = LandState.CLOSED;
        } else if (string5.equals("historical")) {
            landState = LandState.HISTORICAL;
        } else if (string5.equals("active")) {
            landState = LandState.ACTIVE;
        } else {
            throw new SAXException("illegal land status");
        }
        string5 = element.getAttributeNode("minMembers").getValue();
        int n = Integer.parseInt(string5);
        string5 = element.getAttributeNode("maxMembers").getValue();
        int n2 = Integer.parseInt(string5);
        try {
            string5 = element.getAttributeNode("webURI").getValue();
            uRI4 = new URI(string5);
            string5 = element.getAttributeNode("cgiURI").getValue();
            uRI3 = new URI(string5);
            string5 = element.getAttributeNode("tombFaceIconURI").getValue();
            uRI2 = new URI(string5);
            string5 = element.getAttributeNode("tombBodyIconURI").getValue();
            uRI = new URI(string5);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SAXException("illegal URI", uRISyntaxException);
        }
        String string6 = null;
        String string7 = null;
        Attr attr = element.getAttributeNode("faceIconURITemplate");
        if (attr != null) {
            string6 = attr.getValue();
        }
        if ((attr = element.getAttributeNode("bodyIconURITemplate")) != null) {
            string7 = attr.getValue();
        }
        String string8 = "";
        String string9 = "";
        String string10 = "";
        string5 = element.getAttributeNode("locale").getValue();
        String[] stringArray = string5.split("-", 3);
        if (stringArray.length >= 1) {
            string8 = stringArray[0];
        }
        if (stringArray.length >= 2) {
            string9 = stringArray[1];
        }
        if (stringArray.length >= 3) {
            string10 = stringArray[2];
        }
        Locale locale = new Locale(string8, string9, string10);
        string5 = element.getAttributeNode("encoding").getValue();
        Charset charset = Charset.forName(string5);
        string5 = element.getAttributeNode("timeZone").getValue();
        TimeZone timeZone = TimeZone.getTimeZone(string5);
        String string11 = element.getAttributeNode("startDate").getValue();
        Calendar calendar = LandDef.parseISO8601(string11);
        Date date = calendar.getTime();
        string11 = element.getAttribute("endDate");
        Date date2 = null;
        if (string11 != null && string11.length() > 0) {
            calendar = LandDef.parseISO8601(string11);
            date2 = calendar.getTime();
        }
        String string12 = element.getAttributeNode("description").getValue();
        String string13 = element.getAttributeNode("contactInfo").getValue();
        String string14 = element.getAttribute("invalidVid");
        SortedSet<Integer> sortedSet = LandDef.parseIntList(string14);
        try {
            landDef = new LandDef(string, string2, string3, string4, landState, n, n2, uRI4, uRI3, uRI2, uRI, string6, string7, locale, charset, timeZone, date, date2, string12, string13, sortedSet);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        return landDef;
    }

    private static SortedSet<Integer> parseIntList(CharSequence charSequence) throws NullPointerException {
        String[] stringArray;
        Pattern pattern = Pattern.compile("[, \\t]+");
        Pattern pattern2 = Pattern.compile("[ \\t]*\\-[ \\t]*");
        if (charSequence == null) {
            throw new NullPointerException();
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        SortedSet<Integer> sortedSet = Collections.unmodifiableSortedSet(treeSet);
        if (charSequence.length() <= 0) {
            return sortedSet;
        }
        for (String string : stringArray = pattern.split(charSequence)) {
            int n;
            int n2;
            int n3;
            if (string == null || string.length() <= 0) continue;
            String[] stringArray2 = pattern2.split(string);
            if (stringArray2.length >= 3) {
                throw new IllegalArgumentException(string);
            }
            try {
                n3 = Integer.parseInt(stringArray2[0]);
                n2 = stringArray2.length >= 2 ? Integer.parseInt(stringArray2[1]) : n3;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string, numberFormatException);
            }
            if (n3 > n2) {
                n = n3;
                n3 = n2;
                n2 = n;
                assert (n3 <= n2);
            }
            for (n = n3; n <= n2; ++n) {
                treeSet.add(n);
            }
        }
        return sortedSet;
    }

    private static Calendar parseISO8601(CharSequence charSequence) throws IllegalArgumentException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Matcher matcher = iso8601Regex.matcher(charSequence);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException(((Object)charSequence).toString());
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        String string4 = matcher.group(4);
        String string5 = matcher.group(5);
        String string6 = matcher.group(6);
        String string7 = matcher.group(7);
        try {
            n6 = Integer.parseInt(string);
            n5 = Integer.parseInt(string2);
            n4 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n2 = Integer.parseInt(string5);
            n = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(((Object)charSequence).toString(), numberFormatException);
        }
        String string8 = "GMT";
        string8 = string7.compareToIgnoreCase("Z") == 0 ? string8 + "+00:00" : string8 + string7;
        TimeZone timeZone = TimeZone.getTimeZone(string8);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.set(n6, n5 - 1, n4, n3, n2, n);
        return gregorianCalendar;
    }

    private static void checkNull(Object object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    private static void checkEmpty(CharSequence charSequence) throws IllegalArgumentException {
        LandDef.checkNull(charSequence);
        if (charSequence.length() <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public static List<LandDef> getLandDefList() {
        return unmodList;
    }

    private LandDef(String string, String string2, String string3, String string4, LandState landState, int n, int n2, URI uRI, URI uRI2, URI uRI3, URI uRI4, String string5, String string6, Locale locale, Charset charset, TimeZone timeZone, Date date, Date date2, String string7, String string8, SortedSet<Integer> sortedSet) {
        LandDef.checkEmpty(string);
        LandDef.checkEmpty(string2);
        LandDef.checkEmpty(string3);
        LandDef.checkNull(string4);
        LandDef.checkNull((Object)landState);
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < n) {
            throw new IllegalArgumentException();
        }
        LandDef.checkNull(uRI);
        LandDef.checkNull(uRI2);
        LandDef.checkNull(uRI3);
        LandDef.checkNull(uRI4);
        LandDef.checkNull(locale);
        LandDef.checkNull(charset);
        LandDef.checkNull(timeZone);
        LandDef.checkNull(date);
        if (date2 == null) {
            date2 = DATE_UNKNOWN;
        }
        LandDef.checkEmpty(string7);
        LandDef.checkEmpty(string8);
        LandDef.checkNull(sortedSet);
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (!uRI2.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        this.landName = string;
        this.landId = string2;
        this.formalName = string3;
        this.landPrefix = string4;
        this.landState = landState;
        this.minMembers = n;
        this.maxMembers = n2;
        this.webURI = uRI;
        this.cgiURI = uRI2;
        this.tombFaceIconURI = uRI3;
        this.tombBodyIconURI = uRI4;
        this.faceURITemplate = string5;
        this.bodyURITemplate = string6;
        this.locale = locale;
        this.encoding = charset;
        this.timeZone = timeZone;
        this.startDate = date;
        this.endDate = date2;
        this.description = string7;
        this.contactInfo = string8;
        this.invalidSet = sortedSet;
    }

    public String getLandName() {
        return this.landName;
    }

    public String getLandId() {
        return this.landId;
    }

    public String getFormalName() {
        return this.formalName;
    }

    public String getLandPrefix() {
        return this.landPrefix;
    }

    public LandState getLandState() {
        return this.landState;
    }

    public int getMinMembers() {
        return this.minMembers;
    }

    public int getMaxMembers() {
        return this.maxMembers;
    }

    public URI getWebURI() {
        return this.webURI;
    }

    public URI getCgiURI() {
        return this.cgiURI;
    }

    public URI getTombFaceIconURI() {
        return this.tombFaceIconURI;
    }

    public URI getTombBodyIconURI() {
        return this.tombBodyIconURI;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public TimeZone getTimeZone() {
        TimeZone timeZone = (TimeZone)this.timeZone.clone();
        return timeZone;
    }

    public Date getStartDate() {
        Date date = (Date)this.startDate.clone();
        return date;
    }

    public Date getEndDate() {
        Date date = (Date)this.endDate.clone();
        return date;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public boolean isValidVillageId(int n) {
        return !this.invalidSet.contains(n);
    }

    static {
        DocumentBuilder documentBuilder;
        Object object;
        DATE_UNKNOWN = new Date(-1L);
        String string = "([0-9][0-9][0-9][0-9])";
        String string2 = "([0-1][0-9])";
        String string3 = "([0-3][0-9])";
        String string4 = "([0-2][0-9])";
        String string5 = "([0-5][0-9])";
        String string6 = "([0-6][0-9])";
        String string7 = "([\\+\\-][0-2][0-9](?::?[0-5][0-9])?|Z)";
        String string8 = string + "\\-" + string2 + "\\-" + string3 + "T" + string4 + ":" + string5 + ":" + string6 + string7;
        iso8601Regex = Pattern.compile(string8);
        try {
            object = SchemaUtilities.createSchema(SCHEMA_LANDDEF);
            documentBuilder = SchemaUtilities.createBuilder((Schema)object);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        try {
            Element element = LandDef.loadLandInfoList(documentBuilder);
            object = LandDef.registLandInfoList(element);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        unmodList = Collections.unmodifiableList(object);
    }
}

