/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import jp.sourceforge.jindolf.core.SchemaUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreDefAvatar {
    private static final String SCHEMA_AVATARDEF = "http://jindolf.sourceforge.jp/xml/xsd/coreXML.xsd";
    private static final String RES_AVATARDEF = "resources/xml/preDefAvatarList.xml";
    private static final String faceURITemplate;
    private static final String bodyURITemplate;
    private static final List<PreDefAvatar> unmodList;
    private static final Map<String, PreDefAvatar> unmodMap;
    private final String avatarId;
    private final String fullName;
    private final String jobTitle;
    private final String shortName;
    private final int serialNo;
    private final URI faceIconURI;
    private final URI bodyIconURI;

    public static Element loadAvatarList(DocumentBuilder documentBuilder) throws ParserConfigurationException, IOException, SAXException {
        InputStream inputStream = PreDefAvatar.class.getResourceAsStream(RES_AVATARDEF);
        Document document = documentBuilder.parse(inputStream);
        Element element = document.getDocumentElement();
        String string = element.getTagName();
        if (!string.equals("preDefinedAvatarList")) {
            throw new SAXException("illegal root " + string);
        }
        return element;
    }

    private static List<PreDefAvatar> registAvatarList(Element element) throws SAXException {
        NodeList nodeList = element.getElementsByTagName("preDefinedAvatar");
        int n = nodeList.getLength();
        if (n <= 0) {
            throw new SAXException("there is no <preDefinedAvatar>");
        }
        ArrayList<PreDefAvatar> arrayList = new ArrayList<PreDefAvatar>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Element element2 = (Element)node;
            PreDefAvatar preDefAvatar = PreDefAvatar.buildAvatar(element2);
            arrayList.add(preDefAvatar);
        }
        return arrayList;
    }

    private static PreDefAvatar buildAvatar(Element element) throws SAXException {
        PreDefAvatar preDefAvatar;
        int n;
        String string = element.getAttribute("avatarId");
        String string2 = element.getAttribute("jobTitle");
        String string3 = element.getAttribute("shortName");
        String string4 = element.getAttribute("serialNum");
        String string5 = string2 + " " + string3;
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("illegal number form", numberFormatException);
        }
        try {
            preDefAvatar = new PreDefAvatar(string, string5, string2, string3, n);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SAXException("illegal URL", uRISyntaxException);
        }
        return preDefAvatar;
    }

    public static List<PreDefAvatar> getPreDefAvatarList() {
        return unmodList;
    }

    public static Map<String, PreDefAvatar> getAvatarIdMap() {
        return unmodMap;
    }

    public static PreDefAvatar getPreDefAvatar(String string) {
        PreDefAvatar preDefAvatar = unmodMap.get(string);
        return preDefAvatar;
    }

    private PreDefAvatar(String string, String string2, String string3, String string4, int n) throws URISyntaxException {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new NullPointerException();
        }
        this.avatarId = string.intern();
        this.fullName = string2.intern();
        this.jobTitle = string3.intern();
        this.shortName = string4.intern();
        this.serialNo = n;
        String string5 = MessageFormat.format(faceURITemplate, this.serialNo);
        this.faceIconURI = new URI(string5);
        string5 = MessageFormat.format(bodyURITemplate, this.serialNo);
        this.bodyIconURI = new URI(string5);
    }

    public String getAvatarId() {
        return this.avatarId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getSerialNo() {
        return this.serialNo;
    }

    public URI getFaceIconURI() {
        return this.faceIconURI;
    }

    public URI getBodyIconURI() {
        return this.bodyIconURI;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getAvatarId()).append(' ');
        stringBuilder.append(this.getFullName()).append(' ');
        stringBuilder.append(this.getJobTitle()).append(' ');
        stringBuilder.append(this.getShortName()).append(' ');
        stringBuilder.append(this.getSerialNo()).append(' ');
        stringBuilder.append(this.getFaceIconURI()).append(' ');
        stringBuilder.append(this.getBodyIconURI());
        return stringBuilder.toString();
    }

    static {
        Object object;
        DocumentBuilder documentBuilder;
        Object object2;
        try {
            object2 = SchemaUtilities.createSchema(SCHEMA_AVATARDEF);
            documentBuilder = SchemaUtilities.createBuilder((Schema)object2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        try {
            object = PreDefAvatar.loadAvatarList(documentBuilder);
            faceURITemplate = object.getAttribute("faceIconURITemplate");
            bodyURITemplate = object.getAttribute("bodyIconURITemplate");
            if (faceURITemplate == null || bodyURITemplate == null) {
                throw new SAXException("no *URITemplate attribute");
            }
            object2 = PreDefAvatar.registAvatarList((Element)object);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        object = new HashMap();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            PreDefAvatar preDefAvatar = (PreDefAvatar)iterator.next();
            String string = preDefAvatar.getAvatarId();
            object.put(string, preDefAvatar);
        }
        unmodList = Collections.unmodifiableList(object2);
        unmodMap = Collections.unmodifiableMap(object);
    }
}

