/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import jp.sourceforge.jindolf.core.XmlResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaUtilities {
    public static Schema createSchema(String string) throws URISyntaxException, IOException, SAXException {
        XmlResourceResolver xmlResourceResolver = new XmlResourceResolver();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(xmlResourceResolver);
        schemaFactory.setErrorHandler(new StrictHandler());
        InputStream inputStream = xmlResourceResolver.getXMLResourceAsStream(string);
        StreamSource streamSource = new StreamSource(inputStream);
        Schema schema = schemaFactory.newSchema(streamSource);
        return schema;
    }

    public static DocumentBuilder createBuilder(Schema schema) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setSchema(schema);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        StrictHandler strictHandler = new StrictHandler();
        documentBuilder.setErrorHandler(strictHandler);
        XmlResourceResolver xmlResourceResolver = new XmlResourceResolver();
        documentBuilder.setEntityResolver(xmlResourceResolver);
        return documentBuilder;
    }

    private SchemaUtilities() {
    }

    public static class StrictHandler
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

