/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlResourceResolver
implements LSResourceResolver,
EntityResolver {
    protected static final Map<URL, URL> defaultMap;
    protected static final URI emptyURI;
    private Map<URL, URL> uriMap = defaultMap;

    protected static URL buildBaseRelativeURL(String string, String string2) throws URISyntaxException, MalformedURLException, IllegalArgumentException {
        URI uRI;
        URI uRI2 = null;
        if (string != null && !(uRI2 = new URI(string)).isAbsolute()) {
            throw new IllegalArgumentException();
        }
        URI uRI3 = emptyURI;
        if (string2 != null) {
            uRI3 = new URI(string2);
        }
        if (!(uRI = uRI2 == null || uRI3.isAbsolute() ? uRI3 : uRI2.resolve(uRI3)).isAbsolute()) {
            throw new IllegalArgumentException();
        }
        URL uRL = uRI.normalize().toURL();
        return uRL;
    }

    public static Map<URL, URL> getDefaultTxMap() {
        return defaultMap;
    }

    public static LSInput createLSInput() {
        LSInputImpl lSInputImpl = new LSInputImpl();
        return lSInputImpl;
    }

    public Map<URL, URL> getTxMap() {
        return this.uriMap;
    }

    public Map<URL, URL> setTxMap(Map<URL, URL> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        Map<URL, URL> map2 = this.uriMap;
        this.uriMap = map;
        return map2;
    }

    public InputStream getXMLResourceAsStream(String string) throws URISyntaxException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        URI uRI = new URI(string);
        InputStream inputStream = this.getXMLResourceAsStream(uRI);
        return inputStream;
    }

    public InputStream getXMLResourceAsStream(URI uRI) throws IOException {
        if (uRI == null) {
            throw new NullPointerException();
        }
        URL uRL = uRI.normalize().toURL();
        InputStream inputStream = this.getXMLResourceAsStream(uRL);
        return inputStream;
    }

    protected InputStream getXMLResourceAsStream(URL uRL) throws IOException {
        if (uRL == null) {
            throw new NullPointerException();
        }
        URL uRL2 = this.uriMap.get(uRL);
        InputStream inputStream = uRL2.openStream();
        return inputStream;
    }

    @Override
    public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
        InputStream inputStream;
        URL uRL;
        if (string4 == null) {
            return null;
        }
        try {
            uRL = XmlResourceResolver.buildBaseRelativeURL(string5, string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        try {
            inputStream = this.getXMLResourceAsStream(uRL);
        }
        catch (IOException iOException) {
            return null;
        }
        LSInput lSInput = XmlResourceResolver.createLSInput();
        lSInput.setBaseURI(string5);
        lSInput.setPublicId(string3);
        lSInput.setSystemId(string4);
        lSInput.setByteStream(inputStream);
        return lSInput;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        URI uRI;
        if (string2 == null) {
            return null;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        URL uRL = uRI.normalize().toURL();
        InputStream inputStream = this.getXMLResourceAsStream(uRL);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setPublicId(string);
        inputSource.setSystemId(string2);
        return inputSource;
    }

    static {
        emptyURI = URI.create("");
        String[][] stringArrayArray = new String[][]{{"http://www.w3.org/2001/xml.xsd", "resources/xsd/ext/xml-2009-01.xsd"}, {"http://jindolf.sourceforge.jp/xml/xsd/coreType.xsd", "resources/xsd/coreType.xsd"}, {"http://jindolf.sourceforge.jp/xml/xsd/coreXML.xsd", "resources/xsd/coreXML.xsd"}};
        HashMap<URL, URL> hashMap = new HashMap<URL, URL>();
        for (String[] stringArray : stringArrayArray) {
            URL uRL;
            String string = stringArray[0];
            String string2 = stringArray[1];
            try {
                uRL = new URI(string).normalize().toURL();
            }
            catch (MalformedURLException uRISyntaxException) {
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            URL uRL2 = XmlResourceResolver.class.getResource(string2);
            hashMap.put(uRL, uRL2);
        }
        defaultMap = Collections.unmodifiableMap(hashMap);
        try {
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassNotFoundException instantiationException) {
            throw new ExceptionInInitializerError(instantiationException);
        }
        catch (InstantiationException illegalAccessException) {
            throw new ExceptionInInitializerError(illegalAccessException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExceptionInInitializerError(illegalAccessException);
        }
    }

    public static class LSInputImpl
    implements LSInput {
        private String baseURI = null;
        private InputStream byteStream = null;
        private boolean certifiedText = false;
        private Reader characterStream = null;
        private String encoding = null;
        private String publicId = null;
        private String stringData = null;
        private String systemId = null;

        public String getBaseURI() {
            return this.baseURI;
        }

        public void setBaseURI(String string) {
            this.baseURI = string;
        }

        public InputStream getByteStream() {
            return this.byteStream;
        }

        public void setByteStream(InputStream inputStream) {
            this.byteStream = inputStream;
        }

        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        public void setCertifiedText(boolean bl) {
            this.certifiedText = bl;
        }

        public Reader getCharacterStream() {
            return this.characterStream;
        }

        public void setCharacterStream(Reader reader) {
            this.characterStream = reader;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String string) {
            this.encoding = string;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public void setPublicId(String string) {
            this.publicId = string;
        }

        public String getStringData() {
            return this.stringData;
        }

        public void setStringData(String string) {
            this.stringData = string;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void setSystemId(String string) {
            this.systemId = string;
        }
    }
}

