/*
 * Destiny
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: Destiny.java 467 2009-04-24 14:47:44Z olyutorskii $
 */

package jp.sourceforge.jindolf.core;

/**
 * プレイヤーの死因・運命
 */
public enum Destiny{

    /** 突然死 */
    SUDDENDEATH("突然死"),
    /** 処刑死 */
    EXECUTED("処刑死"),
    /** 襲撃死 */
    EATEN("襲撃死"),
    /** 生存 */
    ALIVE("生存"),
    ;

    private final String message;

    /**
     * コンストラクタ
     * @param message 死因メッセージ
     */
    private Destiny(String message){
        this.message = message;
        return;
    }

    /**
     * 死因メッセージを取得する
     * @return 死因文字列
     */
    public String getMessage(){
        return this.message;
    }

    // TODO ハム溶け追加
}
