/*
 * pre-defined avatar test
 *
 * $Id: PreDefAvatarTest.java 501 2009-04-29 06:10:53Z olyutorskii $
 */

package jp.sourceforge.jindolf.core;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;
import org.w3c.dom.Element;

/**
 */
public class PreDefAvatarTest {

    public PreDefAvatarTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception{
    }

    @AfterClass
    public static void tearDownClass() throws Exception{
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of loadAvatarList method, of class PreDefAvatar.
     */
    @Test
    public void testLoadAvatarList() throws Exception{
        System.out.println("loadAvatarList");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Element result = PreDefAvatar.loadAvatarList(builder);
        assertNotNull(result);
        assertEquals("preDefinedAvatarList", result.getTagName());

        return;
    }

    /**
     * Test of getPreDefAvatarList method, of class PreDefAvatar.
     */
    @Test
    public void testGetPreDefAvatarList(){
        System.out.println("getPreDefAvatarList");
        List<PreDefAvatar> result = PreDefAvatar.getPreDefAvatarList();
        assertEquals(20, result.size());

        return;
    }

    /**
     * Test of getAvatarIdMap method, of class PreDefAvatar.
     */
    @Test
    public void testGetAvatarIdMap(){
        System.out.println("getAvatarIdMap");
        Map<String, PreDefAvatar> expResult = null;
        Map<String, PreDefAvatar> result = PreDefAvatar.getAvatarIdMap();
        assertEquals("gerd", result.get("gerd").getAvatarId());

        return;
    }

    /**
     * Test of getPreDefAvatar method, of class PreDefAvatar.
     */
    @Test
    public void testGetPreDefAvatar(){
        System.out.println("getPreDefAvatar");
        PreDefAvatar result;

        result = PreDefAvatar.getPreDefAvatar("gerd");
        assertNotNull(result);
        assertEquals("gerd", result.getAvatarId());
        assertEquals("楽天家 ゲルト", result.getFullName());
        assertEquals("楽天家", result.getJobTitle());
        assertEquals("ゲルト", result.getShortName());
        assertEquals(URI.create("./plugin_wolf/img/face01.jpg"),
                     result.getFaceIconURI());
        assertEquals(URI.create("./plugin_wolf/img/body01.jpg"),
                     result.getBodyIconURI());
        assertEquals(1, result.getSerialNo());

        return;
    }

}
