#!/bin/sh
#
#     JinCore [ http://sourceforge.jp/projects/jindolf ]
#
# This is JinCore build script for sh on UNIX.
# This will build jincore.jar from Java sources.
# You need SunJDK-1.5 compatible or later.
#
# Copyright(c) 2009 olyutorskii
# $Id: build.sh 531 2009-06-01 17:03:08Z olyutorskii $


JAVAC="/usr/bin/javac"
JAR="/usr/bin/jar"


JARFILE=jincore.jar
MANIFTMPL=manifest.mf

SRCPATH=./src
BLDPATH=./build
DISTPATH=./dist

PKGDIR=jp/sourceforge/jindolf/core
RESDIR=${PKGDIR}/resources


rm -fR ${BLDPATH}/
mkdir ${BLDPATH}/

rm -fR ${DISTPATH}/
mkdir ${DISTPATH}/


LANGSPEC="-Xlint -deprecation -source 5 -encoding UTF-8"
CODEGEN="-target 5"
PATHASSIGN="-sourcepath ${SRCPATH}/ -d ${BLDPATH}/"
${JAVAC} ${LANGSPEC} ${CODEGEN} ${PATHASSIGN} ${SRCPATH}/${PKGDIR}/*.java


mkdir ${BLDPATH}/${RESDIR}/
cp -R ${SRCPATH}/${RESDIR}/ ${BLDPATH}/${RESDIR}/


${JAR} cmf ${MANIFTMPL} ${DISTPATH}/${JARFILE} -C ${BLDPATH}/ ./


# --- EOF ---
