/*
 * village tag-name
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: VillageTag.java 647 2009-08-09 05:30:09Z olyutorskii $
 */

package jp.sourceforge.jindolf.corelib;

import java.util.HashMap;
import java.util.Map;

/**
 * 村名一覧
 */
public enum VillageTag{

    HEIBON        ("平凡な村"),
    HOSHIKARI     ("星狩りの村"),
    HINOSASANU    ("日の差さぬ村"),
    KAKUSARETA    ("隠された村"),
    HINOSHIZUMANU ("日の沈まぬ村"),
    KIEYUKU       ("消え行く村"),
    AYASHIGE      ("怪しげな村"),
    YAMAKAGE      ("山影の村"),
    HEIWA         ("平和な村"),
    USOTSUKI      ("嘘つきの村"),
    KANASHIMI     ("悲しみの村"),
    OSOROSHII     ("恐ろしい村"),
    BONCHI        ("盆地の村"),
    MABOROSHI     ("幻の村"),
    BOURYAKU      ("謀略の村"),
    SAIHATE       ("最果ての村"),
    HUUIN         ("封印の村"),
    UMIBE         ("海辺の村"),
    KAITAKUSHA    ("開拓者の村"),
    DANGAI        ("断崖の村"),
    DEAI          ("出会いの村"),
    HUMOTO        ("ふもとの村"),
    TOUGE         ("峠の村"),
    CHINURARETA   ("血塗られた村"),
    HEKICHI       ("僻地の村"),
    YASURAGI      ("安らぎの村"),
    SAIGO         ("最後の村"),
    GISHINANKI    ("疑心暗鬼の村"),
    NOROWARETA    ("呪われた村"),
    SHINRYOKU     ("新緑の村"),
    ARECHI        ("荒地の村"),
    NOKOSARETA    ("残された村"),
    CHIISANA      ("小さな村"),
    GOKUKAN       ("極寒の村"),
    MISUTERARETA  ("見捨てられた村"),
    KIBOU         ("希望の村"),
    URAGIRI       ("裏切りの村"),
    CHINMOKU      ("沈黙の村"),
    AMENOYAMANU   ("雨の止まぬ村"),
    HENKYOU       ("辺境の村"),
    WASURERARETA  ("忘れられた村"),
    TANIZOKO      ("谷底の村"),
    ;

    private static final Map<String, VillageTag> tagMap =
            new HashMap<String, VillageTag>();
    private static final VillageTag[] values = values();
    private static final int enumCount = values().length;

    static{
        for(VillageTag vtag : values){
            String tagName = vtag.getTagName();
            tagMap.put(tagName, vtag);
        }
    }

    /**
     * 村名からEnumメンバを得る。
     * @param tagName 村名
     * @return Enumメンバ
     */
    public static VillageTag tagNameToVillageTag(String tagName){
        VillageTag result = tagMap.get(tagName);
        return result;
    }

    private final String tagName;

    /**
     * 隠しコンストラクタ
     * @param tagName 村名
     */
    private VillageTag(String tagName){
        this.tagName = tagName.intern();
        return;
    }

    /**
     * 村名を得る。
     * @return 村名
     */
    public String getTagName(){
        return this.tagName;
    }

    /**
     * 次のEnumメンバを得る。
     * @return 次のEnumメンバ
     */
    public VillageTag getNextVillageTag(){
        int ordinal = ordinal();
        ordinal = (ordinal+1) % enumCount;
        VillageTag result = values[ordinal];
        return result;
    }

    /**
     * 前のEnumメンバを得る。
     * @return 前のEnumメンバ
     */
    public VillageTag getPrevVillageTag(){
        int ordinal = ordinal();
        ordinal--;
        if(ordinal < 0) ordinal += enumCount;
        VillageTag result = values[ordinal];
        return result;
    }

}
