/*
 * team in game
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: Team.java 647 2009-08-09 05:30:09Z olyutorskii $
 */

package jp.sourceforge.jindolf.corelib;

/**
 * 陣営種別
 */
public enum Team{

    /** 村陣営 */
    VILLAGE ("村陣営"),
    /** 狼陣営 */
    WOLF    ("狼陣営"),
    /** ハムスター陣営 */
    HAMSTER ("ハムスター人間"),
    ;

    private final String teamName;

    /**
     * コンストラクタ
     * @param teamName 陣営名
     */
    private Team(String teamName){
        this.teamName = teamName.intern();
        return;
    }

    /**
     * チーム名を取得する
     * @return チーム名
     */
    public String getTeamName(){
        return this.teamName;
    }

}
