/*
 * decode exception
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: DecodeException.java 583 2009-08-03 17:58:40Z olyutorskii $
 */

package jp.sourceforge.jindolf.parser;

/**
 * デコード異常系情報。
 * {@link DecodeHandler}の各メソッドは、この例外をスローすることで
 * デコード処理の即時停止を{@link StreamDecoder}に指示することができる。
 * デコード元(バイトストリーム)の中のエラー発生位置と
 * デコード先(CharSequence)の中のエラー発生位置を保持することができる。
 * いずれの値も、エラー発生位置が不明な場合は負の値が設定される。
 */
@SuppressWarnings("serial")
public class DecodeException extends Exception{

    private final int bytePos;
    private final int charPos;

    /**
     * コンストラクタ
     */
    public DecodeException(){
        this(-1, -1, null);
        return;
    }

    /**
     * コンストラクタ
     * @param cause 原因の例外
     */
    public DecodeException(Throwable cause){
        this(-1, -1, cause);
        return;
    }

    /**
     * コンストラクタ
     * @param bytePos デコード元エラー発生位置
     * @param charPos デコード先エラー発生位置
     */
    public DecodeException(int bytePos, int charPos){
        this(bytePos, charPos, null);
        return;
    }

    /**
     * コンストラクタ
     * @param bytePos デコード元エラー発生位置
     * @param charPos デコード先エラー発生位置
     * @param cause 原因の例外
     */
    public DecodeException(int bytePos, int charPos, Throwable cause){
        super(cause);
        this.bytePos = bytePos;
        this.charPos = charPos;
        return;
    }

    /**
     * デコード元エラー発生位置を返す。
     * 単位はbyte単位。
     * @return エラー発生位置。不明な場合は負の値。
     */
    public int getBytePos(){
        return this.bytePos;
    }

    /**
     * デコード先エラー発生位置を返す。
     * 単位はchar単位。
     * @return エラー発生位置。不明な場合は負の値。
     */
    public int getCharPos(){
        return this.charPos;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    @Override
    public String getMessage(){
        return "bytePos=" + this.bytePos + " charPos=" + this.charPos;
    }

}
