/*
 * html handler adapter
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: HtmlAdapter.java 651 2009-08-09 06:19:25Z olyutorskii $
 */

package jp.sourceforge.jindolf.parser;

import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.corelib.TalkType;
import jp.sourceforge.jindolf.corelib.Team;
import jp.sourceforge.jindolf.corelib.VillageState;

/**
 * インタフェース{@link HtmlHandler}の抽象アダプタクラス。
 * このクラスのメソッド自身は何もしない。
 */
public abstract class HtmlAdapter implements HtmlHandler{

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void startParse(DecodedContent content)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param start {@inheritDoc}
     * @param end {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void pageTitle(DecodedContent content, int start, int end)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param start {@inheritDoc}
     * @param end {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void loginName(DecodedContent content, int start, int end)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param start {@inheritDoc}
     * @param end {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void villageName(DecodedContent content, int start, int end)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param month {@inheritDoc}
     * @param day {@inheritDoc}
     * @param hour {@inheritDoc}
     * @param minute {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void commitTime(int month, int day, int hour, int minute)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param anchorStart {@inheritDoc}
     * @param anchorEnd {@inheritDoc}
     * @param periodType {@inheritDoc}
     * @param day {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void periodLink(DecodedContent content,
                            int anchorStart, int anchorEnd,
                            PeriodType periodType, int day)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param urlStart {@inheritDoc}
     * @param urlEnd {@inheritDoc}
     * @param vnameStart {@inheritDoc}
     * @param vnameEnd {@inheritDoc}
     * @param hh {@inheritDoc}
     * @param mm {@inheritDoc}
     * @param state {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void villageRecord(DecodedContent content,
                                int urlStart, int urlEnd,
                                int vnameStart, int vnameEnd,
                                int hh, int mm,
                                VillageState state )
            throws HtmlParseException{
        return;
    }

    /**
     * 
     * @throws HtmlParseException {@inheritDoc}
     */
    public void endParse() throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void startTalk() throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void endTalk() throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param start {@inheritDoc}
     * @param end {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void talkId(DecodedContent content, int start, int end)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param start {@inheritDoc}
     * @param end {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void talkAvatar(DecodedContent content, int start, int end)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param hh {@inheritDoc}
     * @param mm {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void talkTime(int hh, int mm) throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param start {@inheritDoc}
     * @param end {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void talkIconUrl(DecodedContent content, int start, int end)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param type {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void talkType(TalkType type) throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param start {@inheritDoc}
     * @param end {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void talkText(DecodedContent content, int start, int end)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void talkBreak() throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param eventFamily {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void startSysEvent(EventFamily eventFamily)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param type {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventType(SysEventType type) throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void endSysEvent() throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param entryNo {@inheritDoc}
     * @param avatarStart {@inheritDoc}
     * @param avatarEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventOnStage(DecodedContent content,
                                  int entryNo,
                                  int avatarStart, int avatarEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param role {@inheritDoc}
     * @param num {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventOpenRole(GameRole role, int num)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param avatarStart {@inheritDoc}
     * @param avatarEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventSurvivor(DecodedContent content,
                                   int avatarStart, int avatarEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param voteByStart {@inheritDoc}
     * @param voteByEnd {@inheritDoc}
     * @param voteToStart {@inheritDoc}
     * @param voteToEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventCounting(DecodedContent content,
                                   int voteByStart, int voteByEnd,
                                   int voteToStart, int voteToEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param avatarStart {@inheritDoc}
     * @param avatarEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventSuddenDeath(DecodedContent content,
                                       int avatarStart, int avatarEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param avatarStart {@inheritDoc}
     * @param avatarEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventMurdered(DecodedContent content,
                                   int avatarStart, int avatarEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param avatarStart {@inheritDoc}
     * @param avatarEnd {@inheritDoc}
     * @param urlStart {@inheritDoc}
     * @param urlEnd {@inheritDoc}
     * @param idStart {@inheritDoc}
     * @param idEnd {@inheritDoc}
     * @param isLiving {@inheritDoc}
     * @param role {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventPlayerList(DecodedContent content,
                                     int avatarStart, int avatarEnd,
                                     int urlStart, int urlEnd,
                                     int idStart, int idEnd,
                                     boolean isLiving,
                                     GameRole role)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param judgeByStart {@inheritDoc}
     * @param judgeByEnd {@inheritDoc}
     * @param judgeToStart {@inheritDoc}
     * @param judgeToEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventJudge(DecodedContent content,
                                int judgeByStart, int judgeByEnd,
                                int judgeToStart, int judgeToEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param guardByStart {@inheritDoc}
     * @param guardByEnd {@inheritDoc}
     * @param guardToStart {@inheritDoc}
     * @param guardToEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventGuard(DecodedContent content,
                                int guardByStart, int guardByEnd,
                                int guardToStart, int guardToEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param hh {@inheritDoc}
     * @param mm {@inheritDoc}
     * @param minLimit {@inheritDoc}
     * @param maxLimit {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventAskEntry(int hh, int mm,
                                   int minLimit, int maxLimit)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param hh {@inheritDoc}
     * @param mm {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventAskCommit(int hh, int mm) throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param avatarStart {@inheritDoc}
     * @param avatarEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventNoComment(DecodedContent content,
                                    int avatarStart, int avatarEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param winner {@inheritDoc}
     * @param hh {@inheritDoc}
     * @param mm {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventStayEpilogue(Team winner, int hh, int mm)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param contentStart {@inheritDoc}
     * @param contentEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventContent(DecodedContent content,
                                  int contentStart, int contentEnd)
            throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventContentBreak() throws HtmlParseException{
        return;
    }

    /**
     * {@inheritDoc}
     * @param content {@inheritDoc}
     * @param urlStart {@inheritDoc}
     * @param urlEnd {@inheritDoc}
     * @param contentStart {@inheritDoc}
     * @param contentEnd {@inheritDoc}
     * @throws HtmlParseException {@inheritDoc}
     */
    public void sysEventContentAnchor(DecodedContent content,
                                         int urlStart, int urlEnd,
                                         int contentStart, int contentEnd)
            throws HtmlParseException{
        return;
    }

}
